<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8 border-t-4 border-green-600">
    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">گزارش عملکرد شما در این طرح</h3>
    @if($totalTasks > 0)
        <div class="space-y-6">
            {{-- [NEW] بخش درصد پیشرفت --}}
            <div>
                <div class="flex justify-between mb-1">
                    <span class="text-base font-medium text-gray-700 dark:text-gray-300">درصد پیشرفت</span>
                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">{{ $completionPercentage }}%</span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-2.5 dark:bg-gray-700">
                    <div class="bg-green-600 h-2.5 rounded-full" style="width: {{ $completionPercentage }}%"></div>
                </div>
            </div>

            {{-- آمار عددی --}}
            <div class="grid grid-cols-3 gap-4 text-center pt-2">
                <div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">کل وظایف شما</p>
                    <p class="text-3xl font-bold text-gray-900 dark:text-white mt-1">{{ $totalTasks }}</p>
                </div>
                <div>
                    <p class="text-sm text-green-500">انجام شده</p>
                    <p class="text-3xl font-bold text-green-500 mt-1">{{ $completedTasks }}</p>
                </div>
                <div>
                    <p class="text-sm text-yellow-500">در حال انجام</p>
                    <p class="text-3xl font-bold text-yellow-500 mt-1">{{ $inProgressTasks }}</p>
                </div>
            </div>
        </div>
    @else
        <p class="text-center text-sm text-gray-500 py-4">هنوز هیچ وظیفه‌ای به شما در این طرح محول نشده است.</p>
    @endif
</div>
