<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
    <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">بورد اطلاعیه‌ها</h3>
        @can('create', [\App\Models\ProjectAnnouncement::class, $project])
            <x-button wire:click="confirmAnnouncementAction">
                <x-lucide-plus class="w-4 h-4 ml-2"/>
                ایجاد اطلاعیه جدید
            </x-button>
        @endcan
    </div>

    @if (session()->has('announcement_message'))
        <div class="mt-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300" role="alert">
            {{ session('announcement_message') }}
        </div>
    @endif

    <div class="mt-6 space-y-4">
        @forelse($announcements as $announcement)
            @php
                $levelClasses = [
                    'info' => 'border-blue-500 bg-blue-50 dark:bg-blue-900/20',
                    'warning' => 'border-yellow-500 bg-yellow-50 dark:bg-yellow-900/20',
                    'danger' => 'border-red-500 bg-red-50 dark:bg-red-900/20',
                ];
                $iconClasses = [
                    'info' => 'text-blue-500',
                    'warning' => 'text-yellow-500',
                    'danger' => 'text-red-500',
                ];
                $icon = [
                    'info' => 'lucide-info',
                    'warning' => 'lucide-alert-triangle',
                    'danger' => 'lucide-alert-octagon',
                ];
            @endphp
            <div class="p-4 rounded-lg border-r-4 {{ $levelClasses[$announcement->level] }}">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <x-dynamic-component :component="$icon[$announcement->level]" class="w-6 h-6 flex-shrink-0 {{ $iconClasses[$announcement->level] }}" />
                        <h4 class="font-bold text-gray-900 dark:text-white">{{ $announcement->title }}</h4>
                    </div>
                    @can('update', $announcement)
                        <div class="flex items-center gap-4">
                            <button wire:click="togglePin({{ $announcement->id }})" title="سنجاق کردن">
                                <x-lucide-pin class="w-5 h-5 transition-colors {{ $announcement->is_pinned ? 'text-yellow-500' : 'text-gray-400 hover:text-yellow-500' }}" />
                            </button>
                            <button wire:click="confirmAnnouncementAction({{ $announcement->id }})" class="text-gray-400 hover:text-indigo-600">
                                <x-lucide-file-pen-line class="w-5 h-5"/>
                            </button>
                            @can('delete', $announcement)
                                <button wire:click="confirmAnnouncementDeletion({{ $announcement->id }})" class="text-gray-400 hover:text-red-600">
                                    <x-lucide-trash-2 class="w-5 h-5"/>
                                </button>
                            @endcan
                        </div>
                    @endcan
                </div>
                <div class="mt-2 pr-9 text-sm text-gray-700 dark:text-gray-300 prose max-w-none">
                    {!! $announcement->body !!}
                </div>
                {{-- [NEW] نمایش لیست پیوست‌ها --}}
                @if($announcement->attachments->isNotEmpty())
                    <div class="mt-4">
                        <p class="text-xs font-semibold text-gray-500 mb-2">فایل‌های پیوست:</p>
                        <div class="flex flex-wrap gap-2">
                            @foreach($announcement->attachments as $attachment)
                                <a href="{{ Storage::url($attachment->file_path) }}" target="_blank" class="flex items-center gap-2 p-2 text-xs bg-gray-100 dark:bg-gray-700 rounded-md hover:bg-gray-200 dark:hover:bg-gray-600">
                                    <x-lucide-paperclip class="w-3 h-3"/>
                                    <span>{{ $attachment->file_name }}</span>
                                </a>
                            @endforeach
                        </div>
                    </div>
                @endif
                <p class="text-xs text-gray-500 dark:text-gray-400 text-left mt-3">
                    توسط {{ $announcement->user->name }} در {{ verta($announcement->created_at)->format('Y/m/d') }}
                </p>
            </div>
        @empty
            <div class="text-center py-8 border-2 border-dashed border-gray-300 dark:border-gray-700 rounded-lg">
                <x-lucide-megaphone class="mx-auto h-12 w-12 text-gray-400" />
                <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">هنوز اطلاعیه‌ای ثبت نشده</h3>
                <p class="mt-1 text-sm text-gray-500">برای شروع، یک اطلاعیه جدید ایجاد کنید.</p>
            </div>
        @endforelse
    </div>

    <!-- Create/Edit Announcement Modal -->
    <x-dialog-modal wire:model.live="confirmingAnnouncementAction">
        <x-slot name="title">
            {{ $editingAnnouncement ? 'ویرایش اطلاعیه' : 'ایجاد اطلاعیه جدید' }}
        </x-slot>

        <x-slot name="content">
            <div class="space-y-4">
                <div>
                    <x-label for="title" value="عنوان" />
                    <x-input id="title" type="text" class="mt-1 block w-full" wire:model.defer="state.title" />
                    <x-input-error for="state.title" class="mt-2" />
                </div>
                <div>
                    <x-label for="body" value="متن اطلاعیه" />
                    <textarea id="body" class="border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm mt-1 block w-full" wire:model.defer="state.body" rows="6"></textarea>
                    <x-input-error for="state.body" class="mt-2" />
                </div>
                <div>
                    <x-label for="level" value="سطح اهمیت" />
                    <select id="level" wire:model.defer="state.level" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="info">اطلاع‌رسانی</option>
                        <option value="warning">هشدار</option>
                        <option value="danger">خطر</option>
                    </select>
                </div>
                <div class="flex items-center">
                    <x-checkbox id="is_pinned" wire:model.defer="state.is_pinned" />
                    <label for="is_pinned" class="ms-2 text-sm text-gray-600 dark:text-gray-400">سنجاق کردن در بالای بورد</label>
                </div>
            </div>
            {{-- [NEW] بخش آپلود فایل --}}
            <div>
                <x-label for="newAttachments" value="افزودن پیوست (PDF, JPG, PNG)" />
                <input type="file" id="newAttachments" wire:model="newAttachments" multiple class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100"/>
                <x-input-error for="newAttachments.*" class="mt-2" />

                <div wire:loading wire:target="newAttachments">در حال آپلود...</div>

                {{-- نمایش فایل‌های انتخاب شده برای آپلود --}}
                @if ($newAttachments)
                    <div class="mt-2 text-xs">فایل‌های آماده آپلود:</div>
                    <ul class="list-disc list-inside">
                        @foreach ($newAttachments as $file)
                            <li>{{ $file->getClientOriginalName() }}</li>
                        @endforeach
                    </ul>
                @endif
            </div>

            {{-- نمایش پیوست‌های موجود در حالت ویرایش --}}
            @if ($editingAnnouncement)
                <div class="border-t dark:border-gray-700 pt-4">
                    <h5 class="text-sm font-semibold">پیوست‌های موجود:</h5>
                    <div class="space-y-2 mt-2">
                        @foreach($existingAttachments as $attachment)
                            <div class="flex items-center justify-between p-2 text-sm bg-gray-100 dark:bg-gray-700 rounded-md">
                                <span>{{ $attachment['file_name'] }}</span>
                                <button type="button" wire:click="removeAttachment({{ $attachment['id'] }})" class="text-red-500 hover:text-red-700">
                                    <x-lucide-trash-2 class="w-4 h-4"/>
                                </button>
                            </div>
                        @endforeach
                    </div>
                </div>
    @endif
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingAnnouncementAction', false)" wire:loading.attr="disabled">
                انصراف
            </x-secondary-button>
            <x-button class="ms-3" wire:click="saveAnnouncement" wire:loading.attr="disabled">
                ذخیره
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Delete Confirmation Modal -->
    <x-confirmation-modal wire:model.live="confirmingAnnouncementDeletion">
        <x-slot name="title">
            حذف اطلاعیه
        </x-slot>

        <x-slot name="content">
            آیا از حذف این اطلاعیه مطمئن هستید؟
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingAnnouncementDeletion')" wire:loading.attr="disabled">
                انصراف
            </x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteAnnouncement" wire:loading.attr="disabled">
                حذف
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>
</div>
