<div>
    {{-- هدر صفحه --}}
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            جزئیات طرح: <span class="font-bold text-blue-600 dark:text-blue-400">{{ $project->title }}</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">
            {{-- بخش نمایش پیام‌ها --}}
            @if (session()->has('message'))
                <div class="p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300 shadow-md" role="alert">
                    <span class="font-medium">موفقیت!</span> {{ session('message') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="p-4 text-sm text-red-800 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300 shadow-md" role="alert">
                    <span class="font-medium">خطا!</span> {{ session('error') }}
                </div>
            @endif

            {{-- Widgets --}}
            @livewire('project-progress-dashboard', ['project' => $project], key('progress-dashboard-' . $project->id))
            @if(Auth::id() !== $project->owner_id && $project->collaborators->contains(Auth::user()))
                @livewire('my-task-stats', ['project' => $project], key('my-stats-for-project-' . $project->id))
            @endif
            @livewire('project-announcement-board', ['project' => $project], key('announcements-for-project-' . $project->id))

            @include('livewire.project-detail.collaborators-card')
{{--            @livewire('lab-notebook', ['project' => $project], key('notebook-for-project-' . $project->id))--}}


            {{-- Main Content with Tabs --}}
            <div x-data="{ activeTab: @entangle('activeTab').live }">
                <!-- Tab Headers -->
                <div class="border-b border-gray-200 dark:border-gray-700 mb-4">
                    <nav class="-mb-px flex space-x-6 space-x-reverse" aria-label="Tabs">
                        <a href="#" @click.prevent="activeTab = 'tasks'"
                           :class="{ 'border-purple-500 text-purple-600': activeTab === 'tasks', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'tasks' }"
                           class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                            مدیریت وظایف
                        </a>
                        <a href="#" @click.prevent="activeTab = 'notebook'"
                           :class="{ 'border-purple-500 text-purple-600': activeTab === 'notebook', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'notebook' }"
                           class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                            دفترچه یادداشت
                        </a>
                        {{-- [NEW] Timeline Tab --}}
                        <a href="#" @click.prevent="activeTab = 'timeline'"
                           :class="{ 'border-purple-500 text-purple-600': activeTab === 'timeline', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'timeline' }"
                           class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                            تایم‌لاین
                        </a>
                        <a href="#" @click.prevent="activeTab = 'details'"
                           :class="{ 'border-purple-500 text-purple-600': activeTab === 'details', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'details' }"
                           class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                            مدیریت طرح
                        </a>
                    </nav>
                </div>

                <!-- Tab Content -->
                <div>
                    <div x-show="activeTab === 'tasks'" x-cloak>
                        @livewire(\App\Livewire\ProjectTaskManager::class, ['project' => $project], key('tasks-for-project-' . $project->id))
                        @livewire(\App\Livewire\ProjectKanbanBoard::class, ['project' => $project], key('kanban-for-project-' . $project->id))
                        @livewire(\App\Livewire\ProjectGanttChart::class, ['project' => $project], key('gantt-for-project-' . $project->id))
                        @can('viewCollaboratorReports', $project)
                            <div x-show="activeTab === 'report'" x-cloak>
                                <div
                                    x-data="{ selectedUserId: '' }"
                                    class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8"
                                >
                                    <h4 class="text-lg font-semibold text-gray-900 dark:text-white">انتخاب همکار برای مشاهده گزارش</h4>
                                    <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                        لطفاً یکی از اعضای تیم را انتخاب کرده و سپس روی دکمه "نمایش گزارش" کلیک کنید تا گزارش عملکرد او در یک پنجره جدید باز شود.
                                    </p>
                                    <div class="mt-4 flex items-end gap-4">
                                        <div class="flex-grow">
                                            <x-label for="report_user_id" value="انتخاب همکار" />
                                            <select x-model="selectedUserId" id="report_user_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                                <option value="">-- انتخاب کنید --</option>
                                                @foreach($project->collaborators->push($project->owner)->unique('id') as $user)
                                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <x-button
                                            @click="if (selectedUserId) { window.open(`/projects/{{ $project->sku }}/reports/${selectedUserId}`, '_blank') }"
                                        >
                                            نمایش گزارش
                                        </x-button>
                                    </div>
                                </div>
                            </div>
                        @endcan

                    </div>
                    <div x-show="activeTab === 'notebook'" x-cloak>
                        @livewire('lab-notebook', ['project' => $project], key('notebook-for-project-' . $project->id))
                    </div>
                    {{-- [NEW] Timeline Content --}}
                    <div x-show="activeTab === 'timeline'" x-cloak>
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                            @livewire('project-timeline', ['project' => $project], key('timeline-for-project-' . $project->id))
                        </div>
                    </div>
                    <div x-show="activeTab === 'details'" x-cloak class="space-y-8">
                        {{-- All the management cards go here --}}
                        @include('livewire.project-detail.details-card')
                    @can('update', $project)
                            @include('livewire.project-detail.warehouse-manager-card')
                        @endcan
                        @include('livewire.project-detail.budget-card')
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- All Modals --}}
    @include('livewire.project-detail.modal-edit-project')
    @include('livewire.project-detail.modal-add-collaborator')
    @include('livewire.project-detail.modal-edit-permissions')
    @include('livewire.project-detail.modal-remove-collaborator')
    @include('livewire.project-detail.modal-add-protocol')
    @include('livewire.project-detail.modal-remove-protocol')
    @include('livewire.project-detail.modal-manage-budget')
    @include('livewire.project-detail.modal-edit-budget')
    @include('livewire.project-detail.modal-remove-budget-item')
</div>
