{{-- ==[ NEW ]== کارت مدیریت بودجه مواد --}}
<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-green-600">
    <div class="p-6 sm:p-8">
        <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">مدیریت بودجه مواد</h3>
            @can('manageBudget', $project)
                <x-button class="bg-green-600 hover:bg-green-700" wire:click="confirmBudgetManagement">
                    <x-lucide-clipboard-list class="w-4 h-4 ml-2"/>
                    تعیین حق دسترسی به مواد
                </x-button>
            @endcan
        </div>

        <div class="mt-6 flow-root">
            <div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                        <tr>
                            <th scope="col" class="py-3.5 pl-4 pr-3 text-right text-sm font-semibold text-gray-900 dark:text-white sm:pl-0">نام ماده</th>
                            @if(Auth::id() === $project->owner_id)
                                <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">موجودی انبار</th>
                            @endif
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">سقف مجاز</th>
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">مصرف شده</th>
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">باقیمانده سقف</th>
                            <th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-0"><span class="sr-only">عملیات</span></th>
                        </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
                        @forelse ($project->budgetItems as $item)
                            <tr>
                                <td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-gray-900 dark:text-white sm:pl-0">{{ $item->name }}</td>
                                @if(Auth::id() === $project->owner_id)
                                    <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $item->quantity }} {{ $item->unit }}</td>
                                @endif
                                <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $item->pivot->max_allowed_quantity }} {{ $item->unit }}</td>
                                <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $item->pivot->total_consumed_quantity }} {{ $item->unit }}</td>
                                <td class="whitespace-nowrap px-3 py-4 text-sm font-bold {{ ($item->pivot->max_allowed_quantity - $item->pivot->total_consumed_quantity) > 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                    {{ $item->pivot->max_allowed_quantity - $item->pivot->total_consumed_quantity }} {{ $item->unit }}
                                </td>
                                @can('manageBudget', $project)
                                    <td class="relative whitespace-nowrap py-4 pl-3 pr-4 text-left text-sm font-medium sm:pr-0 space-x-4 space-x-reverse">
                                        <button wire:click="confirmBudgetEdit({{ $item->pivot->id }})" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 transition">تغییر</button>
                                        <button wire:click="confirmBudgetItemRemoval({{ $item->pivot->id }})" class="text-red-600 hover:text-red-800 dark:text-red-500 dark:hover:text-red-400 transition">حذف</button>
                                    </td>
                                @endcan
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="py-8 text-center text-sm text-gray-500 dark:text-gray-400">
                                    <x-lucide-flask-conical class="mx-auto h-12 w-12 text-gray-400" />
                                    <h3 class="mt-2 font-medium text-gray-900 dark:text-white">هیچ بودجه‌ای برای مواد تعریف نشده</h3>
                                    <p class="mt-1">برای شروع، مواد مجاز برای مصرف در این طرح را مشخص کنید.</p>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
