{{-- کارت مدیریت همکاران --}}
<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-blue-600">
    <div class="p-6 sm:p-8">
        <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">همکاران طرح</h3>
            @can('manageCollaborators', $project)
                <x-button wire:click="confirmCollaboratorAddition">
                    <x-lucide-user-plus class="w-4 h-4 ml-2"/>
                    افزودن همکار
                </x-button>
            @endcan
        </div>

        <div class="mt-6 flow-root">
            <div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                        <tr>
                            <th scope="col" class="py-3.5 pl-4 pr-3 text-right text-sm font-semibold text-gray-900 dark:text-white sm:pl-0">نام همکار</th>
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">نقش در پروژه</th>
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">دسترسی‌ها</th>
                            <th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-0"><span class="sr-only">عملیات</span></th>
                        </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
                        @forelse ($project->collaborators as $collaborator)
                            <tr>
                                <td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-gray-900 dark:text-white sm:pl-0">{{ $collaborator->first_name }} {{ $collaborator->last_name }}</td>
                                <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500 dark:text-gray-400">
                                    <span class="badge badge-primary">{{ $collaborator->pivot->project_role}}</span>
                                </td>
                                <td class="px-3 py-4 text-sm text-gray-500 dark:text-gray-400">
                                    <div class="flex flex-wrap gap-1">
                                        @forelse($collaborator->projectPermissions as $permission)
                                            <span class="badge badge-secondary">{{ $permission->name }}</span>
                                        @empty
                                            <span class="text-xs text-gray-400 italic">پیش‌فرض نقش</span>
                                        @endforelse
                                    </div>
                                </td>
                                <td class="relative whitespace-nowrap py-4 pl-3 pr-4 text-left text-sm font-medium sm:pr-0 space-x-4 space-x-reverse">
                                    @can('manageCollaborators', $project)
                                        <button wire:click="confirmPermissionEdit({{ $collaborator->id }})" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 transition">ویرایش دسترسی</button>
                                        <button wire:click="confirmCollaboratorRemoval({{ $collaborator->id }})" class="text-red-600 hover:text-red-800 dark:text-red-500 dark:hover:text-red-400 transition">حذف</button>
                                    @endcan
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="py-8 text-center text-sm text-gray-500 dark:text-gray-400">
                                    <x-lucide-users class="mx-auto h-12 w-12 text-gray-400" />
                                    <h3 class="mt-2 font-medium text-gray-900 dark:text-white">هیچ همکاری ثبت نشده</h3>
                                    <p class="mt-1">برای شروع، یک همکار جدید به طرح اضافه کنید.</p>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
