{{-- کارت اطلاعات کلی طرح --}}
<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-blue-600">
    <div class="p-6 sm:p-8">
        <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                اطلاعات کلی طرح
            </h3>
            <div class="flex items-center gap-2">
                {{-- [NEW] دکمه دریافت گزارش --}}
                @can('viewProjectReport', $project)
                    <a href="{{ route('projects.report', $project) }}" target="_blank" class="inline-flex items-center px-4 py-2 bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700">
                        <x-lucide-file-text class="w-4 h-4 ml-2"/>
                        دریافت گزارش
                    </a>
                @endcan
                <x-button wire:click="confirmProjectEdit">
                    <x-lucide-file-pen-line class="w-4 h-4 ml-2"/>
                    ویرایش اطلاعات طرح
                </x-button>
            </div>
        </div>

        <div class="mt-6 border-t border-gray-200 dark:border-gray-700">
            <dl class="grid grid-cols-1 sm:grid-cols-2 xl:grid-cols-3 gap-x-6 gap-y-8 pt-6">
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">کد شناسایی</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white font-mono">{{ $project->sku }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">وضعیت</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white"><span class="px-2 py-1 text-xs font-medium rounded-full bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">{{ $project->status }}</span></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">نوع</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white">{{ $project->type }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">نهاد</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white">{{ $project->researchTeam->name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">مالک طرح</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white">{{ $project->owner->first_name }} {{ $project->owner->last_name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">بودجه (تومان)</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white">{{ $project->budget ? number_format($project->budget) : '-' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">تاریخ تصویب</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white">{{ $project->approval_date ? verta($project->approval_date)->format('Y/m/d') : '-' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">تاریخ شروع</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white">{{ $project->start_date ? verta($project->start_date)->format('Y/m/d') : '-' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">تاریخ پایان</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white">{{ $project->end_date ? verta($project->end_date)->format('Y/m/d') : '-' }}</dd>
                </div>
                <div class="sm:col-span-2 xl:col-span-3">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">شرح</dt>
                    <dd class="mt-1 text-md text-gray-900 dark:text-white prose dark:prose-invert max-w-none">
                        {{ $project->description ?? 'شرحی ارائه نشده است.' }}
                    </dd>
                </div>
            </dl>
        </div>
    </div>
</div>
