<!-- Modal برای افزودن همکار جدید -->
<x-dialog-modal wire:model.live="confirmingCollaboratorAddition" maxWidth="2xl">
    <x-slot name="title">
        <div class="flex items-center">
            <x-lucide-user-plus class="w-6 h-6 ml-2 text-blue-500"/>
            <span class="text-lg font-bold text-gray-900 dark:text-gray-100">{{ __('افزودن همکار به طرح') }}</span>
        </div>
    </x-slot>

    <x-slot name="content">
        <div class="space-y-6">
            {{-- بخش جستجوی کاربر --}}
            <div class="relative">
                <x-label for="search" value="{{ __('جستجوی کاربر (بر اساس نام، ایمیل یا شناسه کاربری)') }}" />
                <div class="relative mt-1">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <x-lucide-search class="w-5 h-5 text-gray-400"/>
                    </div>
                    <x-input id="search" type="text" class="block w-full pl-10"
                             wire:model.live.debounce.300ms="search"
                             placeholder="شروع به تایپ کنید..."
                             autocomplete="off"
                    />
                </div>
                @if(count($searchResults) > 0)
                    <ul class="absolute z-50 w-full bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-md mt-1 max-h-56 overflow-y-auto shadow-lg">
                        @foreach($searchResults as $result)
                            <li class="flex items-center px-4 py-3 cursor-pointer hover:bg-blue-50 dark:hover:bg-blue-900/50"
                                wire:click="selectUser({{ $result->id }})">
                                <img class="h-10 w-10 rounded-full object-cover" src="{{ $result->profile_photo_url }}" alt="{{ $result->first_name }}">
                                <div class="ms-3">
                                    <div class="font-bold text-gray-800 dark:text-gray-200">{{ $result->first_name }} {{ $result->last_name }}</div>
                                    <div class="text-sm text-gray-500 dark:text-gray-400">@ {{ $result->username }}</div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                @endif
                <x-input-error for="userIdToAdd" class="mt-2" />
            </div>

            {{-- بخش انتخاب نقش --}}
            <div>
                <x-label for="roleIdToAdd" value="{{ __('نقش در پروژه') }}" />
                <select id="roleIdToAdd" wire:model.live="roleIdToAdd" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <option value="">انتخاب کنید...</option>
                    @foreach($assignableRoles as $role)
                        <option value="{{ $role->id }}">{{ $role->name }}</option>
                    @endforeach
                </select>
                <x-input-error for="roleIdToAdd" class="mt-2" />
            </div>

            {{-- بخش مدیریت دسترسی‌های سفارشی --}}
            @if($roleIdToAdd && count($permissionsForSelectedRole) > 0)
                <div class="border-t border-gray-200 dark:border-gray-700 pt-4">
                    <x-label value="{{ __('دسترسی‌های سفارشی (پیش‌فرض‌های نقش انتخاب شده)') }}" />
                    <div class="mt-3 grid grid-cols-2 md:grid-cols-3 gap-4">
                        @foreach($permissionsForSelectedRole as $permission)
                            <label for="permission-{{ $permission->id }}" class="flex items-center p-2 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700/50">
                                <x-checkbox id="permission-{{ $permission->id }}" wire:model.live="customPermissions" value="{{ $permission->id }}" />
                                <span class="ms-2 text-sm text-gray-700 dark:text-gray-300">{{ $permission->name }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </x-slot>

    <x-slot name="footer">
        <x-secondary-button wire:click="$toggle('confirmingCollaboratorAddition')" wire:loading.attr="disabled">
            {{ __('انصراف') }}
        </x-secondary-button>
        <x-button class="ms-3 bg-blue-600 hover:bg-blue-700 focus:ring-blue-500" wire:click="addCollaborator" wire:loading.attr="disabled">
            {{ __('افزودن همکار') }}
        </x-button>
    </x-slot>
</x-dialog-modal>
