<!-- Modal برای افزودن پروتکل -->
<x-dialog-modal wire:model.live="confirmingProtocolAddition">
    <x-slot name="title">
        {{ __('افزودن پروتکل به طرح') }}
    </x-slot>
    <x-slot name="content">
        <div class="grid grid-cols-6 gap-6">
            <div class="col-span-6">
                <x-label for="protocolIdToAdd" value="{{ __('انتخاب پروتکل') }}" />
                <select id="protocolIdToAdd" wire:model.defer="protocolIdToAdd" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                    <option value="">انتخاب کنید...</option>
                    @foreach($protocols as $protocol)
                        <option value="{{ $protocol->id }}">{{ $protocol->name }} (v{{ $protocol->version }})</option>
                    @endforeach
                </select>
                <x-input-error for="protocolIdToAdd" class="mt-2" />
            </div>
        </div>
    </x-slot>
    <x-slot name="footer">
        <x-secondary-button wire:click="$toggle('confirmingProtocolAddition')" wire:loading.attr="disabled">
            {{ __('انصراف') }}
        </x-secondary-button>
        <x-button class="ms-3" wire:click="addProtocol" wire:loading.attr="disabled">
            {{ __('افزودن') }}
        </x-button>
    </x-slot>
</x-dialog-modal>
