<!-- Modal برای ویرایش دسترسی‌های همکار -->
<x-dialog-modal wire:model.live="confirmingPermissionEdit" maxWidth="2xl">
    <x-slot name="title">
        <div class="flex items-center">
            <x-lucide-shield-check class="w-6 h-6 ml-2 text-blue-500"/>
            <span class="text-lg font-bold text-gray-900 dark:text-gray-100">ویرایش دسترسی‌ها</span>
        </div>
        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">کاربر: {{ $editingCollaborator?->first_name }} {{ $editingCollaborator?->last_name }}</p>
    </x-slot>

    <x-slot name="content">
        <div class="pt-4">
            <x-label value="{{ __('دسترسی‌های سفارشی در این طرح') }}" />
            <div class="mt-3 grid grid-cols-2 md:grid-cols-3 gap-4">
                @foreach($permissionsForSelectedRole as $permission)
                    <label for="edit-permission-{{ $permission->id }}" class="flex items-center p-2 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700/50">
                        <x-checkbox id="edit-permission-{{ $permission->id }}" wire:model.live="customPermissions" value="{{ $permission->id }}" />
                        <span class="ms-2 text-sm text-gray-700 dark:text-gray-300">{{ $permission->name }}</span>
                    </label>
                @endforeach
            </div>
        </div>
    </x-slot>

    <x-slot name="footer">
        <x-secondary-button wire:click="$set('confirmingPermissionEdit', false)" wire:loading.attr="disabled">
            {{ __('انصراف') }}
        </x-secondary-button>
        <x-button class="ms-3 bg-blue-600 hover:bg-blue-700 focus:ring-blue-500" wire:click="updatePermissions" wire:loading.attr="disabled">
            {{ __('ذخیره تغییرات') }}
        </x-button>
    </x-slot>
</x-dialog-modal>
