<!-- Modal برای ویرایش طرح -->
<x-dialog-modal wire:model.live="confirmingProjectEdit">
    <x-slot name="title">
        {{ __('ویرایش اطلاعات طرح') }}
    </x-slot>

    <x-slot name="content">
        <div class="grid grid-cols-6 gap-6">
            <div class="col-span-6">
                <x-label for="editing-title" value="{{ __('عنوان طرح') }}" />
                <x-input id="editing-title" type="text" class="mt-1 block w-full" wire:model.defer="editingState.title" />
                <x-input-error for="editingState.title" class="mt-2" />
            </div>

            <div class="col-span-6 sm:col-span-3">
                <x-label for="editing-type" value="{{ __('نوع طرح') }}" />
                <select id="editing-type" wire:model.defer="editingState.type" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                    <option value="approved">مصوب</option>
                    <option value="thesis">پایان‌نامه</option>
                    <option value="personal">شخصی</option>
                </select>
                <x-input-error for="editingState.type" class="mt-2" />
            </div>

            <div class="col-span-6 sm:col-span-3">
                <x-label for="editing-status" value="{{ __('وضعیت طرح') }}" />
                <select id="editing-status" wire:model.defer="editingState.status" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                    <option value="معلق">معلق</option>
                    <option value="در حال اجرا">در حال اجرا</option>
                    <option value="نیاز به اجرا مجدد">نیاز به اجرا مجدد</option>
                    <option value="شکست خورده">شکست خورده</option>
                    <option value="کامل شده">کامل شده</option>
                </select>
                <x-input-error for="editingState.status" class="mt-2" />
            </div>

            <div class="col-span-6 sm:col-span-3">
                <x-label for="editing-budget" value="{{ __('بودجه مصوب (تومان)') }}" />
                <x-input id="editing-budget" type="number" class="mt-1 block w-full" wire:model.defer="editingState.budget" />
                <x-input-error for="editingState.budget" class="mt-2" />
            </div>

            <div class="col-span-6 sm:col-span-3">
                <x-label for="editing-approval_date" value="{{ __('تاریخ تصویب') }}" />
                <x-input id="editing-approval_date" type="date" class="mt-1 block w-full" wire:model.defer="editingState.approval_date" />
                <x-input-error for="editingState.approval_date" class="mt-2" />
            </div>

            <div class="col-span-6 sm:col-span-3">
                <x-label for="editing-start_date" value="{{ __('تاریخ شروع') }}" />
                <x-input id="editing-start_date" type="date" class="mt-1 block w-full" wire:model.defer="editingState.start_date" />
                <x-input-error for="editingState.start_date" class="mt-2" />
            </div>

            <div class="col-span-6 sm:col-span-3">
                <x-label for="editing-end_date" value="{{ __('تاریخ پایان') }}" />
                <x-input id="editing-end_date" type="date" class="mt-1 block w-full" wire:model.defer="editingState.end_date" />
                <x-input-error for="editingState.end_date" class="mt-2" />
            </div>

            <div class="col-span-6">
                <x-label for="editing-description" value="{{ __('شرح مختصر') }}" />
                <textarea id="editing-description" class="border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm mt-1 block w-full" wire:model.defer="editingState.description"></textarea>
                <x-input-error for="editingState.description" class="mt-2" />
            </div>
        </div>
    </x-slot>

    <x-slot name="footer">
        <x-secondary-button wire:click="$set('confirmingProjectEdit', false)" wire:loading.attr="disabled">
            {{ __('انصراف') }}
        </x-secondary-button>

        <x-button class="ms-3" wire:click="updateProject" wire:loading.attr="disabled">
            {{ __('ذخیره تغییرات') }}
        </x-button>
    </x-slot>
</x-dialog-modal>
