<!-- ==[ NEW ]== Modal برای مدیریت بودجه مواد -->
<x-dialog-modal wire:model.live="confirmingBudgetManagement">
    <x-slot name="title">
        {{ __('مدیریت بودجه مواد طرح') }}
    </x-slot>
    <x-slot name="content">
        @if (session()->has('budget_message'))
            <div class="p-3 mb-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300" role="alert">
                {{ session('budget_message') }}
            </div>
        @endif

        <div class="space-y-4">
            <div class="relative">
                <x-label for="inventoryItemSearch" value="{{ __('جستجوی ماده از انبار تیم') }}" />
                <x-input id="inventoryItemSearch" type="text" class="mt-1 block w-full"
                         wire:model.live.debounce.300ms="inventoryItemSearch"
                         placeholder="نام ماده را تایپ کنید..."
                         autocomplete="off" />
                @if(count($inventorySearchResults) > 0)
                    <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto shadow-lg">
                        @foreach($inventorySearchResults as $result)
                            <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                wire:click="selectInventoryItem({{ $result->id }})">
                                <div class="font-bold text-gray-800 dark:text-gray-200">{{ $result->name }}</div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">موجودی: {{ $result->quantity }} {{ $result->unit }}</div>
                            </li>
                        @endforeach
                    </ul>
                @endif
                <x-input-error for="selectedInventoryItemId" class="mt-2" />
            </div>

            <div>
                <x-label for="max_allowed_quantity" value="{{ __('حداکثر مقدار مجاز مصرف') }}" />
                <x-input id="max_allowed_quantity" type="number" step="0.01" class="mt-1 block w-full"
                         wire:model.defer="max_allowed_quantity" />
                <x-input-error for="max_allowed_quantity" class="mt-2" />
            </div>

            <div>
                <x-button wire:click="addBudgetItem" wire:loading.attr="disabled">
                    <x-lucide-plus class="w-4 h-4 ml-2"/>
                    افزودن به بودجه
                </x-button>
            </div>
        </div>

    </x-slot>
    <x-slot name="footer">
        <x-secondary-button wire:click="$set('confirmingBudgetManagement', false)" wire:loading.attr="disabled">
            {{ __('بستن') }}
        </x-secondary-button>
    </x-slot>
</x-dialog-modal>
