    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-orange-500">
        <div class="p-6 sm:p-8">
            <div class="flex items-start gap-4">
                <div class="flex-shrink-0">
                    <x-lucide-user-check class="w-8 h-8 text-orange-500 dark:text-orange-400"/>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">تعیین مسئول گردش انبار</h3>
                    <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                        یک نفر از همکاران طرح را به عنوان مسئول تایید درخواست‌های مصرف و بازگشت مواد انتخاب کنید.
                    </p>
                </div>
            </div>

            @if($project->warehouseManager)
                <div class="mt-6 p-4 bg-blue-50 dark:bg-blue-900/50 rounded-lg border border-blue-200 dark:border-blue-800">
                    <p class="text-sm text-gray-800 dark:text-gray-200">
                        <span class="font-medium">مسئول فعلی:</span>
                        <span class="font-bold">{{ $project->warehouseManager->name }}</span>
                    </p>
                </div>
            @endif

            <div class="mt-6">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                    <div class="md:col-span-2">
                        <x-label for="warehouseManagerId" value="انتخاب مسئول جدید" />
                        <select id="warehouseManagerId" wire:model.defer="warehouseManagerId" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">-- هیچکس (حذف مسئول) --</option>
                            @foreach($project->collaborators as $collaborator)
                                <option value="{{ $collaborator->id }}">{{ $collaborator->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <x-button wire:click="assignWarehouseManager" class="w-full justify-center py-2.5 bg-blue-600 hover:bg-blue-700 focus:ring-blue-500">
                            <x-lucide-save class="w-4 h-4 ml-2"/>
                            ذخیره
                        </x-button>
                    </div>
                </div>
            </div>
        </div>
    </div>
