<div
    x-data="{
        draggedTaskId: null,
        onDragStart(event, taskId) {
            event.dataTransfer.effectAllowed = 'move';
            this.draggedTaskId = taskId;
        },
        onDrop(event, newStatus) {
            if (this.draggedTaskId) {
                $wire.onTaskDrop(this.draggedTaskId, newStatus);
                this.draggedTaskId = null;
            }
        }
    }"
    class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-teal-600 p-6 sm:p-8"
    wire:poll.10s="loadTasks"
>
    <!-- Kanban Board -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        @php
            $statuses = ['برای انجام', 'در حال انجام', 'انجام شده'];
            $statusColors = [
                'برای انجام' => 'bg-blue-500',
                'در حال انجام' => 'bg-yellow-500',
                'انجام شده' => 'bg-green-500',
            ];
        @endphp

        @foreach($statuses as $status)
            <div
                class="bg-gray-100 dark:bg-gray-900/50 rounded-lg p-4 min-h-[400px]"
                @dragover.prevent
                @dragenter.prevent
                @drop.prevent="onDrop($event, '{{ $status }}')"
            >
                <!-- Column Header -->
                <div class="flex items-center mb-4">
                    <span class="w-3 h-3 rounded-full {{ $statusColors[$status] }} ml-2"></span>
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200">{{ $status }}</h4>
                </div>

                <!-- Tasks -->
                <div class="space-y-4">
                    @foreach($tasksByStatus[$status] ?? [] as $task)
                        @php
                            // ما باید مدل Task را برای استفاده در @can بازسازی کنیم
                            $taskInstance = \App\Models\Task::find($task['id']);
                        @endphp
                        <div
                            class="bg-white dark:bg-gray-800 p-4 rounded-lg shadow
                                   @can('changeStatus', $taskInstance) cursor-move @else cursor-default opacity-75 @endcan"
                            @can('changeStatus', $taskInstance) draggable="true" @endcan
                            @dragstart="onDragStart($event, {{ $task['id'] }})"
                        >
                            <a href="#" wire:click.prevent="showTask({{ $task['id'] }})" class="font-semibold text-gray-900 dark:text-white hover:text-purple-600 dark:hover:text-purple-400 transition">
                                {{ $task['title'] }}
                            </a>
                            <div class="flex items-center justify-between mt-3 text-xs">
                                <span class="text-gray-500">{{ $task['due_date'] ? verta($task['due_date'])->format('Y/m/d') : '' }}</span>
                                <div class="flex -space-x-2">
                                    @foreach($task['assignees'] as $assignee)
                                        <img class="inline-block h-6 w-6 rounded-full ring-2 ring-white dark:ring-gray-800" src="{{ $assignee['profile_photo_url'] }}" alt="{{ $assignee['name'] }}" title="{{ $assignee['name'] }}">
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>
</div>
