<div>
    {{-- هدر صفحه --}}
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('مدیریت طرح و برنامه') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8 bg-white dark:bg-gray-800 dark:bg-gradient-to-bl dark:from-gray-700/50 dark:via-transparent border-b border-gray-200 dark:border-gray-700">
                    <div class="flex justify-between items-center">
                        <h1 class="text-2xl font-medium text-gray-900 dark:text-white">
                            لیست طرح‌ها
                        </h1>
                        <x-button wire:click="confirmProjectAddition">
                            ایجاد طرح جدید
                        </x-button>
                    </div>

                    <div class="mt-6">
                        @if (session()->has('message'))
                            <div class="mb-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                                {{ session('message') }}
                            </div>
                        @endif
                            @if (session()->has('info'))
                                <div class="mb-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                                    {{ session('info') }}
                                </div>
                            @endif
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    کد شناسایی
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    عنوان طرح
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    نوع
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    وضعیت
                                </th>
                                {{-- [NEW] Your Role Column --}}
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    نقش
                                </th>
                                {{-- [NEW] Risk Level Column --}}
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    سطح ریسک (AI)
                                </th>
                                <th scope="col" class="relative px-6 py-3">
                                    <span class="sr-only">عملیات</span>
                                </th>
                            </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($projects as $project)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">
                                        {{ $project->sku }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                        <a href="{{ route('projects.show', $project) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-200">
                                            {{ $project->title }}
                                        </a>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $project->type }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $project->status }}
                                    </td>
                                    {{-- [NEW] Your Role Badge --}}
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        @if($project->owner_id === auth()->id())
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">مالک طرح</span>
                                        @else
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">همکار طرح</span>
                                        @endif
                                    </td>
                                    {{-- [NEW] Risk Level Badge --}}
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        @if($project->risk_level)
                                            @php
                                                $riskColor = [
                                                    'low' => 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200',
                                                    'medium' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200',
                                                    'high' => 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200',
                                                ][$project->risk_level] ?? 'bg-gray-100 text-gray-800';
                                            @endphp
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $riskColor }}">
                                                {{ $project->risk_level }}
                                            </span>
                                        @else
                                            <span class="text-xs text-gray-400 italic">در حال تحلیل...</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-3 space-x-reverse">
                                        <button wire:click="confirmProjectEdit({{ $project->id }})" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-200">
                                            ویرایش
                                        </button>
                                        <button wire:click="confirmProjectDeletion({{ $project->id }})" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-200">
                                            حذف
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-4 whitespace-nowrap text-sm text-center text-gray-500 dark:text-gray-400">
                                        هیچ طرحی برای نمایش وجود ندارد.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal برای ایجاد طرح جدید -->
    <x-dialog-modal wire:model.live="confirmingProjectAddition">
        <x-slot name="title">
            {{ __('ایجاد طرح جدید') }}
        </x-slot>

        <x-slot name="content">
            <div class="grid grid-cols-6 gap-6">
                <!-- Research Team Selection -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="research_team_id" value="{{ __('تیم تحقیقاتی') }}" />
                    <select id="research_team_id" wire:model.live="research_team_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="">انتخاب کنید...</option>
                        @foreach($researchTeams as $team)
                            <option value="{{ $team->id }}">{{ $team->name }}</option>
                        @endforeach
                    </select>
                    <x-input-error for="research_team_id" class="mt-2" />
                </div>

                <!-- Generated SKU -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label value="{{ __('کد شناسایی طرح') }}" />
                    <div class="mt-1 flex items-center justify-center h-10 w-full bg-gray-100 dark:bg-gray-700 rounded-md">
                        <span class="text-gray-700 dark:text-gray-300 font-mono tracking-widest">{{ $generatedSku }}</span>
                    </div>
                </div>
                <!-- Title -->
                <div class="col-span-6">
                    <x-label for="title" value="{{ __('عنوان طرح') }}" />
                    <x-input id="title" type="text" class="mt-1 block w-full" wire:model.defer="title" />
                    <x-input-error for="title" class="mt-2" />
                </div>

                <!-- Type -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="type" value="{{ __('نوع طرح') }}" />
                    <select id="type" wire:model.defer="type" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="">انتخاب کنید...</option>
                        <option value="approved">مصوب</option>
                        <option value="thesis">پایان‌نامه</option>
                        <option value="personal">شخصی</option>
                    </select>
                    <x-input-error for="type" class="mt-2" />
                </div>

                <!-- Start Date -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="start_date" value="{{ __('تاریخ شروع') }}" />
                    <x-input id="start_date" type="date" class="mt-1 block w-full" wire:model.defer="start_date" />
                    <x-input-error for="start_date" class="mt-2" />
                </div>

                <!-- Category -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="category" value="{{ __('دسته') }}" />
                    <select id="category" wire:model.live="category" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="">انتخاب کنید...</option>
                        <option value="زیست سلولی">زیست سلولی</option>
                        <option value="زیست مولکولی">زیست مولکولی</option>
                        <option value="بیوشیمیایی">بیوشیمیایی</option>
                        <option value="تحقیق و توسعه">تحقیق و توسعه</option>
                        <option value="تحقیق و تولید">تحقیق و تولید</option>
                        <option value="other">سایر</option>
                    </select>
                    <x-input-error for="category" class="mt-2" />
                </div>

                @if($category === 'other')
                    <div class="col-span-6 sm:col-span-3">
                        <x-label for="custom_category" value="{{ __('نام دسته سفارشی') }}" />
                        <x-input id="custom_category" type="text" class="mt-1 block w-full" wire:model.defer="custom_category" />
                        <x-input-error for="custom_category" class="mt-2" />
                    </div>
                @endif

                <!-- Tags -->
                <div class="col-span-6">
                    <x-label for="tagSearch" value="{{ __('برچسب‌ها (Tags)') }}" />
                    <div class="flex flex-wrap items-center gap-2 mb-2">
                        @foreach($selectedTags as $tag)
                            <span class="inline-flex items-center px-2 py-1 bg-indigo-100 text-indigo-800 text-sm font-medium rounded-full">
                                {{ $tag['name'] }}
                                <button type="button" wire:click="removeTag({{ $tag['id'] }})" class="flex-shrink-0 ms-1.5 -me-1 p-1 inline-flex text-indigo-500 rounded-full hover:bg-indigo-200 hover:text-indigo-600">
                                    <span class="sr-only">Remove tag</span>
                                    <svg class="h-3 w-3" stroke="currentColor" fill="none" viewBox="0 0 8 8"><path stroke-linecap="round" stroke-width="1.5" d="M1 1l6 6m0-6L1 7" /></svg>
                                </button>
                            </span>
                        @endforeach
                    </div>
                    <div class="relative">
                        <x-input id="tagSearch" type="text" class="mt-1 block w-full"
                                 wire:model.live.debounce.300ms="tagSearch"
                                 placeholder="جستجو یا ایجاد برچسب..."
                                 autocomplete="off"
                        />
                        @if(count($tagSearchResults) > 0)
                            <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                                @foreach($tagSearchResults as $result)
                                    <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                        wire:click="addTag('{{ $result->name }}')">
                                        {{ $result->name }}
                                    </li>
                                @endforeach
                                @if(!empty($tagSearch) && !$tagSearchResults->contains('name', $tagSearch))
                                    <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                        wire:click="addTag('{{ $tagSearch }}')">
                                        ایجاد برچسب: "{{ $tagSearch }}"
                                    </li>
                                @endif
                            </ul>
                        @elseif(!empty($tagSearch))
                            <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                    wire:click="addTag('{{ $tagSearch }}')">
                                    ایجاد برچسب: "{{ $tagSearch }}"
                                </li>
                            </ul>
                        @endif
                    </div>
                </div>

                <!-- Description -->
                <div class="col-span-6">
                    <x-label for="description" value="{{ __('شرح مختصر') }}" />
                    <textarea id="description" class="border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm mt-1 block w-full" wire:model.defer="description"></textarea>
                    <x-input-error for="description" class="mt-2" />
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingProjectAddition')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>

            <x-button class="ms-3" wire:click="saveProject" wire:loading.attr="disabled">
                {{ __('ذخیره') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal برای ویرایش طرح -->
    <x-dialog-modal wire:model.live="confirmingProjectEdit">
        <x-slot name="title">
            ویرایش طرح
        </x-slot>
        <x-slot name="content">
            <div class="grid grid-cols-6 gap-6">
                <div class="col-span-6 sm:col-span-3">
                    <x-label value="{{ __('تیم تحقیقاتی') }}" />
                    <div class="mt-1 flex items-center h-10 w-full">
                        <span class="text-gray-700 dark:text-gray-300">{{ $editingProject?->researchTeam?->name }}</span>
                    </div>
                </div>
                <div class="col-span-6 sm:col-span-3">
                    <x-label value="{{ __('کد شناسایی طرح') }}" />
                    <div class="mt-1 flex items-center justify-center h-10 w-full bg-gray-200 dark:bg-gray-700 rounded-md">
                        <span class="text-gray-500 dark:text-gray-300 font-mono tracking-widest">{{ $editingState['sku'] ?? '' }}</span>
                    </div>
                </div>

                <div class="col-span-6">
                    <x-label for="editingState.title" value="{{ __('عنوان طرح') }}" />
                    <x-input id="editingState.title" type="text" class="mt-1 block w-full" wire:model.defer="editingState.title" />
                    <x-input-error for="editingState.title" class="mt-2" />
                </div>

                <!-- Type -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="editing-type" value="{{ __('نوع طرح') }}" />
                    <select id="editing-type" wire:model.defer="editingState.type" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="approved">مصوب</option>
                        <option value="thesis">پایان‌نامه</option>
                        <option value="personal">شخصی</option>
                    </select>
                    <x-input-error for="editingState.type" class="mt-2" />
                </div>

                <!-- Start Date -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="editing-start_date" value="{{ __('تاریخ شروع') }}" />
                    <x-input id="editing-start_date" type="date" class="mt-1 block w-full" wire:model.defer="editingState.start_date" />
                    <x-input-error for="editingState.start_date" class="mt-2" />
                </div>

                <!-- Category -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="editing-category" value="{{ __('دسته') }}" />
                    <select id="editing-category" wire:model.live="editingState.category" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="زیست سلولی">زیست سلولی</option>
                        <option value="زیست مولکولی">زیست مولکولی</option>
                        <option value="بیوشیمیایی">بیوشیمیایی</option>
                        <option value="تحقیق و توسعه">تحقیق و توسعه</option>
                        <option value="تحقیق و تولید">تحقیق و تولید</option>
                        <option value="other">سایر</option>
                    </select>
                    <x-input-error for="editingState.category" class="mt-2" />
                </div>

                @if(isset($editingState['category']) && $editingState['category'] === 'other')
                    <div class="col-span-6 sm:col-span-3">
                        <x-label for="editing-custom_category" value="{{ __('نام دسته سفارشی') }}" />
                        <x-input id="editing-custom_category" type="text" class="mt-1 block w-full" wire:model.defer="editingState.custom_category" />
                        <x-input-error for="editingState.custom_category" class="mt-2" />
                    </div>
                @endif

                <!-- Tags -->
                <div class="col-span-6">
                    <x-label for="tagSearch" value="{{ __('برچسب‌ها (Tags)') }}" />
                    <div class="flex flex-wrap items-center gap-2 mb-2">
                        @foreach($selectedTags as $tag)
                            <span class="inline-flex items-center px-2 py-1 bg-indigo-100 text-indigo-800 text-sm font-medium rounded-full">
                                {{ $tag['name'] }}
                                <button type="button" wire:click="removeTag({{ $tag['id'] }})" class="flex-shrink-0 ms-1.5 -me-1 p-1 inline-flex text-indigo-500 rounded-full hover:bg-indigo-200 hover:text-indigo-600">
                                    <span class="sr-only">Remove tag</span>
                                    <svg class="h-3 w-3" stroke="currentColor" fill="none" viewBox="0 0 8 8"><path stroke-linecap="round" stroke-width="1.5" d="M1 1l6 6m0-6L1 7" /></svg>
                                </button>
                            </span>
                        @endforeach
                    </div>
                    <div class="relative">
                        <x-input id="tagSearch" type="text" class="mt-1 block w-full"
                                 wire:model.live.debounce.300ms="tagSearch"
                                 placeholder="جستجو یا ایجاد برچسب..."
                                 autocomplete="off"
                        />
                        @if(count($tagSearchResults) > 0)
                            <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                                @foreach($tagSearchResults as $result)
                                    <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                        wire:click="addTag('{{ $result->name }}')">
                                        {{ $result->name }}
                                    </li>
                                @endforeach
                                @if(!empty($tagSearch) && !$tagSearchResults->contains('name', $tagSearch))
                                    <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                        wire:click="addTag('{{ $tagSearch }}')">
                                        ایجاد برچسب: "{{ $tagSearch }}"
                                    </li>
                                @endif
                            </ul>
                        @elseif(!empty($tagSearch))
                            <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                    wire:click="addTag('{{ $tagSearch }}')">
                                    ایجاد برچسب: "{{ $tagSearch }}"
                                </li>
                            </ul>
                        @endif
                    </div>
                </div>

                <!-- Description -->
                <div class="col-span-6">
                    <x-label for="editing-description" value="{{ __('شرح مختصر') }}" />
                    <textarea id="editing-description" class="border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm mt-1 block w-full" wire:model.defer="editingState.description"></textarea>
                    <x-input-error for="editingState.description" class="mt-2" />
                </div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingProjectEdit', false)" wire:loading.attr="disabled">
                انصراف
            </x-secondary-button>
            <x-button class="ms-3" wire:click="updateProject" wire:loading.attr="disabled">
                ذخیره تغییرات
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal برای تایید حذف طرح -->
    <x-confirmation-modal wire:model.live="confirmingProjectDeletion">
        <x-slot name="title">
            {{ __('حذف طرح') }}
        </x-slot>
        <x-slot name="content">
            {{ __('آیا از حذف این طرح مطمئن هستید؟') }}
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingProjectDeletion')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteProject" wire:loading.attr="disabled">
                {{ __('حذف طرح') }}
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>
</div>
