<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Chart and Stats -->
    <div class="lg:col-span-2 bg-white dark:bg-gray-100 rounded-xl shadow-lg border-t-4 border-indigo-600 p-6 sm:p-8">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-black mb-4">نمای کلی پیشرفت پروژه</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 items-center">
            <!-- Pie Chart -->
            <div class="h-64">
                {{-- محفظه نمودار --}}
                <canvas id="progressPieChart"></canvas>
            </div>
            <!-- Stats -->
            <div class="space-y-4">
                <div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">درصد پیشرفت</p>
                    <div class="w-full bg-gray-200 rounded-full h-2.5 dark:bg-gray-700 mt-1">
                        <div class="bg-indigo-600 h-2.5 rounded-full" style="width: {{ $completionPercentage }}%"></div>
                    </div>
                    <p class="text-xl font-bold text-gray-900 dark:text-black mt-1">{{ $completionPercentage }}%</p>
                </div>
                <div class="grid grid-cols-3 gap-4 text-center">
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">کل وظایف</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-blue-950">{{ $totalTasks }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-green-500">انجام شده</p>
                        <p class="text-2xl font-bold text-green-500">{{ $completedTasks }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-yellow-500">در جریان</p>
                        <p class="text-2xl font-bold text-yellow-500">{{ $inProgressTasks }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Overdue Tasks -->
    <div class="lg:col-span-1 bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-red-600 p-6 sm:p-8">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">وظایف نیازمند توجه (عقب افتاده)</h3>
        <div class="space-y-3 max-h-80 overflow-y-auto">
            @forelse($overdueTasks ?? [] as $task)
                <div class="p-3 bg-red-50 dark:bg-red-900/20 rounded-lg">
                    <p class="font-semibold text-red-800 dark:text-red-300">{{ $task->title }}</p>
                    <p class="text-xs text-red-600 dark:text-red-400">تاریخ پایان: {{ verta($task->due_date)->format('Y/m/d') }}</p>
                </div>
            @empty
                <div class="text-center py-8">
                    <x-lucide-check-check class="mx-auto h-12 w-12 text-green-500" />
                    <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">هیچ وظیفه عقب افتاده‌ای وجود ندارد.</p>
                </div>
            @endforelse
        </div>
    </div>

    {{-- Chart.js از طریق CDN یا app.js شما بارگذاری می‌شود --}}
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</div>

{{-- [REWRITTEN] اسکریپت مستقیم و مطمئن برای مقداردهی اولیه نمودار --}}
@push('scripts')
    <script>
        document.addEventListener('livewire:navigated', () => {
            const chartData = @json($chartData);
            const ctx = document.getElementById('progressPieChart');

            if (window.progressChartInstance) {
                window.progressChartInstance.destroy();
            }

            if (ctx && chartData.labels && chartData.labels.length > 0) {
                window.progressChartInstance = new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: chartData.labels,
                        datasets: [{
                            data: chartData.data,
                            backgroundColor: [
                                '#22c55e', // green-500
                                '#f59e0b', // amber-500
                                '#3b82f6', // blue-500
                            ],
                            borderColor: document.body.classList.contains('dark') ? '#1f2937' : '#fff',
                            borderWidth: 2,
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: {
                                    color: document.body.classList.contains('dark') ? '#d1d5db' : '#4b5563',
                                    font: { family: 'Vazirmatn' } // نام فونت فارسی شما
                                }
                            }
                        }
                    }
                });
            }
        });
    </script>
@endpush
