<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-purple-600">
    <div class="p-6 sm:p-8">
        <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">مدیریت وظایف طرح</h3>
            @can('create', [\App\Models\Task::class, $project])
                <x-button class="bg-purple-600 hover:bg-purple-700" wire:click="confirmTaskAction">
                    <x-lucide-plus class="w-4 h-4 ml-2"/>
                    ایجاد وظیفه جدید
                </x-button>
            @endcan
        </div>

        @if (session()->has('task_message'))
            <div class="mt-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300" role="alert">
                {{ session('task_message') }}
            </div>
        @endif

        <div class="mt-6 flow-root">
            <div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                        <tr>
                            <th scope="col" class="py-3.5 pl-4 pr-3 text-right text-sm font-semibold text-gray-900 dark:text-white sm:pl-0">عنوان وظیفه</th>
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">مسئولین</th>
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">اولویت</th>
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">تاریخ پایان</th>
                            <th scope="col" class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">وضعیت</th>
                            <th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-0"><span class="sr-only">عملیات</span></th>
                        </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
                        @forelse ($tasks as $task)
                            <tr>
                                {{-- [UPDATED] کلیک روی عنوان وظیفه، مودال را باز می‌کند --}}
                                <td class="py-4 pl-4 pr-3 text-sm font-medium text-gray-900 dark:text-white sm:pl-0">
                                    <a href="#" wire:click.prevent="showTask({{ $task->id }})" class="hover:text-blue-600">
                                        {{ $task->title }}
                                    </a>
                                </td>
                                <td class="px-3 py-4 text-sm text-gray-500 dark:text-gray-400">
                                    <div class="flex -space-x-2">
                                        @foreach($task->assignees as $assignee)
                                            <img class="inline-block h-8 w-8 rounded-full ring-2 ring-white dark:ring-gray-800" src="{{ $assignee->profile_photo_url }}" alt="{{ $assignee->name }}" title="{{ $assignee->name }}">
                                        @endforeach
                                    </div>
                                </td>
                                <td class="px-3 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $task->priority }}</td>
                                <td class="px-3 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $task->due_date ? verta($task->due_date)->format('Y/m/d') : '-' }}</td>
                                <td class="px-3 py-4 text-sm text-gray-500 dark:text-gray-400">
                                    @can('changeStatus', $task)
                                        <div class="relative" x-data="{ open: false }">
                                            <button @click="open = !open" class="inline-flex items-center gap-x-1 text-sm font-semibold leading-6 text-gray-900 dark:text-white" aria-expanded="false">
                                                <span>{{ $task->status }}</span>
                                                <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z" clip-rule="evenodd" /></svg>
                                            </button>
                                            <div x-show="open" @click.away="open = false" class="absolute left-0 z-10 mt-2 w-48 origin-top-right rounded-md bg-white dark:bg-gray-900 shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none" style="display: none;">
                                                <div class="py-1">
                                                    <a href="#" wire:click.prevent="changeStatus({{ $task->id }}, 'برای انجام')" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-800">برای انجام</a>
                                                    <a href="#" wire:click.prevent="changeStatus({{ $task->id }}, 'در حال انجام')" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-800">در حال انجام</a>
                                                    <a href="#" wire:click.prevent="changeStatus({{ $task->id }}, 'انجام شده')" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-800">انجام شده</a>
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <span>{{ $task->status }}</span>
                                    @endcan
                                </td>
                                <td class="relative whitespace-nowrap py-4 pl-3 pr-4 text-left text-sm font-medium sm:pr-0 space-x-4 space-x-reverse">
                                    @can('update', $task)
                                        <button wire:click="confirmTaskAction({{ $task->id }})" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 transition">ویرایش</button>
                                    @endcan
                                    @can('delete', $task)
                                        <button wire:click="confirmTaskDeletion({{ $task->id }})" class="text-red-600 hover:text-red-800 dark:text-red-500 dark:hover:text-red-400 transition">حذف</button>
                                    @endcan
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-8 text-center text-sm text-gray-500 dark:text-gray-400">
                                    <x-lucide-clipboard-list class="mx-auto h-12 w-12 text-gray-400" />
                                    <h3 class="mt-2 font-medium text-gray-900 dark:text-white">هنوز وظیفه‌ای ایجاد نشده</h3>
                                    <p class="mt-1">برای شروع، یک وظیفه جدید برای این طرح ایجاد کنید.</p>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                {{-- [NEW] افزودن لینک‌های صفحه‌بندی --}}
                <div class="mt-4">
                    {{ $tasks->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Task Modal -->
    <!-- [UPDATED] Create/Edit Task Modal -->
    <x-dialog-modal wire:model.live="confirmingTaskAction">
        <x-slot name="title">
            {{ $editingTask ? 'ویرایش وظیفه' : 'ایجاد وظیفه جدید' }}
        </x-slot>

        <x-slot name="content">
            <div class="space-y-6">
                <div>
                    <x-label for="title" value="عنوان وظیفه" />
                    <x-input id="title" type="text" class="mt-1 block w-full" wire:model.defer="state.title" />
                    <x-input-error for="state.title" class="mt-2" />
                </div>
                <div>
                    <x-label for="description" value="شرح وظیفه" />
                    <textarea id="description" class="border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm mt-1 block w-full" wire:model.defer="state.description"></textarea>
                    <x-input-error for="state.description" class="mt-2" />
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <x-label for="priority" value="اولویت" />
                        <select id="priority" wire:model.defer="state.priority" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                            <option value="پایین">پایین</option>
                            <option value="متوسط">متوسط</option>
                            <option value="بالا">بالا</option>
                        </select>
                    </div>
                    <div>
                        {{-- فیلدهای تاریخ در یک ردیف --}}
                    </div>
                </div>
                {{-- در فایل project-task-manager.blade.php --}}

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <x-label for="start_date" value="تاریخ شروع" />
                        <x-jalali-date-picker id="start_date" wire:model.defer="state.start_date" />
                        <x-input-error for="state.start_date" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="due_date" value="تاریخ پایان" />
                        <x-jalali-date-picker id="due_date" wire:model.defer="state.due_date" />
                        <x-input-error for="state.due_date" class="mt-2" />
                    </div>
                </div>
                <div>
                    <x-label value="تخصیص به" />
                    <div class="mt-2 grid grid-cols-2 md:grid-cols-3 gap-4 border border-gray-200 dark:border-gray-700 p-4 rounded-lg">
                        @foreach($project->collaborators->push($project->owner)->unique('id') as $user)
                            <label for="user-{{ $user->id }}" class="flex items-center">
                                <input id="user-{{ $user->id }}" type="checkbox" wire:model.defer="assigneeIds" value="{{ $user->id }}" class="rounded">
                                <span class="ms-2 text-sm">{{ $user->name }}</span>
                            </label>
                        @endforeach
                    </div>
                    <x-input-error for="assigneeIds" class="mt-2" />
                </div>
                {{-- [NEW] بخش انتخاب وابستگی‌ها --}}
                <div>
                    <x-label value="پیش‌نیازها (وظایفی که باید قبل از این وظیفه انجام شوند)" />
                    <div class="mt-2 grid grid-cols-2 md:grid-cols-3 gap-4 border border-gray-200 dark:border-gray-700 p-4 rounded-lg max-h-48 overflow-y-auto">
                        @forelse($allTasksForDependencies as $task)
                            <label for="dependency-{{ $task->id }}" class="flex items-center">
                                <input id="dependency-{{ $task->id }}" type="checkbox" wire:model.defer="dependencyIds" value="{{ $task->id }}" class="rounded">
                                <span class="ms-2 text-sm">{{ $task->title }}</span>
                            </label>
                        @empty
                            <p class="text-xs text-gray-500 italic col-span-full text-center">هیچ وظیفه دیگری برای انتخاب به عنوان پیش‌نیاز وجود ندارد.</p>
                        @endforelse
                    </div>
                    <x-input-error for="dependencyIds" class="mt-2" />
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingTaskAction', false)" wire:loading.attr="disabled">
                انصراف
            </x-secondary-button>
            <x-button class="ms-3" wire:click="saveTask" wire:loading.attr="disabled">
                ذخیره
            </x-button>
        </x-slot>
    </x-dialog-modal>
    <!-- Delete Task Confirmation Modal -->
    <x-confirmation-modal wire:model.live="confirmingTaskDeletion">
        <x-slot name="title">
            حذف وظیفه
        </x-slot>

        <x-slot name="content">
            آیا از حذف این وظیفه مطمئن هستید؟ این عمل قابل بازگشت نیست.
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingTaskDeletion')" wire:loading.attr="disabled">
                انصراف
            </x-secondary-button>

            <x-danger-button class="ms-3" wire:click="deleteTask" wire:loading.attr="disabled">
                حذف وظیفه
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>

    {{-- [NEW] فراخوانی کامپوننت مودال جزئیات --}}
    @livewire('task-detail-modal', key('task-detail-modal'))
</div>
