<div class="mt-8">
    @if($entries->isEmpty())
        <div class="text-center py-12 border-2 border-dashed border-gray-300 dark:border-gray-700 rounded-lg">
            <x-lucide-history class="mx-auto h-12 w-12 text-gray-400" />
            <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">هنوز یادداشتی ثبت نشده</h3>
            <p class="mt-1 text-sm text-gray-500">هیچ یادداشتی برای نمایش در تایم‌لاین وجود ندارد.</p>
        </div>
    @else
        <ol class="relative border-s border-gray-200 dark:border-gray-700">
            @foreach($entries as $entry)
                <li class="mb-10 ms-6">
                    <span class="absolute flex items-center justify-center w-6 h-6 bg-blue-100 rounded-full -start-3 ring-8 ring-white dark:ring-gray-900 dark:bg-blue-900">
                        <x-lucide-calendar-days class="w-3 h-3 text-blue-800 dark:text-blue-300"/>
                    </span>
                    <div class="p-4 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-700 dark:border-gray-600">
                        <div class="items-center justify-between mb-3 sm:flex">
                            <time class="mb-1 text-xs font-normal text-gray-400 sm:order-last sm:mb-0">{{ verta($entry->entry_date)->formatDifference() }}</time>
                            <div class="text-sm font-normal text-gray-500 lex dark:text-gray-300">
                                <a href="{{ route('entries.edit', $entry) }}" class="font-semibold text-gray-900 dark:text-white hover:underline">{{ $entry->title }}</a>
                            </div>
                        </div>
                        <div class="p-3 text-xs italic font-normal text-gray-500 border border-gray-200 rounded-lg bg-gray-50 dark:bg-gray-600 dark:border-gray-500 dark:text-gray-300">
                            ثبت شده توسط: {{ $entry->user->name }} در تاریخ {{ verta($entry->created_at)->format('Y/m/d') }}
                        </div>
                    </div>
                </li>
            @endforeach
        </ol>
    @endif
</div>
