<div class="container mx-auto mt-10 max-w-2xl">
    <div class="text-center mb-8">
        <h1 class="text-3xl font-bold text-gray-800">ثبت لاگ دمای اتاق</h1>
        <p class="text-lg text-gray-600">{{ $room->parent->name }} / {{ $room->name }}</p>
    </div>

    @if (session()->has('log_success'))
        <div class="p-4 mb-4 text-sm text-green-700 bg-green-100 rounded-lg" role="alert">
            {{ session('log_success') }}
        </div>
    @endif

    <div class="bg-white shadow-md rounded-lg p-8">
        @if (!$pinVerified)
            {{-- PIN Verification Step --}}
            <h2 class="text-xl font-semibold mb-4 text-center">ورود بازرس</h2>
            <p class="text-center text-gray-500 mb-6">برای ثبت دما، لطفاً پین کد ۴ رقمی خود را وارد کنید.</p>
            <div class="w-full max-w-xs mx-auto">
                <input type="password" wire:model.defer="pin" wire:keydown.enter="verifyPin"
                       class="form-input block w-full text-center text-2xl tracking-widest"
                       maxlength="4" pattern="[0-9]*" inputmode="numeric">
                <x-input-error for="pin" class="mt-2 text-center" />
                <x-button wire:click="verifyPin" class="w-full mt-4">تایید هویت</x-button>
            </div>
        @else
            {{-- Temperature Logging Step --}}
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h2 class="text-xl font-semibold">تجهیزات نیازمند لاگ دما</h2>
                    <p class="text-sm text-gray-500">خوش آمدید، <span class="font-bold">{{ $auditor->name }}</span></p>
                </div>
                <button wire:click="logout" class="text-sm text-red-600 hover:underline">خروج</button>
            </div>

            <div class="space-y-4">
                @forelse($equipmentList as $equipment)
                    <div class="p-4 border rounded-lg {{ $selectedEquipment && $selectedEquipment->id === $equipment->id ? 'bg-blue-50 border-blue-300' : '' }}">
                        <div class="flex justify-between items-center cursor-pointer" wire:click="selectEquipment({{ $equipment->id }})">
                            <h3 class="font-semibold">{{ $equipment->name }}</h3>
                            <span class="text-sm text-gray-500">محدوده مجاز: {{ $equipment->min_temp }}°C تا {{ $equipment->max_temp }}°C</span>
                        </div>

                        @if($selectedEquipment && $selectedEquipment->id === $equipment->id)
                            <div class="mt-4 pt-4 border-t space-y-4">
                                <div>
                                    <x-label for="temperature" value="دمای فعلی (°C)" />
                                    <x-input id="temperature" type="number" step="0.1" class="mt-1 block w-full" wire:model.defer="temperature" />
                                    <x-input-error for="temperature" class="mt-2" />
                                </div>
                                <div>
                                    <x-label for="notes" value="توضیحات (اختیاری)" />
                                    <textarea id="notes" wire:model.defer="notes" class="form-textarea mt-1 block w-full" rows="2"></textarea>
                                </div>
                                <x-button wire:click="saveTemperatureLog">ثبت دما برای {{ $equipment->name }}</x-button>
                            </div>
                        @endif
                    </div>
                @empty
                    <p class="text-center text-gray-500">هیچ تجهیزی برای ثبت دما در این اتاق تعریف نشده است.</p>
                @endforelse
            </div>
        @endif
    </div>
</div>
