<div>
    {{-- هدر صفحه --}}
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('مدیریت درخواست‌های خرید') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">

                <div class="p-6 lg:p-8 bg-white dark:bg-gray-800 dark:bg-gradient-to-bl dark:from-gray-700/50 dark:via-transparent border-b border-gray-200 dark:border-gray-700">
                    <div class="flex justify-between items-center">
                        <h1 class="text-2xl font-medium text-gray-900 dark:text-white">
                            لیست درخواست‌های شما
                        </h1>
                        <x-button wire:click="confirmPurchaseRequestAddition">
                            ایجاد درخواست جدید
                        </x-button>
                    </div>

                    @if (session()->has('message'))
                        <div class="mt-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                            {{ session('message') }}
                        </div>
                    @endif

                    <div class="mt-6">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    کد درخواست
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    درخواست کننده
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    عنوان طرح
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    تعداد اقلام
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    وضعیت
                                </th>
                                <th scope="col" class="relative px-6 py-3">
                                    <span class="sr-only">عملیات</span>
                                </th>
                            </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($requests as $request)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">
                                        {{ $request->request_code }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                        {{ $request->requester->first_name }} {{ $request->requester->last_name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $request->project?->title ?? 'عمومی' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $request->items_count }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        @php
                                            $statusClasses = [
                                                'منتظر تائید' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300',
                                                'pending_approval' => 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300',
                                                'rejected_by_owner' => 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300',
                                                'صدور پیش فاکتور' => 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300',
                                                'recived' => 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300',
                                                'final_approval' => 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300',
                                                'price_received' => 'bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-300', // <-- وضعیت جدید

                                            ];
                                            $statusClass = $statusClasses[$request->status] ?? 'bg-gray-100 text-gray-800 dark:bg-gray-900 dark:text-gray-300';
                                        @endphp
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusClass }}">
                                                {{ str_replace('_', ' ', $request->status) }}
                                            </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-3 space-x-reverse">
                                        @can('viewResponses', $request)
                                            @if($request->items()->where('status', 'pending_offer')->exists() && $request->responses->isNotEmpty())
                                                <x-button wire:click="viewResponses({{ $request->id }})">مشاهده پاسخ‌ها</x-button>
                                            @endif
                                            {{-- دکمه جدید برای مشاهده وضعیت ارسال --}}
                                                @if ($request->shipments->isNotEmpty())
                                                    <x-button wire:click="viewShipments({{ $request->id }})" class="bg-purple-600 hover:bg-purple-700">
                                                        وضعیت ارسال
                                                    </x-button>
                                                @endif
                                            @endcan
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-3 space-x-reverse">
                                        @can('update', $request)
                                            <button wire:click="confirmPurchaseRequestEdit({{ $request->id }})" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-200">ویرایش</button>
                                        @else
                                            <button wire:click="viewRequest({{ $request->id }})" class="text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-200">مشاهده</button>
                                        @endcan
                                        @can('delete', $request)
                                            <button wire:click="confirmPurchaseRequestDeletion({{ $request->id }})" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-200">حذف</button>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-4 whitespace-nowrap text-sm text-center text-gray-500 dark:text-gray-400">
                                        هیچ درخواستی برای نمایش وجود ندارد.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Modal برای ایجاد درخواست خرید -->
    <x-dialog-modal wire:model.live="confirmingPurchaseRequestAddition">
        <x-slot name="title">
            {{ __('ایجاد درخواست خرید جدید') }}
        </x-slot>

        <x-slot name="content">
            <div class="space-y-4">
                <!-- Generated Request Code Display -->
                <div>
                    <x-label value="{{ __('کد شناسایی درخواست') }}" />
                    <div class="mt-1 flex items-center justify-center h-10 w-full bg-gray-100 dark:bg-gray-700 rounded-md">
                        <span class="text-gray-700 dark:text-gray-300 font-mono tracking-widest">{{ $generatedRequestCode }}</span>
                    </div>
                </div>

                {{-- Main Request Details --}}
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <x-label for="priority" value="{{ __('اولویت') }}" />
                        <select id="priority" wire:model.defer="priority" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                            <option value="normal">عادی</option>
                            <option value="high">بالا</option>
                            <option value="low">پایین</option>
                        </select>
                    </div>
                    <div>
                        <x-label for="project_id" value="{{ __('پروژه مرتبط (اختیاری)') }}" />
                        <select id="project_id" wire:model.defer="project_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                            <option value="">هیچکدام</option>
                            @foreach($projects as $project)
                                <option value="{{ $project->id }}">{{ $project->title }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                {{-- بخش جدید: جستجوی تامین‌کننده --}}
                <div class="relative">
                    <x-label for="supplierSearch" value="{{ __('تامین‌کننده اختصاصی (اختیاری)') }}" />
                    <x-input id="supplierSearch" type="text" class="mt-1 block w-full"
                             wire:model.live.debounce.300ms="supplierSearch"
                             placeholder="جستجوی تامین‌کننده..."
                             autocomplete="off"
                    />
                    @if($assigned_supplier_id)
                        <button type="button" wire:click="clearSelectedSupplier" class="absolute top-8 left-2 text-red-500 hover:text-red-700">&times;</button>
                    @endif

                    @if(count($supplierSearchResults) > 0)
                        <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                            @foreach($supplierSearchResults as $supplier)
                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                    wire:click="selectSupplier({{ $supplier->id }})">
                                    {{ $supplier->company_name }}
                                </li>
                            @endforeach
                        </ul>
                    @endif
                    <x-input-error for="assigned_supplier_id" class="mt-2" />
                </div>
                <div>
                    <x-label for="notes" value="{{ __('یادداشت‌های اضافی') }}" />
                    <textarea id="notes" wire:model.defer="notes" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm"></textarea>
                </div>

                <hr class="my-4 dark:border-gray-600">

                {{-- Requested Items --}}
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">آیتم‌های درخواستی</h3>
                <div class="space-y-3">
                    @foreach ($items as $index => $item)
                        <div class="p-3 bg-gray-50 dark:bg-gray-900/50 rounded-lg space-y-3">
                            <div class="flex justify-between items-center">
                                <span class="font-semibold text-gray-700 dark:text-gray-300">آیتم #{{ $index + 1 }}</span>
                                @if($index > 0)
                                    <button type="button" wire:click="removeItemRow({{ $index }})" class="text-red-500 hover:text-red-700">&times; حذف</button>
                                @endif
                            </div>
                            <div>
                                <x-label for="items.{{ $index }}.item_name" value="{{ __('نام آیتم') }}" />
                                <x-input id="items.{{ $index }}.item_name" type="text" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.item_name" />
                                <x-input-error for="items.{{ $index }}.item_name" class="mt-2" />
                            </div>

                            {{-- فیلد جدید توضیحات --}}
                            <div>
                                <x-label for="items.{{ $index }}.description" value="{{ __('جزئیات فنی (برند، نوع، شماره کاتالوگ و...)') }}" />
                                <textarea id="items.{{ $index }}.description" wire:model.defer="items.{{ $index }}.description" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm"></textarea>
                                <x-input-error for="items.{{ $index }}.description" class="mt-2" />
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-label for="items.{{ $index }}.quantity" value="{{ __('مقدار') }}" />
                                    <x-input id="items.{{ $index }}.quantity" type="number" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.quantity" />
                                    <x-input-error for="items.{{ $index }}.quantity" class="mt-2" />
                                </div>
                                <div>
                                    <x-label for="items.{{ $index }}.unit" value="{{ __('واحد') }}" />
                                    <x-input id="items.{{ $index }}.unit" type="text" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.unit" />
                                    <x-input-error for="items.{{ $index }}.unit" class="mt-2" />
                                </div>
                            </div>
{{--                            <div>--}}
{{--                                <x-label for="items.{{ $index }}.supplier_id" value="{{ __('تامین‌کننده (اختیاری)') }}" />--}}
{{--                                <select id="items.{{ $index }}.supplier_id" wire:model.defer="items.{{ $index }}.supplier_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">--}}
{{--                                    <option value="">انتخاب کنید...</option>--}}
{{--                                    @foreach($suppliers as $supplier)--}}
{{--                                        <option value="{{ $supplier->id }}">{{ $supplier->company_name }}</option>--}}
{{--                                    @endforeach--}}
{{--                                </select>--}}
{{--                            </div>--}}
                        </div>
                    @endforeach
                </div>
                <x-button type="button" wire:click="addItemRow" class="mt-4">افزودن آیتم دیگر</x-button>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingPurchaseRequestAddition')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>

            <x-button class="ms-3" wire:click="saveRequest" wire:loading.attr="disabled">
                {{ __('ثبت درخواست') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal برای ویرایش درخواست خرید -->
    <x-dialog-modal wire:model.live="confirmingPurchaseRequestEdit">
        <x-slot name="title">
            ویرایش درخواست خرید ({{ $editingRequest?->request_code }})
        </x-slot>

        <x-slot name="content">
            <div class="space-y-4">
                {{-- Main Request Details --}}
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <x-label for="editing_priority" value="{{ __('اولویت') }}" />
                        <select id="editing_priority" wire:model.defer="priority" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                            <option value="normal">عادی</option>
                            <option value="high">بالا</option>
                            <option value="low">پایین</option>
                        </select>
                    </div>
                    <div>
                        <x-label for="editing_project_id" value="{{ __('پروژه مرتبط (اختیاری)') }}" />
                        <select id="editing_project_id" wire:model.defer="project_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                            <option value="">هیچکدام</option>
                            @foreach($projects as $project)
                                <option value="{{ $project->id }}">{{ $project->title }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                {{-- بخش جستجوی تامین‌کننده در مودال ویرایش --}}
                <div class="relative">
                    <x-label for="supplierSearch_edit" value="{{ __('تامین‌کننده اختصاصی (اختیاری)') }}" />
                    <x-input id="supplierSearch_edit" type="text" class="mt-1 block w-full"
                             wire:model.live.debounce.300ms="supplierSearch"
                             placeholder="جستجوی تامین‌کننده..."
                             autocomplete="off"
                    />
                    @if($assigned_supplier_id)
                        <button type="button" wire:click="clearSelectedSupplier" class="absolute top-8 left-2 text-red-500 hover:text-red-700">&times;</button>
                    @endif

                    @if(count($supplierSearchResults) > 0)
                        <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                            @foreach($supplierSearchResults as $supplier)
                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                    wire:click="selectSupplier({{ $supplier->id }})">
                                    {{ $supplier->company_name }}
                                </li>
                            @endforeach
                        </ul>
                    @endif
                    <x-input-error for="assigned_supplier_id" class="mt-2" />
                </div>
                <div>
                    <x-label for="editing_notes" value="{{ __('یادداشت‌های اضافی') }}" />
                    <textarea id="editing_notes" wire:model.defer="notes" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm"></textarea>
                </div>

                <hr class="my-4 dark:border-gray-600">

                {{-- Requested Items --}}
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">آیتم‌های درخواستی</h3>
                <div class="space-y-3">
                    @foreach ($items as $index => $item)
                        <div class="p-3 bg-gray-50 dark:bg-gray-900/50 rounded-lg space-y-3">
                            <div class="flex justify-between items-center">
                                <span class="font-semibold text-gray-700 dark:text-gray-300">آیتم #{{ $index + 1 }}</span>
                                @if($index > 0)
                                    <button type="button" wire:click="removeItemRow({{ $index }})" class="text-red-500 hover:text-red-700">&times; حذف</button>
                                @endif
                            </div>
                            <div>
                                <x-label for="items.{{ $index }}.item_name" value="{{ __('نام آیتم') }}" />
                                <x-input id="items.{{ $index }}.item_name" type="text" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.item_name" />
                                <x-input-error for="items.{{ $index }}.item_name" class="mt-2" />
                            </div>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-label for="items.{{ $index }}.quantity" value="{{ __('مقدار') }}" />
                                    <x-input id="items.{{ $index }}.quantity" type="number" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.quantity" />
                                    <x-input-error for="items.{{ $index }}.quantity" class="mt-2" />
                                </div>
                                <div>
                                    <x-label for="items.{{ $index }}.unit" value="{{ __('واحد') }}" />
                                    <x-input id="items.{{ $index }}.unit" type="text" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.unit" />
                                    <x-input-error for="items.{{ $index }}.unit" class="mt-2" />
                                </div>
                            </div>

                        </div>
                    @endforeach
                </div>
                <x-button type="button" wire:click="addItemRow" class="mt-4">افزودن آیتم دیگر</x-button>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingPurchaseRequestEdit')" wire:loading.attr="disabled">
                انصراف
            </x-secondary-button>
            <x-button class="ms-3" wire:click="updateRequest" wire:loading.attr="disabled">
                ذخیره تغییرات
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal برای تایید حذف درخواست -->
    <x-confirmation-modal wire:model.live="confirmingPurchaseRequestDeletion">
        <x-slot name="title">
            حذف درخواست خرید
        </x-slot>
        <x-slot name="content">
            آیا از حذف این درخواست خرید مطمئن هستید؟ این عملیات غیرقابل بازگشت است.
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingPurchaseRequestDeletion')" wire:loading.attr="disabled">
                انصراف
            </x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteRequest" wire:loading.attr="disabled">
                حذف درخواست
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>

    <!-- Read-only View Modal -->
    <x-dialog-modal wire:model.live="confirmingRequestView" maxWidth="2xl">
        <x-slot name="title">
            مشاهده جزئیات درخواست ({{ $viewingRequest?->request_code }})
        </x-slot>

        <x-slot name="content">
            @if ($viewingRequest)
                <div class="space-y-4">
                    {{-- Read-only request details --}}
                    <div class="p-4 border rounded-lg dark:border-gray-600 space-y-4">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div><span class="font-semibold">اولویت:</span> {{ $viewingRequest->priority }}</div>
                            <div><span class="font-semibold">پروژه:</span> {{ $viewingRequest->project?->title ?? 'عمومی' }}</div>
                        </div>
                        @if($viewingRequest->notes)
                            <div class="mt-4"><span class="font-semibold">یادداشت‌ها:</span> {{ $viewingRequest->notes }}</div>
                        @endif
                    </div>

                    <hr class="my-4 dark:border-gray-600">

                    <h3 class="text-lg font-medium text-gray-900 dark:text-black">آیتم‌های درخواستی</h3>
                    <div class="space-y-2">
                        @foreach($viewingRequest->items as $item)
                            <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                <p class="font-bold text-gray-800 dark:text-blue-950">{{ $item->item_name }}</p>
                                @if($item->description)
                                    <p class="text-sm text-gray-600 dark:text-blue-950 mt-1">{{ $item->description }}</p>
                                @endif
                                <div class="flex justify-between items-center mt-2 text-sm">
                                    <span class="text-gray-500 dark:text-white">مقدار: <span class="font-semibold">{{ $item->quantity }} {{ $item->unit }}</span></span>
                                    <span class="text-gray-500 dark:text-white">تامین‌کننده: <span class="font-semibold">{{ $item->supplier?->company_name ?? 'مشخص نشده' }}</span></span>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingRequestView', false)" wire:loading.attr="disabled">
                بستن
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [REWRITTEN] Modal برای مشاهده پاسخ‌ها و تایید نهایی -->
    <x-dialog-modal wire:model.live="confirmingResponseView" maxWidth="2xl">
        <x-slot name="title">
            مقایسه و انتخاب پاسخ‌ها برای درخواست ({{ $viewingRequest?->request_code }})
        </x-slot>

        <x-slot name="content">
            @if ($viewingRequest)
                <div class="space-y-4">
                    @forelse ($responsesForRequest as $response)
                        <div class="p-4 border-2 rounded-lg dark:border-gray-600">
                            <div class="flex justify-between items-center mb-4">
                                <div>
                                    <p class="font-bold text-lg text-gray-800 dark:text-gray-200">{{ $response->supplier->company_name }}</p>
                                    <p class="text-sm text-gray-500 dark:text-gray-400">وضعیت پیشنهاد: {{ $response->status }}</p>
                                </div>
                                @can('confirmResponses', $viewingRequest)
                                    <x-button wire:click="setFinalFullResponse({{ $response->id }})" class="bg-green-600 hover:bg-green-700">
                                        تایید کل این پیشنهاد
                                    </x-button>
                                @endcan
                            </div>

                            <div class="space-y-2">
                                @foreach($response->items as $item)
                                    <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg flex justify-between items-center">
                                        <div>
                                            <p class="font-semibold text-gray-800 dark:text-gray-200">{{ $item->originalItem->item_name }}</p>
                                            <div class="flex items-center mt-2 text-sm space-x-4 space-x-reverse">
                                                <span class="text-gray-500 dark:text-gray-400">مقدار قابل تامین: <span class="font-semibold">{{ $item->supplied_quantity }} {{ $item->originalItem->unit }}</span></span>
                                                <span class="text-gray-500 dark:text-gray-400">قیمت واحد: <span class="font-semibold">{{ number_format($item->price_per_unit) }} تومان</span></span>
                                            </div>
                                        </div>

                                        @can('confirmResponses', $viewingRequest)
                                            @if($item->originalItem->status === 'pending_offer')
                                                <x-secondary-button wire:click="setFinalItemResponse({{ $item->id }})">تایید این آیتم</x-secondary-button>
                                            @else
                                                @if($item->originalItem->final_supplier_response_item_id === $item->id)
                                                    <span class="px-2 py-1 text-xs font-semibold text-green-800 bg-green-100 rounded-full">تایید شد</span>
                                                @else
                                                    <span class="px-2 py-1 text-xs font-semibold text-gray-800 bg-gray-100 rounded-full">پیشنهاد دیگر</span>
                                                @endif
                                            @endif
                                        @endcan
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @empty
                        <p class="text-center text-gray-500 dark:text-gray-400">
                            هنوز هیچ پاسخی برای این درخواست ثبت نشده است.
                        </p>
                    @endforelse
                </div>
            @endif
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingResponseView', false)" wire:loading.attr="disabled">
                بستن
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal جدید برای مشاهده وضعیت ارسال -->
    <x-dialog-modal wire:model.live="confirmingShipmentView" maxWidth="2xl">
        <x-slot name="title">
            وضعیت ارسال برای درخواست ({{ $requestWithShipments?->request_code }})
        </x-slot>

        <x-slot name="content">
            @if ($requestWithShipments)
                <div class="space-y-4">
                    @forelse ($shipmentsForRequest as $shipment)
                        <div class="p-4 border-2 rounded-lg dark:border-gray-600">
                            <div class="flex flex-col sm:flex-row justify-between items-start gap-4">
                                <div>
                                    <p><span class="font-semibold">ارسال شده توسط:</span> <span class="font-bold text-indigo-600 dark:text-indigo-400">{{ $shipment['supplier_name'] }}</span></p>
                                    <p><span class="font-semibold">شیوه ارسال:</span> {{ $shipment['shipping_method'] }}</p>
                                    <p><span class="font-semibold">کد رهگیری:</span> <span class="font-mono">{{ $shipment['tracking_code'] ?? 'ثبت نشده' }}</span></p>
                                    <p><span class="font-semibold">تاریخ ارسال:</span> {{ verta($shipment['dispatched_at'])->format('Y/m/d') }}</p>
                                </div>
                                <div class="flex-shrink-0">
                                    @if ($shipment['status'] === 'shipped')
                                        <x-button wire:click="promptForDeliveryConfirmation({{ $shipment['id'] }})" class="bg-green-600 hover:bg-green-700">
                                            <x-lucide-package-check class="w-4 h-4 ml-2"/>
                                            تایید دریافت کالا
                                        </x-button>
                                    @elseif ($shipment['status'] === 'delivered' || $shipment['status'] === 'auto_delivered')
                                        <span class="inline-flex items-center px-3 py-1 text-xs font-semibold text-green-800 bg-green-100 rounded-full">
                                            <x-lucide-check-circle class="w-4 h-4 ml-2"/>
                                            دریافت شد در {{ verta($shipment['delivered_at'])->format('Y/m/d') }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <h4 class="font-semibold text-gray-800 dark:text-gray-200 mt-4 pt-4 border-t dark:border-gray-700">آیتم‌های موجود در این بسته:</h4>
                            <ul class="list-disc list-inside mt-2 space-y-1">
                                @foreach($shipment['items'] as $item)
                                    <li class="text-sm text-gray-600 dark:text-gray-300">
                                        {{ $item['name'] }} (مقدار: {{ $item['quantity'] }} {{ $item['unit'] }})
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    @empty
                        <p class="text-center text-gray-500 dark:text-gray-400">هنوز هیچ بسته‌ای برای این سفارش ارسال نشده است.</p>
                    @endforelse
                </div>
            @endif
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingShipmentView', false)">
                بستن
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [NEW] Modal for Confirming Delivery -->
    <x-confirmation-modal wire:model.live="confirmingShipmentDelivery">
        <x-slot name="title">
            تایید دریافت بسته
        </x-slot>
        <x-slot name="content">
            آیا تایید می‌کنید که این بسته و تمام محتویات آن را به درستی دریافت کرده‌اید؟ این عملیات غیرقابل بازگشت است.
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingShipmentDelivery', false)">انصراف</x-secondary-button>
            <x-button class="ms-3 bg-green-600 hover:bg-green-700" wire:click="confirmDelivery">
                بله، تایید می‌کنم
            </x-button>
        </x-slot>
    </x-confirmation-modal>

</div>
