<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            مدیریت تیم‌های تحقیقاتی
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="flex flex-col md:flex-row gap-8">
                <!-- ستون سمت راست (لیست تیم‌ها) -->
                <aside class="md:w-1/4">
                    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-4">
                        <h3 class="font-semibold text-gray-900 dark:text-white border-b dark:border-gray-700 pb-2">تیم‌های شما</h3>
                        <nav class="mt-4 space-y-1">
                            @foreach($managedTeams as $team)
                                <a href="#" wire:click.prevent="selectTeam({{ $team->id }})"
                                   class="flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors
                                          {{ $activeTeam && $activeTeam->id === $team->id ? 'bg-blue-100 dark:bg-blue-900/50 text-blue-700 dark:text-blue-300' : 'text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700' }}"
                                >
                                    {{ $team->name }}
                                </a>
                            @endforeach
                        </nav>
                    </div>
                </aside>

                <!-- ستون سمت چپ (جزئیات و مدیریت تیم) -->
                <main class="flex-1">
                    @if($activeTeam)
                        <div class="space-y-8">

                            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                                <!-- Purchasing Manager Card -->
                                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">معرفی مسئول خرید</h3>
                                    <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                        این عضو به عنوان مسئول خرید تیم شناخته شده و می‌تواند فرآیندهای مالی را مدیریت کند.
                                    </p>

                                    @if (session()->has('purchasing_message'))
                                        <div class="mt-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300">{{ session('purchasing_message') }}</div>
                                    @endif
                                    @if (session()->has('purchasing_error'))
                                        <div class="mt-4 p-4 text-sm text-red-800 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300">{{ session('purchasing_error') }}</div>
                                    @endif

                                    @if($activeTeam->purchasingManager)
                                        <div class="mt-4 p-3 bg-blue-50 dark:bg-blue-900/50 rounded-lg">
                                            <p class="text-sm text-gray-800 dark:text-gray-200">
                                                مسئول فعلی: <span class="font-bold">{{ $activeTeam->purchasingManager->name }}</span>
                                            </p>
                                        </div>
                                    @endif

                                    <div class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                                        <div class="md:col-span-2">
                                            <x-label for="selectedPurchasingManagerId" value="انتخاب مسئول جدید" />
                                            <select id="selectedPurchasingManagerId" wire:model.defer="selectedPurchasingManagerId" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                                <option value="">-- هیچکس (حذف مسئول) --</option>
                                                @foreach($activeTeam->users as $member)
                                                    <option value="{{ $member->id }}">{{ $member->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div>
                                            <x-button wire:click="assignPurchasingManager" class="w-full justify-center">
                                                ذخیره
                                            </x-button>
                                        </div>
                                    </div>
                                </div>
                                <!-- کارت مدیریت کالیبراسیون -->
                                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">معرفی مسئول کالیبراسیون</h3>
                                <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                    یک نفر از اعضای این تیم را به عنوان مسئول کالیبراسیون تجهیزات انتخاب کنید.
                                </p>

                                @if (session()->has('calibration_message'))
                                    <div class="mt-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300">{{ session('calibration_message') }}</div>
                                @endif
                                @if (session()->has('calibration_error'))
                                    <div class="mt-4 p-4 text-sm text-red-800 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300">{{ session('calibration_error') }}</div>
                                @endif

                                @if($activeTeam->calibrationManager)
                                    <div class="mt-4 p-3 bg-blue-50 dark:bg-blue-900/50 rounded-lg">
                                        <p class="text-sm text-gray-800 dark:text-gray-200">
                                            مسئول فعلی: <span class="font-bold">{{ $activeTeam->calibrationManager->name }}</span>
                                        </p>
                                    </div>
                                @endif

                                <div class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                                    <div class="md:col-span-2">
                                        <x-label for="selectedCalibrationManagerId" value="انتخاب مسئول جدید" />
                                        <select id="selectedCalibrationManagerId" wire:model.defer="selectedCalibrationManagerId" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                            <option value="">-- هیچکس (حذف مسئول) --</option>
                                            {{-- [CORRECTED] --}}
                                            @foreach($activeTeam->users as $member)
                                                <option value="{{ $member->id }}">{{ $member->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div>
                                        <x-button wire:click="assignCalibrationManager" class="w-full justify-center">
                                            ذخیره
                                        </x-button>
                                    </div>
                                </div>
                            </div>
                                <!-- [NEW] Warehouse Manager Card -->
                                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">معرفی مسئول انبار</h3>
                                    <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                        این عضو به تمام امکانات انبار این تیم دسترسی خواهد داشت.
                                    </p>

                                    @if (session()->has('warehouse_message'))
                                        <div class="mt-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300">{{ session('warehouse_message') }}</div>
                                    @endif
                                    @if (session()->has('warehouse_error'))
                                        <div class="mt-4 p-4 text-sm text-red-800 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300">{{ session('warehouse_error') }}</div>
                                    @endif

                                    @if($activeTeam->warehouseManager)
                                        <div class="mt-4 p-3 bg-indigo-50 dark:bg-blue-900/50 rounded-lg">
                                            <p class="text-sm text-gray-800 dark:text-gray-200">
                                                مسئول فعلی: <span class="font-bold">{{ $activeTeam->warehouseManager->name }}</span>
                                            </p>
                                        </div>
                                    @endif

                                    <div class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                                        <div class="md:col-span-2">
                                            <x-label for="selectedWarehouseManagerId" value="انتخاب مسئول جدید" />
                                            <select id="selectedWarehouseManagerId" wire:model.defer="selectedWarehouseManagerId" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                                <option value="">-- هیچکس (حذف مسئول) --</option>
                                                @foreach($activeTeam->users as $member)
                                                    <option value="{{ $member->id }}">{{ $member->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div>
                                            <x-button wire:click="assignWarehouseManager" class="w-full justify-center">
                                                ذخیره
                                            </x-button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [REWRITTEN] کارت مدیریت اعضا و دعوت‌نامه‌ها با تب -->
                            <div x-data="{ activeTab: 'members' }" class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                                <div class="flex justify-between items-center mb-4">
                                    <div class="border-b border-gray-200 dark:border-gray-700">
                                        <nav class="-mb-px flex space-x-6 space-x-reverse" aria-label="Tabs">
                                            <a href="#" @click.prevent="activeTab = 'members'"
                                               :class="{ 'border-blue-500 text-blue-600': activeTab === 'members', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'members' }"
                                               class="whitespace-nowrap py-3 px-1 border-b-2 font-medium text-sm">
                                                اعضای تیم ({{ $activeTeam->users->count() }})
                                            </a>
                                            <a href="#" @click.prevent="activeTab = 'invitations'"
                                               :class="{ 'border-blue-500 text-blue-600': activeTab === 'invitations', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'invitations' }"
                                               class="whitespace-nowrap py-3 px-1 border-b-2 font-medium text-sm">
                                                دعوت‌نامه‌های در انتظار ({{ $activeTeam->invitations->count() }})
                                            </a>
                                            {{-- [NEW] Templates Tab --}}
                                            <a href="#" @click.prevent="activeTab = 'templates'"
                                               :class="{ 'border-blue-500 text-blue-600': activeTab === 'templates', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'templates' }"
                                               class="whitespace-nowrap py-3 px-1 border-b-2 font-medium text-sm">
                                                قالب‌های یادداشت
                                            </a>
                                            <a href="#" @click.prevent="activeTab = 'workload'"
                                               :class="{ 'border-blue-500 text-blue-600': activeTab === 'workload', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'workload' }"
                                               class="whitespace-nowrap py-3 px-1 border-b-2 font-medium text-sm">
                                                گزارش بار کاری
                                            </a>
                                        </nav>
                                    </div>
                                    <x-button wire:click="confirmMemberAddition">افزودن / دعوت عضو</x-button>
                                    <div x-show="activeTab === 'templates'">
                                        <x-button wire:click="confirmTemplateAction">ایجاد قالب جدید</x-button>
                                    </div>
                                </div>

                                @if (session()->has('member_message'))
                                    <div class="mb-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300">{{ session('member_message') }}</div>
                                @endif
                                @if (session()->has('member_error'))
                                    <div class="mb-4 p-4 text-sm text-red-800 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300">{{ session('member_error') }}</div>
                                @endif

                                <!-- Members Tab Content -->
                                <div x-show="activeTab === 'members'" class="flow-root">
                                    <ul role="list" class="divide-y divide-gray-200 dark:divide-gray-700">
                                        @foreach($activeTeam->users as $member)
                                            <li class="py-3 sm:py-4">
                                                <div class="flex items-center space-x-4 space-x-reverse">
                                                    <div class="flex-shrink-0">
                                                        <img class="w-8 h-8 rounded-full" src="{{ $member->profile_photo_url }}" alt="{{ $member->name }}">
                                                    </div>
                                                    <div class="flex-1 min-w-0">
                                                        {{-- [NEW] نام کاربر اکنون یک دکمه برای باز کردن مودال است --}}
                                                        <button wire:click="viewMember({{ $member->id }})" class="text-sm font-medium text-gray-900 truncate dark:text-white hover:underline">
                                                            {{ $member->name }}
                                                        </button>
                                                        <p class="text-sm text-gray-500 truncate dark:text-gray-400">{{ $member->email }}</p>
                                                    </div>
                                                    <div class="inline-flex items-center text-base font-semibold text-gray-900 dark:text-white">
                                                        <span class="badge badge-primary">{{ $member->pivot->role }}</span>
                                                    </div>
                                                    <div class="inline-flex items-center space-x-2 space-x-reverse">
                                                        {{-- [UPDATED] دکمه تغییر نقش فقط برای غیر مدیران نمایش داده می‌شود --}}
                                                        @if($member->pivot->role !== 'admin')
                                                            <button wire:click="confirmPermissionEdit({{ $member->id }})" class="text-green-500 hover:text-green-700" title="ویرایش مجوزها">
                                                                <x-lucide-shield-check class="w-5 h-5"/>
                                                            </button>
                                                            <button wire:click="confirmRoleChange({{ $member->id }})" class="text-indigo-500 hover:text-indigo-700" title="تغییر نقش">
                                                                <x-lucide-user-cog class="w-5 h-5"/>
                                                            </button>
                                                            <button wire:click="confirmMemberRemoval({{ $member->id }})" class="text-red-500 hover:text-red-700" title="حذف عضو">
                                                                <x-lucide-trash-2 class="w-5 h-5"/>
                                                            </button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>

                                <!-- Invitations Tab Content -->
                                <div x-show="activeTab === 'invitations'" class="flow-root">
                                    <ul role="list" class="divide-y divide-gray-200 dark:divide-gray-700">
                                        @forelse($activeTeam->invitations as $invitation)
                                            <li class="py-3 sm:py-4">
                                                <div class="flex items-center space-x-4 space-x-reverse">
                                                    <div class="flex-1 min-w-0">
                                                        <p class="text-sm font-medium text-gray-900 truncate dark:text-white">{{ $invitation->email }}</p>
                                                        <p class="text-sm text-gray-500 truncate dark:text-gray-400">نقش پیشنهادی: {{ $invitation->role }}</p>
                                                    </div>
                                                    <div class="inline-flex items-center">
                                                        <button wire:click="cancelInvitation({{ $invitation->id }})" class="text-red-500 hover:text-red-700">لغو دعوت</button>
                                                    </div>
                                                </div>
                                            </li>
                                        @empty
                                            <li class="text-center text-sm text-gray-500 py-4">هیچ دعوت‌نامه فعالی وجود ندارد.</li>
                                        @endforelse
                                    </ul>
                                </div>
                                <!-- [NEW] Templates Tab Content -->
                                <div x-show="activeTab === 'templates'" class="flow-root">
                                    @if (session()->has('template_message'))
                                        <div class="mb-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300">{{ session('template_message') }}</div>
                                    @endif
                                    <ul role="list" class="divide-y divide-gray-200 dark:divide-gray-700">
                                        @forelse($activeTeam->labNotebookTemplates as $template)
                                            <li class="py-3 sm:py-4">
                                                <div class="flex items-center space-x-4 space-x-reverse">
                                                    <div class="flex-1 min-w-0">
                                                        <p class="text-sm font-medium text-gray-900 truncate dark:text-white">{{ $template->title }}</p>
                                                        <p class="text-sm text-gray-500 truncate dark:text-gray-400">{{ $template->description }}</p>
                                                    </div>
                                                    <div class="inline-flex items-center space-x-2 space-x-reverse">
                                                        <button wire:click="confirmTemplateAction({{ $template->id }})" class="text-indigo-500 hover:text-indigo-700" title="ویرایش قالب">
                                                            <x-lucide-file-pen-line class="w-5 h-5"/>
                                                        </button>
                                                        <button wire:click="confirmTemplateDeletion({{ $template->id }})" class="text-red-500 hover:text-red-700" title="حذف قالب">
                                                            <x-lucide-trash-2 class="w-5 h-5"/>
                                                        </button>
                                                    </div>
                                                </div>
                                            </li>
                                        @empty
                                            <li class="text-center text-sm text-gray-500 py-6">
                                                هنوز هیچ قالبی برای این تیم ایجاد نشده است.
                                            </li>
                                        @endforelse
                                    </ul>
                                </div>
                                <!-- [NEW] Workload Report Tab Content -->
                                <div x-show="activeTab === 'workload'" class="text-center py-8">
                                    <p class="text-gray-600 dark:text-gray-400 mb-4">برای مشاهده گزارش توزیع بار کاری اعضای این تیم، روی دکمه زیر کلیک کنید.</p>
                                    <x-button @click="window.open('{{ route('teams.workload-report', $activeTeam) }}', '_blank')">
                                        نمایش گزارش در پنجره جدید
                                    </x-button>
                                </div>
                            </div>
                            <!-- [NEW] کارت گزارش کلی منابع مصرفی -->
                            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">گزارش کلی منابع مصرفی تیم</h3>
                                <div class="flow-root">
                                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                                        <tr>
                                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">نام ماده</th>
                                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">کل مصرف شده</th>
                                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">موجودی فعلی انبار</th>
                                        </tr>
                                        </thead>
                                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                        @forelse($consumedResourcesReport as $item)
                                            <tr>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $item['name'] }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $item['total_consumed'] }} {{ $item['unit'] }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $item['current_stock'] }} {{ $item['unit'] }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="3" class="px-6 py-4 text-center text-sm text-gray-500">
                                                    هنوز هیچ ماده‌ای در پروژه‌های این تیم مصرف نشده است.
                                                </td>
                                            </tr>
                                        @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- [NEW] کارت تنظیمات تیم -->
                            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">تنظیمات تیم</h3>
                                <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">در این بخش می‌توانید اطلاعات اصلی تیم را ویرایش کنید.</p>
                                @if (session()->has('settings_message'))
                                    <div class="mt-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300">{{ session('settings_message') }}</div>
                                @endif
                                <div class="mt-4">
                                    <x-button wire:click="confirmTeamSettings">ویرایش اطلاعات تیم</x-button>
                                </div>
                            </div>
                            <!-- [NEW] کارت بورد اطلاعیه‌های داخلی تیم -->
                            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                                <div class="flex justify-between items-center mb-4">
                                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">بورد اطلاعیه‌های تیم</h3>
                                    <x-button wire:click="confirmAnnouncementAction">ایجاد اطلاعیه</x-button>
                                </div>
                                @if (session()->has('announcement_message'))
                                    <div class="mb-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300">{{ session('announcement_message') }}</div>
                                @endif
                                <div class="space-y-4">
                                    @forelse($activeTeam->announcements as $announcement)
                                        <div class="p-4 rounded-lg border-r-4 {{ $announcement->level === 'danger' ? 'border-red-500' : ($announcement->level === 'warning' ? 'border-yellow-500' : 'border-blue-500') }}">
                                            <div class="flex justify-between items-center">
                                                <h4 class="font-bold text-gray-900 dark:text-white">{{ $announcement->title }}</h4>
                                                <div class="flex items-center gap-2">
                                                    <button wire:click="confirmAnnouncementAction({{ $announcement->id }})" class="text-gray-400 hover:text-indigo-600">ویرایش</button>
                                                    <button wire:click="confirmAnnouncementDeletion({{ $announcement->id }})" class="text-gray-400 hover:text-red-600">حذف</button>
                                                </div>
                                            </div>
                                            <p class="mt-2 text-sm text-gray-700 dark:text-gray-300">{{ $announcement->body }}</p>
                                        </div>
                                    @empty
                                        <p class="text-center text-sm text-gray-500 py-4">هیچ اطلاعیه‌ای برای این تیم ثبت نشده است.</p>
                                    @endforelse
                                </div>
                            </div>
                            <!-- کارت چک‌لیست ورود اعضا -->
                            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">چک‌لیست ورود اعضای جدید</h3>
                                <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                    وظایف استانداردی که هر عضو جدید باید انجام دهد را در اینجا تعریف کنید. این وظایف به صورت خودکار برای اعضای جدید ایجاد خواهند شد.
                                </p>

                                <div class="mt-4 space-y-2">
                                    <ul wire:sortable="updateChecklistOrder" class="space-y-2">
                                        @forelse($activeTeam->onboardingChecklistItems as $item)
                                            <li wire:sortable.item="{{ $item->id }}" wire:key="checklist-item-{{ $item->id }}" class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                                <div class="flex items-center">
                                                    <button wire:sortable.handle class="cursor-move text-gray-400 hover:text-gray-600">
                                                        <x-lucide-grip-vertical class="w-5 h-5"/>
                                                    </button>
                                                    <span class="ms-2 text-sm text-gray-800 dark:text-gray-200">{{ $item->title }}</span>
                                                </div>
                                                <button wire:click="removeChecklistItem({{ $item->id }})" class="text-red-500 hover:text-red-700">
                                                    <x-lucide-x class="w-4 h-4"/>
                                                </button>
                                            </li>
                                        @empty
                                            <li class="text-center text-sm text-gray-500 py-4">هنوز هیچ آیتمی در چک‌لیست تعریف نشده است.</li>
                                        @endforelse
                                    </ul>
                                </div>

                                <form wire:submit.prevent="addChecklistItem" class="mt-4 flex items-center gap-2">
                                    <x-input type="text" wire:model="newChecklistItem" class="flex-grow" placeholder="افزودن وظیفه جدید..." />
                                    <x-button type="submit">افزودن</x-button>
                                </form>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-16">
                            <p class="text-gray-500">برای شروع، یک تیم را از لیست انتخاب کنید.</p>
                        </div>
                    @endif
                </main>
            </div>
        </div>
    </div>

    <!-- [REWRITTEN] Add/Invite Member Modal -->
    <x-dialog-modal wire:model.live="confirmingMemberAddition">
        <x-slot name="title">افزودن یا دعوت عضو جدید</x-slot>
        <x-slot name="content">
            <div class="space-y-4">
                <div class="relative">
                    <x-label for="userSearch" value="جستجوی کاربر یا وارد کردن ایمیل" />
                    <x-input id="userSearch" type="text" class="w-full mt-1" wire:model.live.debounce.300ms="userSearch" placeholder="نام، نام کاربری یا ایمیل..." autocomplete="off" />

                    {{-- نمایش نتایج جستجو برای کاربران موجود --}}
                    @if(count($userSearchResults) > 0)
                        <ul class="absolute z-50 w-full bg-white dark:bg-gray-900 border rounded-md mt-1 max-h-56 overflow-auto">
                            @foreach($userSearchResults as $result)
                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-700" wire:click="addMember({{ $result->id }})">
                                    {{ $result->name }} ({{ $result->username }})
                                </li>
                            @endforeach
                        </ul>
                    @endif

                    {{-- نمایش گزینه دعوت با ایمیل در صورت عدم یافتن نتیجه --}}
                    @if(strlen($userSearch) > 2 && count($userSearchResults) === 0 && filter_var($userSearch, FILTER_VALIDATE_EMAIL))
                        <div class="mt-4 p-4 bg-blue-50 dark:bg-blue-900/30 rounded-lg text-center">
                            <p class="text-sm text-gray-700 dark:text-gray-300">کاربری با این مشخصات یافت نشد.</p>
                            <button type="button" wire:click="inviteMemberByEmail" class="mt-2 text-sm font-semibold text-blue-600 hover:underline">
                                ارسال دعوت‌نامه به ایمیل {{ $userSearch }}
                            </button>
                        </div>
                    @endif
                    <x-input-error for="userSearch" class="mt-2"/>
                </div>
                <div>
                    <x-label for="roleToAdd" value="نقش در تیم" />
                    <select id="roleToAdd" wire:model.defer="roleToAdd" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="member">عضو</option>
                        <option value="researcher">محقق</option>
                    </select>
                </div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingMemberAddition', false)">بستن</x-secondary-button>
        </x-slot>
    </x-dialog-modal>



    <x-confirmation-modal wire:model.live="confirmingMemberRemoval">
        <x-slot name="title">حذف عضو از تیم</x-slot>
        <x-slot name="content">آیا از حذف {{ $memberToRemove?->name }} از این تیم مطمئن هستید؟</x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingMemberRemoval', false)">انصراف</x-secondary-button>
            <x-danger-button class="ms-3" wire:click="removeMember">حذف</x-danger-button>
        </x-slot>
    </x-confirmation-modal>
    <!-- [NEW] Change Role Modal -->
    <x-dialog-modal wire:model.live="confirmingRoleChange">
        <x-slot name="title">
            تغییر نقش: {{ $editingMember?->name }}
        </x-slot>
        <x-slot name="content">
            <div>
                <x-label for="newRoleForMember" value="نقش جدید در تیم" />
                <select id="newRoleForMember" wire:model.defer="newRoleForMember" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                    <option value="member">عضو</option>
                    <option value="researcher">محقق</option>
                </select>
                <x-input-error for="newRoleForMember" class="mt-2"/>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingRoleChange', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="updateMemberRole">ذخیره تغییرات</x-button>
        </x-slot>
    </x-dialog-modal>
    <!-- [NEW] View Member Profile Modal -->
    <x-dialog-modal wire:model.live="confirmingMemberView">
        <x-slot name="title">
            پروفایل کاربر
        </x-slot>
        <x-slot name="content">
            @if($viewingMember)
                <div class="flex flex-col items-center">
                    <img class="h-24 w-24 rounded-full object-cover" src="{{ $viewingMember->profile_photo_url }}" alt="{{ $viewingMember->name }}">
                    <h3 class="mt-4 text-xl font-bold text-gray-900 dark:text-white">{{ $viewingMember->name }}</h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400">@ {{ $viewingMember->username }}</p>
                </div>
                <div class="mt-6 border-t dark:border-gray-700 pt-4">
                    <dl class="grid grid-cols-1 gap-y-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">ایمیل</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-200">{{ $viewingMember->email }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">تلفن</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-200">{{ $viewingMember->phone_number ?? '-' }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">نقش‌های سراسری در سیستم</dt>
                            <dd class="mt-1 flex flex-wrap gap-2">
                                @forelse($viewingMember->roles as $role)
                                    <span class="badge badge-secondary">{{ $role->name }}</span>
                                @empty
                                    <span class="text-xs text-gray-400 italic">هیچ نقش سراسری ندارد.</span>
                                @endforelse
                            </dd>
                        </div>
                    </dl>
                </div>
            @endif
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingMemberView', false)">
                بستن
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>
    <!-- Team Settings Modal -->
    <x-dialog-modal wire:model.live="confirmingTeamSettings">
        <x-slot name="title">
            ویرایش تنظیمات تیم: {{ $activeTeam?->name }}
        </x-slot>
        <x-slot name="content">
            <div class="space-y-4">
                <div>
                    <x-label for="team_name" value="نام تیم" />
                    <x-input id="team_name" type="text" class="w-full mt-1" wire:model.defer="teamState.name" />
                    <x-input-error for="teamState.name" class="mt-2"/>
                </div>
                <div>
                    <x-label for="team_description" value="توضیحات تیم" />
                    <textarea id="team_description" wire:model.defer="teamState.description" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm" rows="4"></textarea>
                    <x-input-error for="teamState.description" class="mt-2"/>
                </div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingTeamSettings', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="saveTeamSettings">ذخیره تغییرات</x-button>
        </x-slot>
    </x-dialog-modal>
    <!-- [REWRITTEN] Create/Edit Announcement Modal -->
    <x-dialog-modal wire:model.live="confirmingAnnouncementAction">
        <x-slot name="title">
            {{ $editingAnnouncement ? 'ویرایش اطلاعیه' : 'ایجاد اطلاعیه جدید' }}
        </x-slot>
        <x-slot name="content">
            <div class="space-y-4">
                <div>
                    <x-label for="ann_title" value="عنوان" />
                    <x-input id="ann_title" type="text" class="w-full mt-1" wire:model.defer="announcementState.title" />
                    <x-input-error for="announcementState.title" class="mt-2"/>
                </div>
                <div>
                    <x-label for="ann_body" value="متن اطلاعیه" />
                    <textarea id="ann_body" wire:model.defer="announcementState.body" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm" rows="4"></textarea>
                    <x-input-error for="announcementState.body" class="mt-2"/>
                </div>
                {{-- [NEW] Attachment Section --}}
                <div>
                    <x-label for="ann_attachment" value="فایل پیوست (اختیاری)" />
                    @if($existingAttachmentName)
                        <div class="mt-2 flex items-center justify-between p-2 bg-gray-100 dark:bg-gray-700 rounded-md">
                            <span class="text-sm font-medium">{{ $existingAttachmentName }}</span>
                            <button type="button" wire:click="removeAttachment" class="text-xs text-red-500 hover:underline">حذف</button>
                        </div>
                    @else
                        <input type="file" id="ann_attachment" wire:model="announcementAttachment" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100"/>
                        <div wire:loading wire:target="announcementAttachment" class="mt-2 text-sm text-gray-500">در حال آپلود...</div>
                        <x-input-error for="announcementAttachment" class="mt-2"/>
                    @endif
                </div>
                <div>
                    <x-label for="ann_level" value="سطح اهمیت" />
                    <select id="ann_level" wire:model.defer="announcementState.level" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="info">اطلاع‌رسانی</option>
                        <option value="warning">هشدار</option>
                        <option value="danger">خطر</option>
                    </select>
                </div>
                <div class="flex items-center">
                    <x-checkbox id="ann_is_pinned" wire:model.defer="announcementState.is_pinned" />
                    <label for="ann_is_pinned" class="ms-2 text-sm text-gray-600 dark:text-gray-400">سنجاق کردن در بالای بورد</label>
                </div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingAnnouncementAction', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="saveAnnouncement">ذخیره</x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Delete Announcement Confirmation Modal -->
    <x-confirmation-modal wire:model.live="confirmingAnnouncementDeletion">
        <x-slot name="title">حذف اطلاعیه</x-slot>
        <x-slot name="content">آیا از حذف این اطلاعیه مطمئن هستید؟</x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingAnnouncementDeletion')">انصراف</x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteAnnouncement">حذف</x-danger-button>
        </x-slot>
    </x-confirmation-modal>
    <!-- [NEW] Edit Member Permissions Modal -->
    <x-dialog-modal wire:model.live="confirmingPermissionEdit">
        <x-slot name="title">
            ویرایش مجوزهای: {{ $editingPermissionsFor?->name }}
        </x-slot>
        <x-slot name="content">
            <div class="pt-4">
                <x-label value="مجوزهای سفارشی در این تیم" />
                <div class="mt-3 grid grid-cols-2 md:grid-cols-3 gap-4">
                    @foreach($allTeamPermissions as $permission)
                        <label for="perm-{{ $permission->id }}" class="flex items-center p-2 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700/50">
                            <x-checkbox id="perm-{{ $permission->id }}" wire:model="memberPermissions" value="{{ $permission->id }}" />
                            <span class="ms-2 text-sm text-gray-700 dark:text-gray-300">{{ $permission->name }}</span>
                        </label>
                    @endforeach
                </div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingPermissionEdit', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="updateMemberPermissions">ذخیره تغییرات</x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Create/Edit Template Modal -->
    <x-dialog-modal wire:model.live="confirmingTemplateAction" maxWidth="2xl">
        <x-slot name="title">
            {{ $editingTemplate ? 'ویرایش قالب یادداشت' : 'ایجاد قالب یادداشت جدید' }}
        </x-slot>

        <x-slot name="content">
            <div class="space-y-4">
                <div>
                    <x-label for="template_title" value="عنوان قالب" />
                    <x-input id="template_title" type="text" class="w-full mt-1" wire:model.defer="templateState.title" />
                    <x-input-error for="templateState.title" class="mt-2"/>
                </div>
                <div>
                    <x-label for="template_description" value="توضیحات (اختیاری)" />
                    <textarea id="template_description" wire:model.defer="templateState.description" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm" rows="2"></textarea>
                    <x-input-error for="templateState.description" class="mt-2"/>
                </div>
                <div
                    wire:ignore
                    x-data="{
                    editor: null,
                    initEditor(content) {
                        if (typeof Jodit === 'undefined') return;
                        if (this.editor) this.editor.destruct();
                        this.editor = Jodit.make(this.$refs.editor, {
                            direction: 'rtl',
                            language: 'fa',
                            height: 300,
                        });
                        this.editor.value = content;
                        this.editor.events.on('change', (newValue) => {
                            @this.set('templateState.body', newValue);
                        });
                    }
                }"
                    x-init="initEditor($wire.get('templateState.body') || '')"
                    @init-template-editor.window="initEditor($event.detail.content)"
                >
                    <x-label value="محتوای قالب" />
                    <textarea x-ref="editor"></textarea>
                </div>
                <x-input-error for="templateState.body" class="mt-2"/>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingTemplateAction', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="saveTemplate">ذخیره قالب</x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Delete Template Confirmation Modal -->
    <x-confirmation-modal wire:model.live="confirmingTemplateDeletion">
        <x-slot name="title">
            حذف قالب یادداشت
        </x-slot>
        <x-slot name="content">
            آیا از حذف قالب "{{ $templateToDelete?->title }}" مطمئن هستید؟ این عملیات غیرقابل بازگشت است.
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingTemplateDeletion', false)">انصراف</x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteTemplate">
                بله، حذف کن
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>

</div>
@push('scripts')
    {{-- Jodit Editor via CDN --}}

    <script src="https://cdn.jsdelivr.net/npm/jodit@latest/es2021/jodit.fat.min.js"></script>
    <script src="https://cdn.jsdelivr.net/gh/livewire/sortable@v1.x.x/dist/livewire-sortable.js"></script>
@endpush

