<div>
    <x-dialog-modal wire:model.live="showingModal" maxWidth="2xl">
        <x-slot name="title">
            جزئیات وظیفه: <span class="font-bold">{{ $task?->title }}</span>
        </x-slot>

        <x-slot name="content">
            @if($task)
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <!-- Main Content -->
                    <div class="md:col-span-2 space-y-6">
                        <!-- Description -->
                        <div>
                            <h4 class="font-semibold text-gray-800 dark:text-gray-200">شرح وظیفه</h4>
                            <p class="mt-2 text-sm text-gray-600 dark:text-gray-400 prose max-w-none">{{ $task->description ?? 'شرحی ارائه نشده است.' }}</p>
                        </div>
                        <!-- [NEW] Time Tracking Section -->
                        <div class="border-t dark:border-gray-700 pt-4">
                            <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">ثبت زمان</h4>
                            {{-- تایمر فقط برای مسئولین وظیفه نمایش داده می‌شود --}}
                            @if($task->assignees->contains(Auth::user()))
                                <div class="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg flex items-center justify-between">
                                    @if($activeTimer)
                                        <div class="text-sm text-yellow-600 dark:text-yellow-400 animate-pulse">
                                            تایمر در حال اجرا است...
                                        </div>
                                        <x-danger-button wire:click="toggleTimer">
                                            <x-lucide-square class="w-4 h-4 ml-2"/>
                                            توقف تایمر
                                        </x-danger-button>
                                    @else
                                        <div class="text-sm text-gray-500">
                                            زمان خود را برای این وظیفه ثبت کنید.
                                        </div>
                                        <x-button class="bg-green-600 hover:bg-green-700" wire:click="toggleTimer">
                                            <x-lucide-play class="w-4 h-4 ml-2"/>
                                            شروع تایمر
                                        </x-button>
                                    @endif
                                </div>
                            @endif

                            {{-- لیست لاگ‌های زمانی ثبت شده --}}
                            <div class="mt-4 space-y-2">
                                @forelse($task->timeLogs as $log)
                                    <div class="flex items-center justify-between p-2 text-sm">
                                        <div class="flex items-center gap-2">
                                            <img class="h-6 w-6 rounded-full" src="{{ $log->user->profile_photo_url }}" alt="{{ $log->user->name }}">
                                            <span>{{ $log->user->name }}</span>
                                        </div>
                                        <div class="text-gray-500 dark:text-gray-400">
                                            {{ \Carbon\CarbonInterval::seconds($log->duration_in_seconds)->cascade()->forHumans() }}
                                        </div>
                                        <div class="text-xs text-gray-400">
                                            {{ verta($log->started_at)->format('Y/m/d') }}
                                        </div>
                                    </div>
                                @empty
                                    <p class="text-xs text-gray-500 italic text-center py-2">هنوز زمانی برای این وظیفه ثبت نشده است.</p>
                                @endforelse
                            </div>
                        </div>

                        <!-- [NEW] Linked Lab Notebook Entries Section -->
                        <div class="border-t dark:border-gray-700 pt-4">
                            <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">یادداشت‌های آزمایشگاه مرتبط</h4>
                            <div class="space-y-2">
                                @forelse($task->labNotebookEntries as $entry)
                                    <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                        <a href="{{ route('entries.edit', $entry) }}" class="text-sm font-medium text-blue-600 dark:text-blue-400 hover:underline">{{ $entry->title }}</a>
                                        <button wire:click="unlinkEntry({{ $entry->id }})" class="text-red-500 hover:text-red-700">
                                            <x-lucide-unlink-2 class="w-4 h-4"/>
                                        </button>
                                    </div>
                                @empty
                                    <p class="text-xs text-gray-500 italic">هنوز یادداشتی به این وظیفه مرتبط نشده است.</p>
                                @endforelse
                            </div>
                            <div class="relative mt-4">
                                <x-input id="entrySearch" type="text" class="w-full"
                                         wire:model.live.debounce.300ms="entrySearch"
                                         placeholder="جستجو و افزودن یادداشت از این طرح..."
                                         autocomplete="off" />
                                @if(count($entrySearchResults) > 0)
                                    <ul class="absolute z-20 w-full bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-700 rounded-md mt-1 max-h-56 overflow-auto shadow-lg">
                                        @foreach($entrySearchResults as $result)
                                            <li class="px-4 py-3 cursor-pointer hover:bg-blue-50 dark:hover:bg-blue-900/50"
                                                wire:click="linkEntry({{ $result->id }})">
                                                <div class="font-bold text-gray-800 dark:text-gray-200">{{ $result->title }}</div>
                                                <div class="text-sm text-gray-500 dark:text-gray-400">تاریخ: {{ verta($result->entry_date)->format('Y/m/d') }}</div>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                        <!-- Attachments -->
                        <div class="border-t dark:border-gray-700 pt-4">
                            <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">پیوست‌ها</h4>
                            <div class="space-y-2">
                                @forelse($task->attachments as $attachment)
                                    <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                        <div class="flex items-center gap-3">
                                            <x-lucide-file class="w-5 h-5 text-gray-400"/>
                                            <span class="text-sm font-medium">{{ $attachment->file_name }}</span>
                                            <span class="text-xs text-gray-500">({{ number_format($attachment->file_size / 1024, 1) }} KB)</span>
                                        </div>
                                        <button wire:click="downloadAttachment({{ $attachment->id }})" class="text-blue-500 hover:text-blue-700">
                                            <x-lucide-download class="w-5 h-5"/>
                                        </button>
                                    </div>
                                @empty
                                    <p class="text-xs text-gray-500 italic">هیچ فایلی پیوست نشده است.</p>
                                @endforelse
                            </div>
                            <form wire:submit.prevent="saveAttachment" class="mt-4">
                                <input type="file" wire:model="newAttachment" class="text-sm">
                                <x-input-error for="newAttachment" class="mt-1" />
                                <x-button type="submit" class="mt-2">آپلود</x-button>
                            </form>
                        </div>

                        <!-- Comments -->
                        <div class="border-t dark:border-gray-700 pt-4">
                            <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-4">نظرات</h4>
                            <div class="space-y-4">
                                @forelse($task->comments as $comment)
                                    <div class="flex items-start gap-3">
                                        <img class="h-8 w-8 rounded-full" src="{{ $comment->user->profile_photo_url }}" alt="{{ $comment->user->name }}">
                                        <div class="flex-1 bg-gray-100 dark:bg-gray-700 p-3 rounded-lg">
                                            <p class="text-sm text-gray-800 dark:text-gray-200">{{ $comment->body }}</p>
                                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1 text-left">{{ $comment->user->name }} - {{ verta($comment->created_at)->formatDifference() }}</p>
                                        </div>
                                    </div>
                                @empty
                                    <p class="text-xs text-gray-500 italic">هنوز نظری ثبت نشده است.</p>
                                @endforelse
                            </div>
                            <form wire:submit.prevent="addComment" class="mt-4">
                                <textarea wire:model.defer="newComment" class="w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm" rows="3" placeholder="نظر خود را بنویسید..."></textarea>
                                <x-input-error for="newComment" class="mt-1" />
                                <x-button type="submit" class="mt-2">ثبت نظر</x-button>
                            </form>
                        </div>
                    </div>

                    <!-- Sidebar -->
                    <div class="md:col-span-1 space-y-4 border-r dark:border-gray-700 pr-6">
                        <div>
                            <h5 class="text-sm font-semibold text-gray-500">وضعیت</h5>
                            <p class="text-md font-bold">{{ $task->status }}</p>
                        </div>
                        <div>
                            <h5 class="text-sm font-semibold text-gray-500">اولویت</h5>
                            <p class="text-md font-bold">{{ $task->priority }}</p>
                        </div>
                        <div>
                            <h5 class="text-sm font-semibold text-gray-500">تاریخ پایان</h5>
                            <p class="text-md font-bold">{{ $task->due_date ? verta($task->due_date)->format('Y/m/d') : '-' }}</p>
                        </div>
                        <div>
                            <h5 class="text-sm font-semibold text-gray-500">مسئولین</h5>
                            <div class="mt-2 space-y-2">
                                @foreach($task->assignees as $assignee)
                                    <div class="flex items-center gap-2">
                                        <img class="h-6 w-6 rounded-full" src="{{ $assignee->profile_photo_url }}" alt="{{ $assignee->name }}">
                                        <span class="text-sm">{{ $assignee->name }}</span>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div>
                            <h5 class="text-sm font-semibold text-gray-500">ایجاد کننده</h5>
                            <p class="text-md font-bold">{{ $task->creator->name }}</p>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showingModal', false)">
                بستن
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>
</div>
