<div>
    {{-- هدر صفحه --}}
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('مدیریت تیم‌های تحقیقاتی') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">

                <div class="p-6 lg:p-8 bg-white dark:bg-gray-800 dark:bg-gradient-to-bl dark:from-gray-700/50 dark:via-transparent border-b border-gray-200 dark:border-gray-700">
                    <div class="flex justify-between items-center">
                        <h1 class="text-2xl font-medium text-gray-900 dark:text-white">
                            تیم‌های سازمان: {{ $institution?->name }}
                        </h1>
                        <x-button wire:click="confirmTeamCreation">
                            ایجاد تیم جدید
                        </x-button>
                        @if (auth()->user()->can('manage-institution')) {
                        <span class="sr-only">2255279</span>
                        }
                        @else
                            <span class="sr-only">salam</span>
                        @endif
                    </div>

                    @if (session()->has('message'))
                        <div class="mt-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                            {{ session('message') }}
                        </div>
                    @endif

                    <div class="mt-6">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    نام تیم
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    کد تیم
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    تعداد اعضا
                                </th>
                                <th scope="col" class="relative px-6 py-3">
                                    <span class="sr-only">عملیات</span>
                                </th>
                            </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @if($institution)
                                @forelse ($institution->researchTeams as $team)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                            {{ $team->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">
                                            {{ $team->research_teams_code }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                            {{ $team->users->count() }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                            {{-- در آینده دکمه مدیریت اعضا را اینجا اضافه می‌کنیم --}}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="px-6 py-4 whitespace-nowrap text-sm text-center text-gray-500 dark:text-gray-400">
                                            هیچ تیمی برای این سازمان ثبت نشده است.
                                        </td>
                                    </tr>
                                @endforelse
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Modal برای ایجاد تیم جدید -->
    <x-dialog-modal wire:model.live="confirmingTeamCreation">
        <x-slot name="title">
            {{ __('ایجاد تیم تحقیقاتی جدید') }}
        </x-slot>

        <x-slot name="content">
            <div>
                <x-label for="newTeamName" value="{{ __('نام تیم') }}" />
                <x-input id="newTeamName" type="text" class="mt-1 block w-full" wire:model.defer="newTeamName" />
                <x-input-error for="newTeamName" class="mt-2" />
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingTeamCreation')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>

            <x-button class="ms-3" wire:click="createTeam" wire:loading.attr="disabled">
                {{ __('ایجاد تیم') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>
</div>
