<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            تاریخچه دمای تجهیز: {{ $equipment->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg p-6">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                    {{-- Filters --}}
                    <div class="md:col-span-1">
                        <h3 class="font-semibold mb-4">فیلترها</h3>
                        <div class="space-y-4 p-4 border rounded-lg">
                            <div>
                                <x-label for="auditorFilter" value="بازرس" />
                                <select wire:model.live="auditorFilter" id="auditorFilter" class="form-select mt-1 w-full">
                                    <option value="">همه</option>
                                    @foreach($auditors as $auditor)
                                        <option value="{{ $auditor->id }}">{{ $auditor->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <x-label for="startDateFilter" value="از تاریخ" />
                                <x-jalali-date-picker id="startDateFilter" wire:model.live="startDateFilter" />
                            </div>
                            <div>
                                <x-label for="endDateFilter" value="تا تاریخ" />
                                <x-jalali-date-picker id="endDateFilter" wire:model.live="endDateFilter" />
                            </div>
                        </div>
                        <div class="mt-4 space-y-2">
                            <x-secondary-button wire:click="exportCsv" class="w-full">خروجی CSV</x-secondary-button>
                            <x-secondary-button wire:click="exportPdf" class="w-full">خروجی PDF</x-secondary-button>
                        </div>
                    </div>

                    {{-- Chart & Table --}}
                    <div class="md:col-span-3">
                        <div class="mb-6 h-64">
                            <canvas id="tempHistoryChart"></canvas>
                        </div>
                        <div class="table-responsive max-h-96">
                            <table class="min-w-full divide-y">
                                {{-- Table Head --}}
                                <tbody>
                                @forelse($logs as $log)
                                    <tr>
                                        <td>{{ verta($log->created_at)->format('Y/m/d H:i') }}</td>
                                        <td>{{ $log->temperature }}°C</td>
                                        <td>{{ $log->auditor->name }}</td>
                                        <td>{{ $log->notes }}</td>
                                    </tr>
                                @empty
                                    <tr><td colspan="4" class="text-center">هیچ لاگی یافت نشد.</td></tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('livewire:initialized', () => {
            let tempChart = null;
            const ctx = document.getElementById('tempHistoryChart').getContext('2d');

            const renderChart = (data) => {
                const labels = Object.keys(data).map(date => new Date(date).toLocaleDateString('fa-IR'));
                const values = Object.values(data);

                if (tempChart) {
                    tempChart.destroy();
                }
                tempChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: labels.reverse(),
                        datasets: [{
                            label: 'دمای ثبت شده',
                            data: values.reverse(),
                            borderColor: 'rgb(59, 130, 246)',
                            backgroundColor: 'rgba(59, 130, 246, 0.1)',
                            fill: true,
                            tension: 0.1
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false
                    }
                });
            };

        @this.on('updateChart', (event) => {
            renderChart(event.data);
        });
        });
    </script>
@endpush
