<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            تست ویجت پیشرفت پروژه
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            {{-- [CORRECTED] ما منطق را از x-data به یک تابع جداگانه منتقل می‌کنیم --}}
            <div
                x-data="progressChartComponent(chartDataForTest)"
                x-init="init()"
                class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8"
            >
                @if($project)
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
                        آمار برای طرح: {{ $project->title }}
                    </h3>
                    <div class="mt-6 grid grid-cols-1 lg:grid-cols-5 gap-8">
                        <!-- Chart -->
                        <div class="lg:col-span-2">
                            <div class="h-64">
                                <canvas x-ref="chart"></canvas>
                            </div>
                        </div>
                        <!-- Task List -->
                        <div class="lg:col-span-3">
                            <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">لیست وظایف</h4>
                            <div class="space-y-2 max-h-64 overflow-y-auto pr-2">
                                @forelse($tasks as $task)
                                    <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                        <p class="font-medium text-gray-900 dark:text-white">{{ $task->title }}</p>
                                    </div>
                                @empty
                                    <p class="text-center text-sm text-gray-500 py-4">هیچ وظیفه‌ای یافت نشد.</p>
                                @endforelse
                            </div>
                        </div>
                    </div>
                @else
                    <p class="text-center text-gray-500">هیچ طرحی با وظایف برای تست یافت نشد.</p>
                @endif
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        // داده‌ها را در یک متغیر جاوا اسکریپت استاندارد قرار می‌دهیم
        const chartDataForTest = @json($chartData);

        // منطق Alpine را به عنوان یک تابع تعریف می‌کنیم تا خواناتر و قابل اعتمادتر باشد
        function progressChartComponent(initialData) {
            return {
                chartData: initialData,
                chart: null,
                init() {
                    this.$nextTick(() => {
                        const ctx = this.$refs.chart;
                        if (!ctx || typeof Chart === 'undefined') {
                            console.error('Chart.js or canvas element not found.');
                            return;
                        }
                        if (!this.chartData || !this.chartData.labels || this.chartData.labels.length === 0) {
                            return;
                        }

                        // پاک کردن نمونه قبلی نمودار برای جلوگیری از تداخل
                        if (window.testChartInstance) {
                            window.testChartInstance.destroy();
                        }

                        window.testChartInstance = new Chart(ctx, {
                            type: 'doughnut',
                            data: {
                                labels: this.chartData.labels,
                                datasets: [{
                                    data: this.chartData.data,
                                    backgroundColor: ['#22c55e', '#f59e0b', '#3b82f6'],
                                    borderColor: document.body.classList.contains('dark') ? '#1f2937' : '#fff',
                                    borderWidth: 2,
                                }]
                            },
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                plugins: { legend: { position: 'bottom' } }
                            }
                        });
                    });
                }
            }
        }
    </script>
@endpush
