<x-action-section>
    <x-slot name="title">
        <span class="text-lg font-bold text-gray-900">تیم‌های من</span>
    </x-slot>

    <x-slot name="description">
        <span class="text-sm text-gray-600">لیست تیم‌های تحقیقاتی که شما در آن‌ها عضو هستید.</span>
    </x-slot>

    <x-slot name="content">
        <div class="bg-white rounded-xl shadow-lg border-t-4 border-blue-600 p-6 sm:p-8">
            <div class="space-y-4">
                @forelse ($teams as $team)
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-3 space-x-reverse">
                            {{-- You can replace this with a team logo if you have one --}}
                            <div class="flex-shrink-0 h-10 w-10 bg-blue-100 rounded-full flex items-center justify-center">
                                <x-lucide-users class="h-6 w-6 text-blue-600"/>
                            </div>
                            <div>
                                <p class="text-sm font-semibold text-gray-900">{{ $team->name }}</p>
                                <p class="text-xs text-gray-500">
                                    نقش شما:
                                    <span class="font-medium text-gray-700">
                                        {{ $team->pivot->role === 'admin' ? 'مدیر' : 'عضو' }}
                                    </span>
                                </p>
                            </div>
                        </div>
                        <div>
                            {{-- This assumes you have a route named 'teams.show' for managing teams --}}
                            <a href="{{ route('research-teams.dashboard') }}" class="text-sm font-semibold text-blue-600 hover:underline">
                                مدیریت تیم
                            </a>
                        </div>
                    </div>
                @empty
                    <p class="text-sm text-gray-500">شما در حال حاضر عضو هیچ تیمی نیستید.</p>
                @endforelse
            </div>
        </div>
    </x-slot>
</x-action-section>
