<x-dialog-modal wire:model.live="showModal" maxWidth="2xl">
    <x-slot name="title">
        @if($selectedVersion)
            <div class="flex items-center">
                <x-lucide-history class="w-6 h-6 ml-2 text-blue-500"/>
                <span>مشاهده نسخه {{ $selectedVersion->version }}</span>
            </div>
        @else
            مشاهده نسخه
        @endif
    </x-slot>

    <x-slot name="content">
        @if($selectedVersion)
            <div class="space-y-6">
                {{-- Content sections remain the same --}}
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm p-4 bg-gray-50 dark:bg-gray-900/50 rounded-lg">
                    <div>
                        <span class="font-semibold text-gray-500 dark:text-gray-400">عنوان نسخه:</span>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $selectedVersion->title }}</p>
                    </div>
                    <div>
                        <span class="font-semibold text-gray-500 dark:text-gray-400">تاریخ ثبت نسخه:</span>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ verta($selectedVersion->entry_date)->format('Y/m/d') }}</p>
                    </div>
                    <div>
                        <span class="font-semibold text-gray-500 dark:text-gray-400">ثبت شده توسط:</span>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $selectedVersion->user->name ?? 'N/A' }}</p>
                    </div>
                </div>
                <div>
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2 border-b dark:border-gray-700 pb-2">محتوای یادداشت</h4>
                    <div class="prose prose-sm max-w-none dark:prose-invert p-4 bg-gray-50 dark:bg-gray-900/50 rounded-lg max-h-60 overflow-y-auto">
                        {!! $selectedVersion->body !!}
                    </div>
                </div>
                <div>
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2 border-b dark:border-gray-700 pb-2">مواد مصرفی در این نسخه</h4>
                    <div class="space-y-2 max-h-48 overflow-y-auto pr-2">
                        @forelse($selectedVersion->materials_log ?? [] as $material)
                            <div class="flex justify-between items-center p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                <span class="text-sm font-medium">{{ $material['name'] }}</span>
                                <span class="text-sm text-gray-500 dark:text-gray-400">{{ $material['quantity_used'] }} {{ $material['unit'] }}</span>
                            </div>
                        @empty
                            <p class="text-xs text-gray-500 italic text-center py-4">هیچ ماده‌ای در این نسخه ثبت نشده است.</p>
                        @endforelse
                    </div>
                </div>
                <div>
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2 border-b dark:border-gray-700 pb-2">پیوست‌های این نسخه</h4>
                    <div class="space-y-2 max-h-48 overflow-y-auto pr-2">
                        @forelse($selectedVersion->attachments_log ?? [] as $attachment)
                            <a href="{{ Storage::url($attachment['file_path']) }}" target="_blank" class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition">
                                <div class="flex items-center gap-3">
                                    <x-lucide-file class="w-5 h-5 text-gray-400"/>
                                    <div>
                                        <span class="text-sm font-medium">{{ $attachment['file_name'] }}</span>
                                        @if($attachment['caption'])
                                            <p class="text-xs text-gray-500 italic">{{ $attachment['caption'] }}</p>
                                        @endif
                                    </div>
                                </div>
                                <x-lucide-download class="w-4 h-4 text-gray-400"/>
                            </a>
                        @empty
                            <p class="text-xs text-gray-500 italic text-center py-4">هیچ فایلی در این نسخه پیوست نشده است.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        @else
            <div class="text-center py-12">
                <p>در حال بارگذاری اطلاعات نسخه...</p>
            </div>
        @endif
    </x-slot>

    <x-slot name="footer">
        {{-- [UPDATED] This button is now active and calls the restore method --}}
        <x-button
            class="bg-green-600 hover:bg-green-700"
            wire:click="confirmRestore"
            wire:confirm="آیا مطمئن هستید؟ با این کار، اطلاعات فرم با مقادیر این نسخه جایگزین می‌شود. برای نهایی شدن تغییرات باید دکمه ذخیره را بزنید."
        >
            <x-lucide-undo-2 class="w-4 h-4 ml-2"/>
            بازگردانی این نسخه
        </x-button>
        <x-secondary-button class="ms-3" wire:click="closeModal">
            بستن
        </x-secondary-button>
    </x-slot>
</x-dialog-modal>
