<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            مدیریت درخواست‌های انبار
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <div class="py-12">
                <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">
                    {{-- [REWRITTEN] کارت درخواست‌های نیازمند بررسی (گروه‌بندی شده) --}}
                    <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg p-6">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">یادداشت‌های نیازمند بررسی</h3>
                        @if (session()->has('message'))
                            <div class="mb-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300">{{ session('message') }}</div>
                        @endif
                        @if (session()->has('error'))
                            <div class="mb-4 p-4 text-sm text-red-800 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300">{{ session('error') }}</div>
                        @endif

                        <div class="table-responsive">
                            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                <thead class="bg-gray-50 dark:bg-gray-700/50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">یادداشت / طرح</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">ایجاد کننده</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">تاریخ ایجاد</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">عملیات</th>
                                </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                @forelse($labNotesWithPendingRequests as $note)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                                            <p class="text-gray-900 dark:text-white font-semibold">{{ $note->title }}</p>
                                            <p class="text-gray-500 dark:text-gray-400">در طرح: {{ $note->project->title }}</p>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $note->user->name }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ verta($note->created_at)->format('Y/m/d') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            <button wire:click="reviewNoteRequests({{ $note->id }})" class="btn btn-primary btn-sm">بررسی درخواست‌ها</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="px-6 py-4 text-center text-sm text-gray-500">هیچ یادداشتی برای بررسی وجود ندارد.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-4">
                            {{ $labNotesWithPendingRequests->links('pagination::bootstrap-5') }}
                        </div>
                    </div>
            {{-- [NEW] کارت تاریخچه درخواست‌های رسیدگی شده --}}
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">تاریخچه درخواست‌های رسیدگی شده</h3>
                <div class="table-responsive">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                        <tr>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">یادداشت</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">ماده</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">مقدار</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">وضعیت نهایی</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">پردازش توسط</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">یادداشت</th>
                        </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @forelse($processedRequests as $request)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <p class="text-gray-900 dark:text-white font-semibold">{{ $request->labNotebookEntry->title }}</p>
                                    <p class="text-gray-500 dark:text-gray-400">در طرح: {{ $request->project->title }}</p>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $request->inventoryItem->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $request->quantity }} {{ $request->inventoryItem->unit }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if($request->status === 'approved')
                                        <span class="badge badge-success">تایید شده</span>
                                    @else
                                        <span class="badge badge-danger">رد شده</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $request->approver?->name ?? 'N/A' }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500" title="{{ $request->notes }}">{{ \Illuminate\Support\Str::limit($request->notes, 30) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-4 text-center text-sm text-gray-500">هیچ درخواست رسیدگی شده‌ای یافت نشد.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    {{ $processedRequests->links() }}
                </div>
            </div>
        </div>
    </div>

            <!-- [REWRITTEN] Modal for Reviewing a Note's Requests with Inline Editing -->
            <x-dialog-modal wire:model.live="confirmingNoteReview" maxWidth="2xl">
                <x-slot name="title">
                    بررسی درخواست‌های یادداشت: <span class="font-bold">{{ $reviewingLabNote?->title }}</span>
                </x-slot>
                <x-slot name="content">
                    <div class="table-responsive">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700/50">
                            <tr>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">ماده</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">درخواست‌دهنده</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">نوع</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">مقدار</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">عملیات</th>
                            </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @if(isset($requestsForNote))
                                @forelse($requestsForNote as $request)
                                    <tr>
                                        <td class="px-4 py-2 text-sm text-gray-900 dark:text-white">{{ $request->inventoryItem->name }}</td>
                                        <td class="px-4 py-2 text-sm text-gray-500">{{ $request->requester->name }}</td>
                                        <td class="px-4 py-2 text-sm">
                                            @if($request->type === 'consumption') <span class="badge badge-danger">مصرف</span> @else <span class="badge badge-success">بازگشت</span> @endif
                                        </td>
                                        <td class="px-4 py-2 text-sm">
                                            {{-- [NEW] بخش ویرایش خطی --}}
                                            @if($editingRequestId === $request->id)
                                                <div>
                                                    <x-input type="number" step="any" class="block w-24 text-center" wire:model.defer="newQuantity" />
                                                    <x-input-error for="newQuantity" class="mt-1"/>
                                                </div>
                                            @else
                                                {{ $request->quantity }} {{ $request->inventoryItem->unit }}
                                            @endif
                                        </td>
                                        <td class="px-4 py-2 text-sm space-x-2 space-x-reverse">
                                            @can('process', $request)
                                                @if($editingRequestId === $request->id)
                                                    <button wire:click="updateAndApproveRequest" class="btn btn-primary btn-sm">ذخیره</button>
                                                    <button wire:click="cancelEditing" class="btn btn-secondary btn-sm">لغو</button>
                                                @else
                                                    <button wire:click="confirmApproval({{ $request->id }})" class="btn btn-success btn-sm">تایید</button>
                                                    <button wire:click="confirmRejection({{ $request->id }})" class="btn btn-danger btn-sm">رد</button>
                                                    <button wire:click="startEditing({{ $request->id }})" class="btn btn-info btn-sm">تغییر</button>
                                                @endif
                                            @else
                                                <span class="text-xs text-gray-400 italic">در انتظار پردازش</span>
                                            @endcan
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="5" class="p-4 text-center text-gray-500">تمام درخواست‌های این یادداشت پردازش شده‌اند.</td></tr>
                                @endforelse
                            @endif
                            </tbody>
                        </table>
                    </div>
                </x-slot>
                <x-slot name="footer">
                    <x-secondary-button wire:click="$set('confirmingNoteReview', false)">بستن</x-secondary-button>
                </x-slot>
            </x-dialog-modal>
    <!-- Approval Modal -->
    <x-confirmation-modal wire:model.live="confirmingApproval">
        <x-slot name="title">تایید درخواست</x-slot>
        <x-slot name="content">آیا از تایید این درخواست و اعمال تغییرات در انبار و بودجه مطمئن هستید؟</x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingApproval', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="approveRequest">تایید</x-button>
        </x-slot>
    </x-confirmation-modal>

    <!-- Rejection Modal -->
    <x-dialog-modal wire:model.live="confirmingRejection">
        <x-slot name="title">رد درخواست</x-slot>
        <x-slot name="content">
            <x-label for="rejectionNotes" value="لطفاً دلیل رد درخواست را وارد کنید:" />
            <textarea id="rejectionNotes" wire:model.defer="rejectionNotes" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm"></textarea>
            <x-input-error for="rejectionNotes" class="mt-2" />
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingRejection', false)">انصراف</x-secondary-button>
            <x-danger-button class="ms-3" wire:click="rejectRequest">رد کردن</x-danger-button>
        </x-slot>
    </x-dialog-modal>
            {{-- [NEW] Budget Override Confirmation Modal --}}
            <x-confirmation-modal wire:model.live="confirmingBudgetOverride">
                <x-slot name="title">
            <span class="text-yellow-600 flex items-center">
                <x-lucide-alert-triangle class="w-6 h-6 ml-2"/>
                هشدار عبور از سقف بودجه
            </span>
                </x-slot>
                <x-slot name="content">
                    {{ $overrideWarningMessage }}
                </x-slot>
                <x-slot name="footer">
                    <x-secondary-button wire:click="$set('confirmingBudgetOverride', false)" wire:loading.attr="disabled">
                        انصراف
                    </x-secondary-button>
                    <x-button class="ms-3 bg-yellow-600 hover:bg-yellow-700" wire:click="approveAndOverrideBudget" wire:loading.attr="disabled">
                        تایید و افزایش بودجه
                    </x-button>
                </x-slot>
            </x-confirmation-modal>
        </div>
    </div>
</div>
