<nav x-data="{ open: false }" class="bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700">
    <!-- Primary Navigation Menu -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('dashboard') }}">
                        <x-application-mark class="block h-9 w-auto" />
                    </a>
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link href="{{ route('dashboard') }}" :active="request()->routeIs('dashboard')">
                        {{ __('داشبورد') }}
                    </x-nav-link>
                    <!-- لینک جدید برای پنل مدیریت -->
                    @can('view-admin-panel')
                        <x-nav-link href="{{ route('admin.institution-requests.index') }}" :active="request()->routeIs('admin.*')">
                            {{ __('پنل مدیریت') }}
                        </x-nav-link>
                    @endcan

                    @can('viewAny', App\Models\Institution::class)
                        <x-nav-link href="{{ route('institutions.index') }}" :active="request()->routeIs('institutions.index')">
                            {{ __('مدیریت نهادها') }}
                        </x-nav-link>
                    @endcan

                    @can('viewAny', App\Models\Project::class)
                        <x-nav-link href="{{ route('projects.index') }}" :active="request()->routeIs('projects.index')">
                            {{ __('مدیریت طرح و برنامه') }}
                        </x-nav-link>
                    @endcan

                    <!-- لینک جدید برای انبارداری -->
                    @can('viewAny', App\Models\InventoryItem::class)
                        <x-nav-link href="{{ route('inventory.index') }}" :active="request()->routeIs('inventory.index')">
                            {{ __('مدیریت انبار') }}
                        </x-nav-link>
                    @endcan

                    {{-- لینک جدید برای مدیریت مکان‌ها --}}
                    {{-- ما این لینک را بعداً می‌توانیم به صورت یک زیرمنو در زیر "مدیریت انبار" قرار دهیم --}}
                    @can('viewAny', App\Models\InventoryItem::class)
                        <x-nav-link href="{{ route('inventory.locations.index') }}" :active="request()->routeIs('inventory.locations.index')">
                            {{ __('مکان‌های انبار') }}
                        </x-nav-link>
                    @endcan
                    {{-- لینک جدید برای حواله انبار --}}
                    @can('viewAny', App\Models\InventoryItem::class)
                        <x-nav-link href="{{ route('inventory.transfers.index') }}" :active="request()->routeIs('inventory.transfers.index')">
                            {{ __('حواله انبار') }}
                        </x-nav-link>
                    @endcan
                    <!-- لینک جدید برای تایید حواله‌ها -->
                    @can('view-transfer-approvals')
                        <x-nav-link href="{{ route('inventory.transfers.approvals') }}" :active="request()->routeIs('inventory.transfers.approvals')">
                            {{ __('تأیید حواله‌ها') }}
                        </x-nav-link>
                    @endcan

                    <!-- لینک جدید برای مدیریت تیم‌ها -->
                    @can('manage-institution')
                        <x-nav-link href="{{ route('institution.teams.index') }}" :active="request()->routeIs('institution.teams.index')">
                            {{ __('مدیریت تیم‌ها') }}
                        </x-nav-link>
                    @endcan

                    @can('viewAny', App\Models\PurchaseRequest::class)
                        <x-nav-link href="{{ route('purchase-requests.index') }}" :active="request()->routeIs('purchase-requests.index')">
                            {{ __('درخواست‌های خرید من') }}
                        </x-nav-link>
                    @endcan

                    <!-- لینک جدید برای صفحه تاییدها با استفاده از Policy -->
                    @can('viewApprovalQueue', App\Models\PurchaseRequest::class)
                        <x-nav-link href="{{ route('approvals.index') }}" :active="request()->routeIs('approvals.index')">
                            <div class="relative inline-flex">
                                {{ __('درخواست های در انتظار') }}

                                {{-- ما می‌توانیم نوتیفیکیشن را مستقیماً در اینجا قرار دهیم --}}
                                @php
                                    $pendingApprovalsCount = \App\Models\PurchaseRequest::where('approver_id', Auth::id())->where('status', 'pending_approval')->count();
                                @endphp

                                @if ($pendingApprovalsCount > 0)
                                    <span class="absolute top-0 right-0 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-red-100 transform translate-x-1/2 -translate-y-1/2 bg-red-600 rounded-full">
                                        {{ $pendingApprovalsCount }}
                                    </span>
                                @endif
                            </div>
                        </x-nav-link>
                    @endcan


                </div>
            </div>

            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <!-- بخش جدید: مرکز اعلان‌ها -->
                @livewire('notification-center')
{{--                <!-- Teams Dropdown -->--}}
{{--                @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())--}}
{{--                    <div class="ms-3 relative">--}}
{{--                        <x-dropdown align="right" width="60">--}}
{{--                            <x-slot name="trigger">--}}
{{--                                <span class="inline-flex rounded-md">--}}
{{--                                    <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none focus:bg-gray-50 dark:focus:bg-gray-700 active:bg-gray-50 dark:active:bg-gray-700 transition ease-in-out duration-150">--}}
{{--                                        {{ Auth::user()->currentTeam->name }}--}}

{{--                                        <svg class="ms-2 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">--}}
{{--                                            <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 15L12 18.75 15.75 15m-7.5-6L12 5.25 15.75 9" />--}}
{{--                                        </svg>--}}
{{--                                    </button>--}}
{{--                                </span>--}}
{{--                            </x-slot>--}}

{{--                            <x-slot name="content">--}}
{{--                                <div class="w-60">--}}
{{--                                    <!-- Team Management -->--}}
{{--                                    <div class="block px-4 py-2 text-xs text-gray-400">--}}
{{--                                        {{ __('مدیریت تیم') }}--}}
{{--                                    </div>--}}

{{--                                    <!-- Team Settings -->--}}
{{--                                    <x-dropdown-link href="{{ route('teams.show', Auth::user()->currentTeam->id) }}">--}}
{{--                                        {{ __('تنظیمات تیم') }}--}}
{{--                                    </x-dropdown-link>--}}

{{--                                    @can('create', Laravel\Jetstream\Jetstream::newTeamModel())--}}
{{--                                        <x-dropdown-link href="{{ route('teams.create') }}">--}}
{{--                                            {{ __('ایجاد تیم جدید') }}--}}
{{--                                        </x-dropdown-link>--}}
{{--                                    @endcan--}}

{{--                                    <!-- Team Switcher -->--}}
{{--                                    @if (Auth::user()->allTeams()->count() > 1)--}}
{{--                                        <div class="border-t border-gray-200 dark:border-gray-600"></div>--}}

{{--                                        <div class="block px-4 py-2 text-xs text-gray-400">--}}
{{--                                            {{ __('تغییر تیم') }}--}}
{{--                                        </div>--}}

{{--                                        @foreach (Auth::user()->allTeams() as $team)--}}
{{--                                            <x-switchable-team :team="$team" />--}}
{{--                                        @endforeach--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                            </x-slot>--}}
{{--                        </x-dropdown>--}}
{{--                    </div>--}}
{{--                @endif--}}

                <!-- Settings Dropdown -->
                <div class="ms-3 relative">
                    <x-dropdown align="right" width="48">
                        <x-slot name="trigger">
                            @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                                <button class="flex text-sm border-2 border-transparent rounded-full focus:outline-none focus:border-gray-300 transition">
                                    <img class="h-8 w-8 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                                </button>
                            @else
                                <span class="inline-flex rounded-md">
                                    <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none focus:bg-gray-50 dark:focus:bg-gray-700 active:bg-gray-50 dark:active:bg-gray-700 transition ease-in-out duration-150">
                                        {{ Auth::user()->first_name }} {{ Auth::user()->last_name }}

                                        <svg class="ms-2 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 8.25l-7.5 7.5-7.5-7.5" />
                                        </svg>
                                    </button>
                                </span>
                            @endif
                        </x-slot>

                        <x-slot name="content">
                            <!-- Account Management -->
                            <div class="block px-4 py-2 text-xs text-gray-400">
                                {{ __('مدیریت حساب کاربری') }}
                            </div>

                            <x-dropdown-link href="{{ route('profile.show') }}">
                                {{ __('پروفایل') }}
                            </x-dropdown-link>

                            @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                                <x-dropdown-link href="{{ route('api-tokens.index') }}">
                                    {{ __('API Tokens') }}
                                </x-dropdown-link>
                            @endif

                            <div class="border-t border-gray-200 dark:border-gray-600"></div>

                            <!-- Authentication -->
                            <form method="POST" action="{{ route('logout') }}" x-data>
                                @csrf

                                <x-dropdown-link href="{{ route('logout') }}"
                                                 @click.prevent="$root.submit();">
                                    {{ __('خروج') }}
                                </x-dropdown-link>
                            </form>
                        </x-slot>
                    </x-dropdown>
                </div>
            </div>

            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500 dark:focus:text-gray-400 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link href="{{ route('dashboard') }}" :active="request()->routeIs('dashboard')">
                {{ __('داشبورد') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link href="{{ route('dashboard') }}" :active="request()->routeIs('dashboard')">
                cfhchcg
            </x-responsive-nav-link>

            @can('viewAny', App\Models\Institution::class)
                <x-responsive-nav-link href="{{ route('institutions.index') }}" :active="request()->routeIs('institutions.index')">
                    {{ __('مدیریت نهادها') }}
                </x-responsive-nav-link>
            @endcan

            @can('viewAny', App\Models\Project::class)
                <x-responsive-nav-link href="{{ route('projects.index') }}" :active="request()->routeIs('projects.index')">
                    {{ __('مدیریت طرح و برنامه') }}
                </x-responsive-nav-link>
            @endcan

            <!-- لینک جدید ما در حالت ریسپانسیو -->
            @can('viewAny', App\Models\InventoryItem::class)
                <x-responsive-nav-link href="{{ route('inventory.index') }}" :active="request()->routeIs('inventory.index')">
                    {{ __('مدیریت انبار') }}
                </x-responsive-nav-link>
            @endcan

            @can('viewAny', App\Models\PurchaseRequest::class)
                <x-responsive-nav-link href="{{ route('purchase-requests.index') }}" :active="request()->routeIs('purchase-requests.index')">
                    {{ __('درخواست‌های خرید من') }}
                </x-responsive-nav-link>
            @endcan

            <!-- لینک جدید ما در حالت ریسپانسیو -->
            @can('viewApprovalQueue', App\Models\PurchaseRequest::class)
                <x-responsive-nav-link href="{{ route('approvals.index') }}" :active="request()->routeIs('approvals.index')">
                    {{ __('درخواست های در انتظار') }}
                </x-responsive-nav-link>
            @endcan




        </div>


        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-600">
            <div class="flex items-center px-4">
                @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                    <div class="shrink-0 me-3">
                        <img class="h-10 w-10 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                    </div>
                @endif

                <div>
                    <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ Auth::user()->first_name }} {{ Auth::user()->last_name }}</div>
                    <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
                </div>
            </div>

            <div class="mt-3 space-y-1">
                <!-- Account Management -->
                <x-responsive-nav-link href="{{ route('profile.show') }}" :active="request()->routeIs('profile.show')">
                    {{ __('پروفایل') }}
                </x-responsive-nav-link>

                @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                    <x-responsive-nav-link href="{{ route('api-tokens.index') }}" :active="request()->routeIs('api-tokens.index')">
                        {{ __('API Tokens') }}
                    </x-responsive-nav-link>
                @endif

                <!-- Authentication -->
                <form method="POST" action="{{ route('logout') }}" x-data>
                    @csrf

                    <x-responsive-nav-link href="{{ route('logout') }}" @click.prevent="$root.submit();">
                        {{ __('خروج') }}
                    </x-responsive-nav-link>
                </form>

{{--                <!-- Team Management -->--}}
{{--                @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())--}}
{{--                    <div class="border-t border-gray-200 dark:border-gray-600"></div>--}}

{{--                    <div class="block px-4 py-2 text-xs text-gray-400">--}}
{{--                        {{ __('مدیریت تیم') }}--}}
{{--                    </div>--}}

{{--                    <!-- Team Settings -->--}}
{{--                    <x-responsive-nav-link href="{{ route('teams.show', Auth::user()->currentTeam->id) }}" :active="request()->routeIs('teams.show')">--}}
{{--                        {{ __('تنظیمات تیم') }}--}}
{{--                    </x-responsive-nav-link>--}}

{{--                    @can('create', Laravel\Jetstream\Jetstream::newTeamModel())--}}
{{--                        <x-responsive-nav-link href="{{ route('teams.create') }}" :active="request()->routeIs('teams.create')">--}}
{{--                            {{ __('ایجاد تیم جدید') }}--}}
{{--                        </x-responsive-nav-link>--}}
{{--                    @endcan--}}

{{--                    <!-- Team Switcher -->--}}
{{--                    @if (Auth::user()->allTeams()->count() > 1)--}}
{{--                        <div class="border-t border-gray-200 dark:border-gray-600"></div>--}}

{{--                        <div class="block px-4 py-2 text-xs text-gray-400">--}}
{{--                            {{ __('تغییر تیم') }}--}}
{{--                        </div>--}}

{{--                        @foreach (Auth::user()->allTeams() as $team)--}}
{{--                            <x-switchable-team :team="$team" component="responsive-nav-link" />--}}
{{--                        @endforeach--}}
{{--                    @endif--}}
{{--                @endif--}}
            </div>
        </div>
    </div>
</nav>
