<header class="bg-white shadow-md p-4 flex items-center justify-between z-20 sticky top-0">
    <!-- Mobile Menu Button -->
    <button @click="sidebarOpen = !sidebarOpen" class="md:hidden text-gray-600 focus:outline-none">
        <x-lucide-menu class="w-6 h-6" />
    </button>

    <!-- Search Form -->
    <div class="relative hidden sm:block">
        @livewire('global-search')
    </div>

    <!-- Header Icons & Profile -->
    <div class="flex items-center space-x-reverse space-x-5">
        <!-- Notifications -->
        @livewire('notification-center')
        <!-- Profile Dropdown -->
        <div class="relative" x-data="{ open: false }">
            <button @click="open = !open" class="flex items-center space-x-2 focus:outline-none transition">
                {{-- [FIXED] Use the user's actual profile photo --}}
                <img class="h-10 w-10 rounded-full object-cover border-2 border-transparent hover:border-blue-500" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />

                <span class="hidden md:block font-semibold text-gray-700 dark:text-orange-300">
                    {{ Auth::user()->first_name }} {{ Auth::user()->last_name }}
                </span>

                <x-lucide-chevron-down class="w-4 h-4 text-gray-600 hidden md:block transition-transform" ::class="{'rotate-180': open}" />
            </button>

            <div x-cloak x-show="open" @click.away="open = false" x-transition
                 class="absolute left-0 mt-2 w-48 bg-white dark:bg-gray-800 rounded-md shadow-xl z-20 border dark:border-gray-700">

                <div class="px-4 py-3 text-sm text-gray-900 dark:text-white">
                    <div>{{ Auth::user()->name }}</div>
                    <div class="font-medium truncate">{{ Auth::user()->email }}</div>
                </div>

                <div class="border-t border-gray-200 dark:border-gray-600"></div>

                {{-- [FIXED] Link to the Jetstream profile page --}}
                <a href="{{ route('profile.show') }}" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-blue-500 hover:text-white">
                    پروفایل من
                </a>

                <div class="border-t border-gray-200 dark:border-gray-600"></div>

                <!-- [FIXED] Authentication -->
                <form method="POST" action="{{ route('logout') }}" x-data>
                    @csrf
                    <a href="{{ route('logout') }}"
                       @click.prevent="$root.submit();"
                       class="block w-full text-left px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-red-500 hover:text-white">
                        خروج
                    </a>
                </form>
            </div>
        </div>
    </div>
</header>
