<header class="flex justify-between items-center p-4 bg-white border-b shadow-md">
    <!-- Mobile Menu Button & Search -->
    <div class="flex items-center">
        <button @click="sidebarOpen = !sidebarOpen" class="text-gray-500 focus:outline-none lg:hidden">
            <i class="bi bi-list text-2xl"></i>
        </button>
        <!-- Search Form -->
        <div class="relative hidden md:block ml-4">
            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                <i class="bi bi-search text-gray-400"></i>
            </span>
            <input type="text" class="w-full py-2 pl-10 pr-4 border rounded-full focus:outline-none focus:ring-2 focus:ring-indigo-500" placeholder="جستجو...">
        </div>
    </div>

    <!-- Header Icons -->
    <div class="flex items-center space-x-reverse space-x-4">
        <!-- Notifications Dropdown -->
        <div x-data="{ dropdownOpen: false }" class="relative">
            <button @click="dropdownOpen = !dropdownOpen" class="relative text-gray-600 focus:outline-none">
                <i class="bi bi-bell-fill text-2xl"></i>
                <div class="absolute -top-1 -right-1 w-4 h-4 bg-red-500 text-white text-xs rounded-full flex items-center justify-center">3</div>
            </button>
            <div x-show="dropdownOpen" @click.away="dropdownOpen = false" class="absolute left-0 mt-2 w-80 bg-white rounded-lg shadow-xl overflow-hidden z-10" x-cloak>
                <div class="p-4 font-bold border-b">اعلانات</div>
                <a href="#" class="flex items-center px-4 py-3 hover:bg-gray-100 transition-colors duration-200">
                    <i class="bi bi-person-check-fill text-green-500 text-xl"></i>
                    <div class="mr-3">
                        <p class="text-sm font-medium text-gray-800">کاربر جدید ثبت‌نام کرد.</p>
                        <p class="text-xs text-gray-500">۵ دقیقه پیش</p>
                    </div>
                </a>
                <a href="#" class="flex items-center px-4 py-3 hover:bg-gray-100 transition-colors duration-200">
                    <i class="bi bi-chat-dots-fill text-blue-500 text-xl"></i>
                    <div class="mr-3">
                        <p class="text-sm font-medium text-gray-800">یک نظر جدید دریافت شد.</p>
                        <p class="text-xs text-gray-500">۱ ساعت پیش</p>
                    </div>
                </a>
                <a href="#" class="block bg-gray-50 text-center py-2 text-sm font-medium text-gray-700 hover:bg-gray-200">مشاهده همه</a>
            </div>
        </div>

        <!-- Profile Dropdown -->
        <div x-data="{ dropdownOpen: false }" class="relative">
            <button @click="dropdownOpen = !dropdownOpen" class="flex items-center focus:outline-none">
                <img class="w-10 h-10 rounded-full object-cover" src="https://placehold.co/100x100/E2E8F0/4A5568?text=User" alt="User avatar">
                <span class="hidden md:inline-block mr-2 font-semibold">نام کاربر</span>
            </button>
            <div x-show="dropdownOpen" @click.away="dropdownOpen = false" class="absolute left-0 mt-2 w-48 bg-white rounded-md shadow-xl z-10" x-cloak>
                <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-indigo-500 hover:text-white"><i class="bi bi-person-circle ml-2"></i>پروفایل</a>
                <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-indigo-500 hover:text-white"><i class="bi bi-gear ml-2"></i>تنظیمات</a>
                <hr>
                <form method="POST" action="{{ route('admin.logout') }}">
                    @csrf
                    <a href="{{ route('admin.logout') }}" onclick="event.preventDefault(); this.closest('form').submit();" class="text-body ms-0">
                        <i class="me-2 icon-md" data-feather="log-out"></i>
                        <span>خروج</span>
                    </a>
                </form>            </div>
        </div>
    </div>
</header>
