<aside
    @mouseenter="sidebarExpanded = true"
    @mouseleave="sidebarExpanded = false"
    class="fixed top-0 right-0 h-full bg-gradient-to-b from-blue-700 to-blue-900 text-gray-100 shadow-2xl z-40 transition-all duration-300 ease-in-out w-64 md:w-20 -translate-x-full md:translate-x-0"
    :class="{ 'translate-x-0': sidebarOpen, 'md:w-64': sidebarExpanded }">

    <div class="flex flex-col h-full">
        {{-- Header --}}

        <div class="flex items-center justify-center h-20 p-4 border-b border-blue-800">
            <img x-show="sidebarExpanded" x-transition:enter.duration.200ms
                 src="{{ asset('benchsynclogo.png') }}"
                 alt="BenchSync Full Logo"
                 class="h-9 w-auto">

            <img x-show="!sidebarExpanded" x-transition:enter.duration.200ms
                 src="{{ asset('benchsync-b.png') }}"
                 alt="BenchSync Icon Logo"
                 class="h-9 w-9">
        </div>

        <nav class="flex-1 px-2 py-6 space-y-2 custom-scrollbar overflow-y-auto">
            {{-- Dashboard --}}
            <a href="{{ route('dashboard') }}" class="flex items-center px-4 py-3 rounded-lg transition-colors duration-200 {{ request()->routeIs('dashboard') ? 'text-white bg-blue-800/50' : 'text-gray-200 hover:bg-blue-800 hover:text-white' }}" :class="sidebarExpanded ? '' : 'md:justify-center'">
                <x-lucide-layout-dashboard class="w-5 h-5 flex-shrink-0" />
                <span class="mr-4 font-semibold transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">داشبورد</span>
            </a>

            {{-- Projects Management --}}
            @can('viewAny', App\Models\Project::class)
                <a href="{{ route('projects.index') }}" class="flex items-center px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                    <x-lucide-notebook-tabs class="w-5 h-5 flex-shrink-0" />
                    <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">مدیریت طرح و برنامه</span>
                </a>
            @endcan

            {{-- Inventory Menu --}}
            @can('viewAny', App\Models\InventoryItem::class)
                <div x-data="{ open: {{ request()->routeIs('inventory.*') ? 'true' : 'false' }} }" class="space-y-1">
                    <a href="#" @click.prevent="open = !open" class="flex items-center justify-between px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                        <div class="flex items-center">
                            <x-lucide-archive class="w-5 h-5 flex-shrink-0" />
                            <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">مدیریت انبار</span>
                        </div>
                        <x-lucide-chevron-down class="w-4 h-4 transition-transform duration-200" ::class="{ 'rotate-180': open, 'md:hidden': !sidebarExpanded }" />
                    </a>
                    <ul x-show="open" x-transition class="space-y-1 mr-6" :class="{'md:hidden': !sidebarExpanded}">
                        <li><a href="{{ route('inventory.index') }}" class="block px-4 py-2 text-sm rounded-lg hover:bg-blue-800/60 {{ request()->routeIs('inventory.index') ? 'text-white bg-blue-800/60' : 'text-gray-300' }}">انبار اصلی</a></li>
                        <li><a href="{{ route('bio-inventory.index') }}" class="block px-4 py-2 text-sm rounded-lg hover:bg-blue-800/60 {{ request()->routeIs('inventory.index') ? 'text-white bg-blue-800/60' : 'text-gray-300' }}">مدیریت انبار بیولوژیک</a></li>
                        <li><a href="{{ route('inventory.locations.index') }}" class="block px-4 py-2 text-sm rounded-lg hover:bg-blue-800/60 {{ request()->routeIs('inventory.locations.index') ? 'text-white bg-blue-800/60' : 'text-gray-300' }}">مدیریت مکان‌ها</a></li>
                        <li><a href="{{ route('inventory.transfers.index') }}" class="block px-4 py-2 text-sm rounded-lg hover:bg-blue-800/60 {{ request()->routeIs('inventory.transfers.index') ? 'text-white bg-blue-800/60' : 'text-gray-300' }}">حواله انبار</a></li>
                        <li><a href="{{ route('inventory.reports') }}" class="block px-4 py-2 text-sm rounded-lg hover:bg-blue-800/60 {{ request()->routeIs('inventory.transfers.index') ? 'text-white bg-blue-800/60' : 'text-gray-300' }}">گزارش انبار</a></li>
                    </ul>
                </div>
            @endcan

            {{-- Equipment Management --}}
            @can('viewAny', App\Models\Equipment::class)
                <a href="{{ route('equipment.index') }}" class="flex items-center px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                    <x-lucide-thermometer-snowflake class="w-5 h-5 flex-shrink-0" />
                    <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">مدیریت تجهیزات</span>
                </a>
            @endcan

            {{-- Purchasing Menu --}}
            @can('viewAny', App\Models\PurchaseRequest::class)
                <a href="{{ route('purchase-requests.index') }}" class="flex items-center px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                    <x-lucide-shopping-cart class="w-5 h-5 flex-shrink-0" />
                    <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">بازرگانی (خرید)</span>
                </a>
            @endcan
            {{-- [NEW] Financials Link --}}
            @php
                // Manually instantiate and check the policy.
                $financialPolicy = new \App\Policies\FinancialPolicy();
            @endphp
            @if ($financialPolicy->viewAny(auth()->user()))
                <a href="{{ route('financials.index') }}" class="flex items-center px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                    <x-lucide-landmark class="w-5 h-5 flex-shrink-0" />
                    <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">امور مالی</span>
                </a>
            @endif

            {{-- Approvals Center Menu --}}
            @if(auth()->user()->can('viewApprovalQueue', App\Models\PurchaseRequest::class) || auth()->user()->can('view-transfer-approvals') || auth()->user()->can('view-warehouse-requests'))
                <div x-data="{ open: {{ request()->routeIs('approvals.*') || request()->routeIs('inventory.transfers.approvals') || request()->routeIs('warehouse.requests') ? 'true' : 'false' }} }" class="space-y-1">
                    <a href="#" @click.prevent="open = !open" class="flex items-center justify-between px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                        <div class="flex items-center">
                            <x-lucide-check-check class="w-5 h-5 flex-shrink-0" />
                            <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">تائید درخواست ها</span>
                        </div>
                        <x-lucide-chevron-down class="w-4 h-4 transition-transform duration-200" ::class="{ 'rotate-180': open, 'md:hidden': !sidebarExpanded }" />
                    </a>
                    <ul x-show="open" x-transition class="space-y-1 mr-6" :class="{'md:hidden': !sidebarExpanded}">
                        @can('viewApprovalQueue', App\Models\PurchaseRequest::class)
                            <li><a href="{{ route('approvals.index') }}" class="block px-4 py-2 text-sm rounded-lg hover:bg-blue-800/60 {{ request()->routeIs('approvals.index') ? 'text-white bg-blue-800/60' : 'text-gray-300' }}">تایید درخواست خرید</a></li>
                        @endcan
                        @can('warehouse-manage-requests')
                        <li><a href="{{ route('warehouse.requests') }}" class="block px-4 py-2 text-sm rounded-lg hover:bg-blue-800/60 {{ request()->routeIs('warehouse.requests') ? 'text-white bg-blue-800/60' : 'text-gray-300' }}">تایید گردش انبار</a></li>
                        @endcan
                        @can('warehouse-manage-requests') {{-- Note: Create this permission --}}
                        <li><a href="{{ route('inventory.transfers.approvals') }}" class="block px-4 py-2 text-sm rounded-lg hover:bg-blue-800/60 {{ request()->routeIs('inventory.transfers.approvals') ? 'text-white bg-blue-800/60' : 'text-gray-300' }}">تایید حواله انبار</a></li>
                        @endcan
                    </ul>
                </div>
            @endif

            {{-- Team Management --}}
            <a href="{{ route('research-teams.dashboard') }}" class="flex items-center px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                <x-lucide-users class="w-5 h-5 flex-shrink-0" />
                <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">مدیریت تیم</span>
            </a>
            {{-- Personal notebook --}}
            <a href="{{ route('personal-notebook.index') }}" class="flex items-center px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                <x-lucide-notebook-pen class="w-5 h-5 flex-shrink-0" />
                <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">دفترچه یادداشت شخصی</span>
            </a>
            {{-- Chat --}}
            <a href="{{ route('chat.index') }}" class="flex items-center px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                <x-lucide-message-square class="w-5 h-5 flex-shrink-0" />
                <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">چت</span>
            </a>

        </nav>

        {{-- Logout --}}
        <form method="POST" action="{{ route('logout') }}" x-data>
            @csrf
            <div class="p-2 border-t border-blue-800">
                <a href="{{ route('logout') }}" @click.prevent="$root.submit();" class="flex items-center px-4 py-3 text-gray-200 rounded-lg transition-colors duration-200 hover:bg-blue-800 hover:text-white" :class="sidebarExpanded ? '' : 'md:justify-center'">
                    <x-lucide-log-out class="w-5 h-5 flex-shrink-0" />
                    <span class="mr-4 transition-all duration-200" :class="{'md:hidden': !sidebarExpanded}">خروج</span>
                </a>
            </div>
        </form>
    </div>
</aside>
