<x-action-section>
    <x-slot name="title">
        <span class="text-lg font-bold text-gray-900">حذف حساب کاربری</span>
    </x-slot>

    <x-slot name="description">
        <span class="text-sm text-gray-600">حساب کاربری خود را برای همیشه حذف کنید.</span>
    </x-slot>

    <x-slot name="content">
        <div class="bg-white rounded-xl shadow-lg border-t-4 border-red-600 p-6 sm:p-8">
            <div class="max-w-xl text-sm text-gray-600">
                {{ __('پس از حذف حساب شما، تمام منابع و داده‌های آن برای همیشه پاک خواهند شد. قبل از حذف حساب، لطفاً هرگونه داده یا اطلاعاتی را که می‌خواهید حفظ کنید، دانلود نمایید.') }}
            </div>

            <div class="mt-5">
                <x-danger-button wire:click="confirmUserDeletion" wire:loading.attr="disabled">
                    {{ __('حذف حساب کاربری') }}
                </x-danger-button>
            </div>

            <!-- Delete User Confirmation Modal -->
            <x-dialog-modal wire:model.live="confirmingUserDeletion">
                <x-slot name="title">
                    {{ __('حذف حساب کاربری') }}
                </x-slot>

                <x-slot name="content">
                    {{ __('آیا مطمئن هستید که می‌خواهید حساب خود را حذف کنید؟ پس از حذف حساب، تمام منابع و داده‌های آن برای همیشه پاک خواهند شد. لطفاً برای تایید این عملیات، رمز عبور خود را وارد کنید.') }}

                    <div class="mt-4" x-data="{}" x-on:confirming-delete-user.window="setTimeout(() => $refs.password.focus(), 250)">
                        <x-input type="password" class="mt-1 block w-3/4"
                                 autocomplete="current-password"
                                 placeholder="{{ __('رمز عبور') }}"
                                 x-ref="password"
                                 wire:model="password"
                                 wire:keydown.enter="deleteUser" />

                        <x-input-error for="password" class="mt-2" />
                    </div>
                </x-slot>

                <x-slot name="footer">
                    <x-secondary-button wire:click="$toggle('confirmingUserDeletion')" wire:loading.attr="disabled">
                        {{ __('انصراف') }}
                    </x-secondary-button>

                    <x-danger-button class="ms-3" wire:click="deleteUser" wire:loading.attr="disabled">
                        {{ __('حذف حساب') }}
                    </x-danger-button>
                </x-slot>
            </x-dialog-modal>
        </div>
    </x-slot>
</x-action-section>
