<x-action-section>
    <x-slot name="title">
        <span class="text-lg font-bold text-gray-900">نشست‌های مرورگر</span>
    </x-slot>

    <x-slot name="description">
        <span class="text-sm text-gray-600">نشست‌های فعال خود در سایر مرورگرها و دستگاه‌ها را مدیریت و از آن‌ها خارج شوید.</span>
    </x-slot>

    <x-slot name="content">
        <div class="bg-white rounded-xl shadow-lg border-t-4 border-blue-600 p-6 sm:p-8">
            <div class="max-w-xl text-sm text-gray-600">
                {{ __('در صورت لزوم، می‌توانید از تمام نشست‌های دیگر مرورگر خود در همه دستگاه‌هایتان خارج شوید. برخی از نشست‌های اخیر شما در زیر لیست شده‌اند؛ با این حال، این لیست ممکن است کامل نباشد. اگر احساس می‌کنید حساب شما در معرض خطر قرار گرفته است، باید رمز عبور خود را نیز به‌روزرسانی کنید.') }}
            </div>

            @if (count($this->sessions) > 0)
                <div class="mt-5 space-y-6">
                    <!-- Other Browser Sessions -->
                    @foreach ($this->sessions as $session)
                        <div class="flex items-center">
                            <div>
                                @if ($session->agent->isDesktop())
                                    <x-lucide-monitor class="w-8 h-8 text-gray-500"/>
                                @else
                                    <x-lucide-smartphone class="w-8 h-8 text-gray-500"/>
                                @endif
                            </div>

                            <div class="ms-3">
                                <div class="text-sm text-gray-600">
                                    {{ $session->agent->platform() ? $session->agent->platform() : __('ناشناخته') }} - {{ $session->agent->browser() ? $session->agent->browser() : __('ناشناخته') }}
                                </div>

                                <div>
                                    <div class="text-xs text-gray-500">
                                        {{ $session->ip_address }},

                                        @if ($session->is_current_device)
                                            <span class="text-green-500 font-semibold">{{ __('این دستگاه') }}</span>
                                        @else
                                            {{ __('آخرین فعالیت') }} {{ $session->last_active }}
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif

            <div class="flex items-center mt-5">
                <x-button wire:click="confirmLogout" wire:loading.attr="disabled">
                    {{ __('خروج از سایر نشست‌های مرورگر') }}
                </x-button>

                <x-action-message class="ms-3" on="loggedOut">
                    {{ __('انجام شد.') }}
                </x-action-message>
            </div>

            <!-- Log Out Other Devices Confirmation Modal -->
            <x-dialog-modal wire:model.live="confirmingLogout">
                <x-slot name="title">
                    {{ __('خروج از سایر نشست‌های مرورگر') }}
                </x-slot>

                <x-slot name="content">
                    {{ __('لطفاً برای تایید خروج از سایر نشست‌های مرورگر در تمام دستگاه‌های خود، رمز عبور خود را وارد کنید.') }}

                    <div class="mt-4" x-data="{}" x-on:confirming-logout-other-browser-sessions.window="setTimeout(() => $refs.password.focus(), 250)">
                        <x-input type="password" class="mt-1 block w-3/4"
                                 autocomplete="current-password"
                                 placeholder="{{ __('رمز عبور') }}"
                                 x-ref="password"
                                 wire:model="password"
                                 wire:keydown.enter="logoutOtherBrowserSessions" />

                        <x-input-error for="password" class="mt-2" />
                    </div>
                </x-slot>

                <x-slot name="footer">
                    <x-secondary-button wire:click="$toggle('confirmingLogout')" wire:loading.attr="disabled">
                        {{ __('انصراف') }}
                    </x-secondary-button>

                    <x-button class="ms-3"
                              wire:click="logoutOtherBrowserSessions"
                              wire:loading.attr="disabled">
                        {{ __('خروج از سایر نشست‌ها') }}
                    </x-button>
                </x-slot>
            </x-dialog-modal>
        </div>
    </x-slot>
</x-action-section>
