<x-action-section>
    <x-slot name="title">
        <span class="text-lg font-bold text-gray-900">احراز هویت دو عاملی</span>
    </x-slot>

    <x-slot name="description">
        <span class="text-sm text-gray-600">با استفاده از احراز هویت دو عاملی، امنیت بیشتری به حساب کاربری خود اضافه کنید.</span>
    </x-slot>

    <x-slot name="content">
        <div class="bg-white rounded-xl shadow-lg border-t-4 border-blue-600 p-6 sm:p-8">
            <h3 class="text-lg font-medium text-gray-900">
                @if ($this->enabled)
                    @if ($showingConfirmation)
                        {{ __('در حال تکمیل فعال‌سازی احراز هویت دو عاملی.') }}
                    @else
                        {{ __('شما احراز هویت دو عاملی را فعال کرده‌اید.') }}
                    @endif
                @else
                    {{ __('شما احراز هویت دو عاملی را فعال نکرده‌اید.') }}
                @endif
            </h3>

            <div class="mt-3 max-w-xl text-sm text-gray-600">
                <p>
                    {{ __('هنگامی که احراز هویت دو عاملی فعال باشد، در زمان ورود به سیستم از شما یک توکن امن و تصادفی خواسته می‌شود. شما می‌توانید این توکن را از اپلیکیشن Google Authenticator تلفن همراه خود دریافت کنید.') }}
                </p>
            </div>

            @if ($this->enabled)
                @if ($showingQrCode)
                    <div class="mt-4 max-w-xl text-sm text-gray-600">
                        <p class="font-semibold">
                            @if ($showingConfirmation)
                                {{ __('برای تکمیل فعال‌سازی، کد QR زیر را با اپلیکیشن احراز هویت خود اسکن کرده یا کلید را به صورت دستی وارد و کد تولید شده را ثبت کنید.') }}
                            @else
                                {{ __('احراز هویت دو عاملی اکنون فعال است. کد QR زیر را با اپلیکیشن احراز هویت خود اسکن کنید یا کلید را به صورت دستی وارد نمایید.') }}
                            @endif
                        </p>
                    </div>

                    <div class="mt-4 p-2 inline-block bg-white">
                        {!! $this->user->twoFactorQrCodeSvg() !!}
                    </div>

                    <div class="mt-4 max-w-xl text-sm text-gray-600">
                        <p class="font-semibold">
                            {{ __('کلید راه‌اندازی') }}: {{ decrypt($this->user->two_factor_secret) }}
                        </p>
                    </div>

                    @if ($showingConfirmation)
                        <div class="mt-4">
                            <x-label for="code" value="{{ __('کد تایید') }}" />
                            <x-input id="code" type="text" name="code" class="block mt-1 w-1/2" inputmode="numeric" autofocus autocomplete="one-time-code"
                                     wire:model="code"
                                     wire:keydown.enter="confirmTwoFactorAuthentication" />
                            <x-input-error for="code" class="mt-2" />
                        </div>
                    @endif
                @endif

                @if ($showingRecoveryCodes)
                    <div class="mt-4 max-w-xl text-sm text-gray-600">
                        <p class="font-semibold">
                            {{ __('این کدهای بازیابی را در یک مکان امن ذخیره کنید. در صورت گم شدن دستگاه احراز هویت، می‌توانید از آن‌ها برای بازیابی دسترسی به حساب خود استفاده کنید.') }}
                        </p>
                    </div>

                    <div class="grid gap-1 max-w-xl mt-4 px-4 py-4 font-mono text-sm bg-gray-100 rounded-lg">
                        @foreach (json_decode(decrypt($this->user->two_factor_recovery_codes), true) as $code)
                            <div>{{ $code }}</div>
                        @endforeach
                    </div>
                @endif
            @endif

            <div class="mt-5">
                @if (! $this->enabled)
                    <x-confirms-password wire:then="enableTwoFactorAuthentication">
                        <x-button type="button" wire:loading.attr="disabled">
                            {{ __('فعال‌سازی') }}
                        </x-button>
                    </x-confirms-password>
                @else
                    @if ($showingRecoveryCodes)
                        <x-confirms-password wire:then="regenerateRecoveryCodes">
                            <x-secondary-button class="me-3">
                                {{ __('تولید مجدد کدهای بازیابی') }}
                            </x-secondary-button>
                        </x-confirms-password>
                    @elseif ($showingConfirmation)
                        <x-confirms-password wire:then="confirmTwoFactorAuthentication">
                            <x-button type="button" class="me-3" wire:loading.attr="disabled">
                                {{ __('تایید') }}
                            </x-button>
                        </x-confirms-password>
                    @else
                        <x-confirms-password wire:then="showRecoveryCodes">
                            <x-secondary-button class="me-3">
                                {{ __('نمایش کدهای بازیابی') }}
                            </x-secondary-button>
                        </x-confirms-password>
                    @endif

                    @if ($showingConfirmation)
                        <x-confirms-password wire:then="disableTwoFactorAuthentication">
                            <x-secondary-button wire:loading.attr="disabled">
                                {{ __('انصراف') }}
                            </x-secondary-button>
                        </x-confirms-password>
                    @else
                        <x-confirms-password wire:then="disableTwoFactorAuthentication">
                            <x-danger-button wire:loading.attr="disabled">
                                {{ __('غیرفعال‌سازی') }}
                            </x-danger-button>
                        </x-confirms-password>
                    @endif
                @endif
            </div>
        </div>
    </x-slot>
</x-action-section>
