<x-form-section submit="updatePassword">
    <x-slot name="title">
        <span class="text-lg font-bold text-gray-900">تغییر رمز عبور</span>
    </x-slot>

    <x-slot name="description">
        <span class="text-sm text-gray-600">اطمینان حاصل کنید که حساب شما از یک رمز عبور طولانی و تصادفی برای حفظ امنیت استفاده می‌کند.</span>
    </x-slot>

    <x-slot name="form">

                <div class="col-span-6 sm:col-span-4">
                    <x-label for="current_password" value="{{ __('رمز عبور فعلی') }}" />
                    <x-input id="current_password" type="password" class="mt-1 block w-full" wire:model="state.current_password" autocomplete="current-password" />
                    <x-input-error for="state.current_password" class="mt-2" />
                </div>

                <div class="col-span-6 sm:col-span-4">
                    <x-label for="password" value="{{ __('رمز عبور جدید') }}" />
                    <x-input id="password" type="password" class="mt-1 block w-full" wire:model="state.password" autocomplete="new-password" />
                    <x-input-error for="state.password" class="mt-2" />
                </div>

                <div class="col-span-6 sm:col-span-4">
                    <x-label for="password_confirmation" value="{{ __('تایید رمز عبور جدید') }}" />
                    <x-input id="password_confirmation" type="password" class="mt-1 block w-full" wire:model="state.password_confirmation" autocomplete="new-password" />
                    <x-input-error for="state.password_confirmation" class="mt-2" />
                </div>
    </x-slot>

    <x-slot name="actions">
        <div class="flex items-center justify-end px-4 py-3 bg-gray-50 text-end sm:px-6 shadow sm:rounded-bl-md sm:rounded-br-md">
            <x-action-message class="me-3" on="saved">
                {{ __('ذخیره شد.') }}
            </x-action-message>

            <x-button>
                {{ __('ذخیره') }}
            </x-button>
        </div>
    </x-slot>
</x-form-section>
