<x-form-section submit="updateProfileInformation">
    <x-slot name="title">
        <span class="text-lg font-bold text-gray-900">اطلاعات پروفایل</span>
    </x-slot>

    <x-slot name="description">
        <span class="text-sm text-gray-600">اطلاعات پروفایل و آدرس ایمیل حساب کاربری خود را به‌روزرسانی کنید.</span>
    </x-slot>

    <x-slot name="form">
                <!-- Profile Photo -->
                @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                    <div x-data="{photoName: null, photoPreview: null}" class="col-span-6 sm:col-span-6">
                        <!-- Profile Photo File Input -->
                        <input type="file" id="photo" class="hidden"
                               wire:model.live="photo"
                               x-ref="photo"
                               x-on:change="
                                            photoName = $refs.photo.files[0].name;
                                            const reader = new FileReader();
                                            reader.onload = (e) => {
                                                photoPreview = e.target.result;
                                            };
                                            reader.readAsDataURL($refs.photo.files[0]);
                                    " />

                        <x-label for="photo" value="{{ __('عکس پروفایل') }}" />

                        <!-- Current Profile Photo -->
                        <div class="mt-2" x-show="! photoPreview">
                            <img src="{{ $this->user->profile_photo_url }}" alt="{{ $this->user->name }}" class="rounded-full h-20 w-20 object-cover">
                        </div>

                        <!-- New Profile Photo Preview -->
                        <div class="mt-2" x-show="photoPreview" style="display: none;">
                            <span class="block rounded-full w-20 h-20 bg-cover bg-no-repeat bg-center"
                                  x-bind:style="'background-image: url(\'' + photoPreview + '\');'">
                            </span>
                        </div>

                        <x-secondary-button class="mt-2 me-2" type="button" x-on:click.prevent="$refs.photo.click()">
                            {{ __('انتخاب عکس جدید') }}
                        </x-secondary-button>

                        @if ($this->user->profile_photo_path)
                            <x-secondary-button type="button" class="mt-2" wire:click="deleteProfilePhoto">
                                {{ __('حذف عکس') }}
                            </x-secondary-button>
                        @endif

                        <x-input-error for="photo" class="mt-2" />
                    </div>
                @endif

                <!-- Name -->
                <div>
                    <x-label for="first_name" value="{{ __('نام') }}" />
                    <x-input id="first_name" type="text" class="mt-1 block w-full" wire:model="state.first_name" required autocomplete="name" />
                    <x-input-error for="state.first_name" class="mt-2" />
                </div>

                <div class="col-span-6 sm:col-span-3">
                    <x-label for="last_name" value="{{ __('نام خانوادگی') }}" />
                    <x-input id="last_name" type="text" class="mt-1 block w-full" wire:model="state.last_name" required autocomplete="family-name" />
                    <x-input-error for="state.last_name" class="mt-2" />
                </div>

                <!-- Email -->
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="email" value="{{ __('ایمیل') }}" />
                    <x-input id="email" type="email" class="mt-1 block w-full" wire:model="state.email" required autocomplete="username" />
                    <x-input-error for="state.email" class="mt-2" />

                    @if (Laravel\Fortify\Features::enabled(Laravel\Fortify\Features::emailVerification()) && ! $this->user->hasVerifiedEmail())
                        <p class="text-sm mt-2 text-gray-800">
                            {{ __('آدرس ایمیل شما تایید نشده است.') }}

                            <button type="button" class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" wire:click.prevent="sendEmailVerification">
                                {{ __('برای ارسال مجدد ایمیل تایید کلیک کنید.') }}
                            </button>
                        </p>

                        @if ($this->verificationLinkSent)
                            <p class="mt-2 font-medium text-sm text-green-600">
                                {{ __('یک لینک تایید جدید به آدرس ایمیل شما ارسال شد.') }}
                            </p>
                        @endif
                    @endif
                </div>

    </x-slot>

    <x-slot name="actions">
        <div class="flex items-center justify-end px-4 py-3 bg-gray-50 text-end sm:px-6 shadow sm:rounded-bl-md sm:rounded-br-md">
            <x-action-message class="me-3" on="saved">
                {{ __('ذخیره شد.') }}
            </x-action-message>

            <x-button wire:loading.attr="disabled" wire:target="photo">
                {{ __('ذخیره') }}
            </x-button>
        </div>
    </x-slot>
</x-form-section>
