<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>اطلاعات تجهیز: {{ $equipment->name }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            .no-print { display: none !important; }
        }
    </style>
</head>
<body class="bg-gray-100">

<div class="max-w-2xl mx-auto p-4 sm:p-8">
    <!-- دکمه چاپ -->
    <div class="no-print text-center mb-6">
        <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            چاپ سوابق
        </button>
    </div>

    <!-- اطلاعات اصلی تجهیز -->
    <div class="bg-white shadow-lg rounded-lg p-6">
        <header class="text-center border-b pb-4">
            <h1 class="text-2xl font-bold text-gray-800">{{ $equipment->name }}</h1>
            <p class="text-sm text-gray-500 font-mono mt-1">{{ $equipment->system_sku }}</p>
        </header>
        <div class="mt-6 grid grid-cols-2 gap-4 text-sm">
            <div><strong class="text-gray-600">مدل:</strong> {{ $equipment->model ?? '-' }}</div>
            <div><strong class="text-gray-600">شماره سریال:</strong> {{ $equipment->serial_number ?? '-' }}</div>
            <div><strong class="text-gray-600">تیم تحقیقاتی:</strong> {{ $equipment->researchTeam?->name ?? 'مستقل' }}</div>
            <div><strong class="text-gray-600">کاربر مسئول:</strong> {{ $equipment->responsibleUser?->name ?? '-' }}</div>
            <div class="col-span-2"><strong class="text-gray-600">کالیبراسیون بعدی:</strong> <span class="font-bold text-red-600">{{ $equipment->next_calibration_date ? verta($equipment->next_calibration_date)->format('Y/m/d') : 'تعیین نشده' }}</span></div>
        </div>
    </div>

    <!-- تاریخچه کالیبراسیون -->
    <div class="mt-8">
        <h2 class="text-xl font-semibold text-gray-700 mb-4">تاریخچه کالیبراسیون</h2>
        <div class="space-y-6">
            @forelse($equipment->calibrationLogs as $log)
                <div class="bg-white shadow-lg rounded-lg p-5">
                    <div class="flex justify-between items-center">
                        <p class="font-bold text-gray-800">کالیبراسیون در تاریخ {{ verta($log->calibration_date)->format('Y/m/d') }}</p>
                        <span class="text-xs text-gray-500">ثبت توسط: {{ $log->user->name }}</span>
                    </div>
                    @if($log->notes)
                        <p class="mt-3 text-sm text-gray-600">{{ $log->notes }}</p>
                    @endif
                    @if($log->attachments->isNotEmpty())
                        <div class="mt-3 border-t pt-3">
                            <h4 class="text-xs font-semibold text-gray-500 mb-2">پیوست‌ها:</h4>
                            <div class="flex flex-wrap gap-2">
                                @foreach($log->attachments as $attachment)
                                    <a href="{{ Storage::url($attachment->file_path) }}" target="_blank" class="text-xs text-blue-600 hover:underline">
                                        {{ $attachment->file_name }}
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            @empty
                <div class="bg-white shadow-lg rounded-lg p-6 text-center text-gray-500">
                    هیچ سابقه‌ی کالیبراسیونی برای این تجهیز ثبت نشده است.
                </div>
            @endforelse
        </div>
    </div>
</div>

</body>
</html>
