<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش عملکرد: {{ $collaborator->name }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="{{ asset('css/print.css') }}" media="print">
</head>
<body class="bg-gray-100">

<!-- دکمه‌های کنترل -->
<div class="no-print bg-gray-800 p-4 text-white flex justify-between items-center sticky top-0 z-50">
    <span>گزارش عملکرد برای: {{ $collaborator->name }} در طرح {{ $project->title }}</span>
    <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
        چاپ / ذخیره PDF
    </button>
</div>

<!-- محتوای گزارش -->
<div class="max-w-4xl mx-auto p-8 bg-white shadow-lg my-8">
    <!-- سربرگ گزارش -->
    <header class="border-b-2 border-gray-800 pb-4 mb-8 text-center">
        <h1 class="text-3xl font-bold text-gray-900">گزارش عملکرد</h1>
        <p class="text-lg text-gray-700 mt-2">همکار: <span class="font-semibold">{{ $collaborator->name }}</span></p>
        <p class="text-md text-gray-600">در طرح: <span class="font-semibold">{{ $project->title }}</span></p>
    </header>

    <!-- بخش ۱: نمودار عملکرد -->
    <section>
        <h2 class="text-xl font-semibold text-gray-800 border-b pb-2 mb-4">۱. نمودار وضعیت وظایف (ماهانه)</h2>
        <div class="h-80">
            <canvas id="collaboratorReportChart"></canvas>
        </div>
    </section>

    <!-- بخش ۲: لیست کامل وظایف -->
    <section class="print-break-before mt-8">
        <h2 class="text-xl font-semibold text-gray-800 border-b pb-2 mb-4">۲. لیست وظایف محول شده</h2>
        <table class="min-w-full border text-sm">
            <thead class="bg-gray-100">
            <tr>
                <th class="border p-2 text-right">عنوان وظیفه</th>
                <th class="border p-2 text-right">اولویت</th>
                <th class="border p-2 text-right">تاریخ پایان</th>
                <th class="border p-2 text-right">وضعیت</th>
            </tr>
            </thead>
            <tbody>
            @forelse($tasks as $task)
                <tr class="border-b print-break-inside-avoid">
                    <td class="p-2">{{ $task->title }}</td>
                    <td class="p-2">{{ $task->priority }}</td>
                    <td class="p-2">{{ $task->due_date ? verta($task->due_date)->format('Y/m/d') : '-' }}</td>
                    <td class="p-2">{{ $task->status }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="p-4 text-center text-gray-500">هیچ وظیفه‌ای به این کاربر در این طرح محول نشده است.</td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const chartData = @json($chartData);
    const ctx = document.getElementById('collaboratorReportChart');

    if (ctx && chartData && chartData.labels) {
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: chartData.labels,
                datasets: chartData.datasets
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    tooltip: { mode: 'index', intersect: false },
                    legend: { position: 'bottom' }
                },
                scales: {
                    x: { stacked: true },
                    y: { stacked: true, beginAtZero: true, ticks: { stepSize: 1 } }
                }
            }
        });
    }
</script>
</body>
</html>
