 <!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش طرح: {{ $project->title }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    {{-- فقط یک فایل CSS جدید و یکپارچه --}}
    <link rel="stylesheet" href="{{ asset('css/print.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>
<body class="bg-gray-200">

{{-- دکمه‌های کنترل (در چاپ نمایش داده نمی‌شوند) --}}
<div class="control-panel no-print sticky top-0 bg-gray-800 p-3 shadow-lg z-50 flex justify-between items-center">
    <div class="text-white font-bold">
        <i class="fa fa-file-alt ml-2"></i>
        <span>گزارش طرح: {{ $project->title }}</span>
    </div>
    <button onclick="window.print()" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition-all duration-300">
        <i class="fa fa-print ml-2"></i>
        چاپ / ذخیره PDF
    </button>
</div>

{{-- این جدول ساختار اصلی برای چاپ را فراهم می‌کند --}}
<table class="print-wrapper">
    {{-- سربرگ که در تمام صفحات چاپ تکرار می‌شود --}}
    <thead class="print-header">
    <tr>
        <td>
            <div class="header-content">
                <span class="font-bold">گزارش جامع طرح</span>
                <span>{{ $project->title }}</span>
            </div>
        </td>
    </tr>
    </thead>

    {{-- پاورقی که در تمام صفحات چاپ تکرار می‌شود --}}
    <tfoot class="print-footer">
    <tr>
        <td>
            <div class="footer-content">
                <span>تهیه شده در تاریخ: {{ verta()->format('Y/m/d') }}</span>
                <span class="page-number"></span>
            </div>
        </td>
    </tr>
    </tfoot>

    {{-- محتوای اصلی گزارش --}}
    <tbody>
    <tr>
        <td>
            <div class="report-main-content">
                <!-- سربرگ اصلی گزارش (فقط صفحه اول) -->
                <header class="report-header">
                    <h1 class="text-4xl font-bold">{{ $project->title }}</h1>
                    <p class="text-lg text-gray-700 mt-2">گزارش جامع و تحلیل وضعیت</p>
                </header>

                <main class="p-8">
                    <!-- بخش ۱: اطلاعات کلی طرح -->
                    <section class="report-section">
                        <h2 class="section-title"><i class="fa fa-info-circle ml-3"></i>۱. اطلاعات کلی طرح</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-6 mt-4">
                            <div class="info-item"><strong>کد شناسایی:</strong> <span class="font-mono">{{ $project->sku }}</span></div>
                            <div class="info-item"><strong>وضعیت:</strong> <span class="status-badge status-{{ strtolower(str_replace(' ', '-', $project->status)) }}">{{ $project->status }}</span></div>
                            <div class="info-item"><strong>مالک طرح:</strong> <span>{{ $project->owner->name }}</span></div>
                            <div class="info-item"><strong>نهاد تحقیقاتی:</strong> <span>{{ $project->researchTeam->name }}</span></div>
                            <div class="info-item"><strong>تاریخ شروع:</strong> <span>{{ verta($project->start_date)->format('j F Y') }}</span></div>
                            <div class="info-item"><strong>تاریخ پایان:</strong> <span>{{ $project->due_date ? verta($project->due_date)->format('j F Y') : '-' }}</span></div>
                        </div>
                        <div class="mt-6 info-item-full">
                            <strong>شرح طرح:</strong>
                            <p class="mt-2 text-gray-700 leading-relaxed text-justify">{{ $project->description }}</p>
                        </div>
                    </section>

                    <!-- سایر بخش‌ها بدون تغییر باقی می‌مانند -->
                    <!-- بخش ۲: خلاصه وضعیت وظایف -->
                    <section class="report-section page-break-before">
                        <h2 class="section-title"><i class="fa fa-chart-pie ml-3"></i>۲. خلاصه وضعیت وظایف</h2>
                        @if($tasks->isNotEmpty())
                            <div class="grid grid-cols-1 lg:grid-cols-5 gap-8 items-center mt-6">
                                <div class="lg:col-span-2 h-64">
                                    <canvas id="tasksPieChart"></canvas>
                                </div>
                                <div class="lg:col-span-3">
                                    <h3 class="font-bold text-lg mb-3 text-gray-700">وظایف نیازمند توجه (عقب افتاده)</h3>
                                    <ul class="list-none space-y-2">
                                        @forelse($overdueTasks as $task)
                                            <li class="overdue-task-item"><i class="fa fa-exclamation-triangle text-red-500 ml-2"></i>{{ $task->title }}</li>
                                        @empty
                                            <li class="text-green-600 p-3 bg-green-50 rounded-lg"><i class="fa fa-check-circle ml-2"></i>هیچ وظیفه عقب افتاده‌ای وجود ندارد.</li>
                                        @endforelse
                                    </ul>
                                </div>
                            </div>
                        @else
                            <p class="no-data-message">هیچ وظیفه‌ای برای این طرح تعریف نشده است.</p>
                        @endif
                    </section>

                    <!-- بخش ۳: لیست کامل وظایف -->
                    <section class="report-section page-break-before">
                        <h2 class="section-title"><i class="fa fa-tasks ml-3"></i>۳. لیست کامل وظایف</h2>
                        <div class="overflow-x-auto mt-4">
                            <table class="custom-table">
                                <thead>
                                <tr>
                                    <th>عنوان وظیفه</th>
                                    <th>مسئولین</th>
                                    <th>اولویت</th>
                                    <th>تاریخ پایان</th>
                                    <th>وضعیت</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($tasks as $task)
                                    <tr class="page-break-inside-avoid">
                                        <td>{{ $task->title }}</td>
                                        <td>{{ $task->assignees->pluck('name')->join(', ') }}</td>
                                        <td><span class="priority-badge priority-{{ strtolower($task->priority) }}">{{ $task->priority }}</span></td>
                                        <td class="font-mono">{{ $task->due_date ? verta($task->due_date)->format('Y/m/d') : '-' }}</td>
                                        <td>{{ $task->status }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center p-6">هیچ وظیفه‌ای یافت نشد.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </section>

                    <!-- بخش ۴: اعضای تیم پروژه -->
                    <section class="report-section page-break-before">
                        <h2 class="section-title"><i class="fa fa-users ml-3"></i>۴. اعضای تیم پروژه</h2>
                        <div class="overflow-x-auto mt-4">
                            <table class="custom-table">
                                <thead>
                                <tr>
                                    <th>نام همکار</th>
                                    <th>نقش در پروژه</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="page-break-inside-avoid">
                                    <td>{{ $project->owner->name }}</td>
                                    <td><i class="fa fa-crown ml-2 text-yellow-500"></i>مالک طرح</td>
                                </tr>
                                @forelse($project->collaborators as $collaborator)
                                    <tr class="page-break-inside-avoid">
                                        <td>{{ $collaborator->name }}</td>
                                        <td>{{ $collaborator->pivot->project_role }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="2" class="text-center p-6">هیچ همکاری به این طرح اضافه نشده است.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </section>

                    <!-- بخش ۵: بودجه و مصارف مواد -->
                    <section class="report-section page-break-before">
                        <h2 class="section-title"><i class="fa fa-coins ml-3"></i>۵. بودجه و مصارف مواد</h2>
                        <div class="overflow-x-auto mt-4">
                            <table class="custom-table">
                                <thead>
                                <tr>
                                    <th>نام ماده</th>
                                    <th>سقف مجاز</th>
                                    <th>مصرف شده</th>
                                    <th>باقیمانده</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($project->budgetItems as $item)
                                    <tr class="page-break-inside-avoid">
                                        <td>{{ $item->name }}</td>
                                        <td>{{ number_format($item->pivot->max_allowed_quantity) }} {{ $item->unit }}</td>
                                        <td>{{ number_format($item->pivot->total_consumed_quantity) }} {{ $item->unit }}</td>
                                        <td class="font-bold">{{ number_format($item->pivot->max_allowed_quantity - $item->pivot->total_consumed_quantity) }} {{ $item->unit }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center p-6">هیچ بودجه‌ای برای مواد این طرح تعریف نشده است.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </section>

                    <!-- بخش ۶: دفترچه یادداشت آزمایشگاه (ELN) -->
                    <section class="report-section page-break-before">
                        <h2 class="section-title"><i class="fa fa-book-open ml-3"></i>۶. دفترچه یادداشت آزمایشگاه (ELN)</h2>
                        @forelse($project->labNotebookEntries as $entry)
                            <div class="eln-entry page-break-inside-avoid">
                                <div class="eln-header">
                                    <h3 class="text-lg font-bold text-gray-800">{{ $entry->title }}</h3>
                                    <div class="text-xs text-gray-500 flex justify-between mt-1">
                                        <span><i class="fa fa-user ml-1"></i>{{ $entry->user->name }}</span>
                                        <span><i class="fa fa-calendar-alt ml-1"></i>{{ verta($entry->entry_date)->format('Y/m/d') }}</span>
                                    </div>
                                </div>
                                <div class="eln-body prose prose-sm max-w-none text-gray-800 leading-relaxed">
                                    {!! $entry->body !!}
                                </div>
                                @if($entry->materials->isNotEmpty())
                                    <div class="eln-materials">
                                        <h4 class="font-semibold text-sm mb-2">مواد مصرفی:</h4>
                                        <table class="mini-table">
                                            <thead>
                                            <tr><th>نام ماده</th><th>مقدار مصرفی</th></tr>
                                            </thead>
                                            <tbody>
                                            @foreach($entry->materials as $material)
                                                <tr>
                                                    <td>{{ $material->name }}</td>
                                                    <td>{{ $material->pivot->quantity_used }} {{ $material->unit }}</td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @endif
                                <div class="eln-signature">
                                    @if($entry->is_locked)
                                        <p class="signature-status signed">
                                            <i class="fa fa-lock ml-2"></i>
                                            امضا و قفل شده در {{ verta($entry->locked_at)->format('Y/m/d') }} توسط {{ $entry->locker->name ?? 'کاربر حذف شده' }}
                                        </p>
                                    @else
                                        <p class="signature-status unsigned">
                                            <i class="fa fa-unlock-alt ml-2"></i>
                                            این یادداشت هنوز امضا و قفل نشده است.
                                        </p>
                                    @endif
                                </div>
                            </div>
                        @empty
                            <p class="no-data-message">هیچ یادداشتی برای این طرح ثبت نشده است.</p>
                        @endforelse
                    </section>
                </main>
            </div>
        </td>
    </tr>
    </tbody>
</table>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const chartData = @json($chartData);
        const ctx = document.getElementById('tasksPieChart');

        if (ctx && chartData && chartData.labels && chartData.labels.length > 0) {
            new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: chartData.labels,
                    datasets: [{
                        label: 'وضعیت وظایف',
                        data: chartData.data,
                        backgroundColor: ['#22c55e', '#f59e0b', '#3b82f6', '#ef4444', '#8b5cf6'],
                        borderColor: '#fff',
                        borderWidth: 3,
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                font: { family: 'IransansFont', size: 12 },
                                padding: 15
                            }
                        }
                    },
                    cutout: '60%'
                }
            });
        }
    });
</script>
</body>
</html>

