{{--<!DOCTYPE html>--}}
{{--<html lang="fa" dir="rtl">--}}
{{--<head>--}}
{{--    <meta charset="UTF-8">--}}
{{--    <meta name="viewport" content="width=device-width, initial-scale=1.0">--}}
{{--    <title>گزارش دمای تجهیز: {{ $equipment->name }}</title>--}}
{{--    <script src="https://cdn.tailwindcss.com"></script>--}}
{{--    <link rel="stylesheet" href="{{ asset('css/print.css') }}">--}}
{{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">--}}
{{--    --}}{{-- Jalali Date Picker Assets --}}
{{--    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css"/>--}}
{{--</head>--}}
{{--<body class="bg-gray-200">--}}

{{-- Control Panel --}}
{{--<div class="control-panel no-print sticky top-0 bg-gray-800 p-3 shadow-lg z-50 flex justify-between items-center">--}}
{{--    <div class="text-white font-bold">--}}
{{--        <i class="fa fa-thermometer-half ml-2"></i>--}}
{{--        <span>گزارش دما: {{ $equipment->name }}</span>--}}
{{--    </div>--}}
{{--    <button onclick="window.print()" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg">--}}
{{--        <i class="fa fa-print ml-2"></i>--}}
{{--        چاپ / ذخیره PDF--}}
{{--    </button>--}}
{{--</div>--}}

{{--<table class="print-wrapper">--}}
{{--    <thead class="print-header">--}}
{{--    <tr>--}}
{{--        <td>--}}
{{--            <div class="header-content">--}}
{{--                <span class="font-bold">گزارش جامع دمای تجهیزات</span>--}}
{{--                <span>{{ $equipment->name }}</span>--}}
{{--            </div>--}}
{{--        </td>--}}
{{--    </tr>--}}
{{--    </thead>--}}
{{--    <tfoot class="print-footer">--}}
{{--    <tr>--}}
{{--        <td>--}}
{{--            <div class="footer-content">--}}
{{--                <span>تهیه شده در تاریخ: {{ verta()->format('Y/m/d') }}</span>--}}
{{--                <span class="page-number"></span>--}}
{{--            </div>--}}
{{--        </td>--}}
{{--    </tr>--}}
{{--    </tfoot>--}}
{{--    <tbody>--}}
{{--    <tr>--}}
{{--        <td>--}}
{{--            <div class="report-main-content">--}}
{{--                <header class="report-header">--}}
{{--                    <h1 class="text-4xl font-bold">{{ $equipment->name }}</h1>--}}
{{--                    <p class="text-lg text-gray-700 mt-2">گزارش تاریخچه دما</p>--}}
{{--                </header>--}}

{{--                <main class="p-8">--}}
{{--                    <!-- Section 1: Equipment Details -->--}}
{{--                    <section class="report-section">--}}
{{--                        <h2 class="section-title"><i class="fa fa-info-circle ml-3"></i>۱. اطلاعات کلی تجهیز</h2>--}}
{{--                        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-6 mt-4">--}}
{{--                            <div class="info-item"><strong>کد شناسایی:</strong> <span class="font-mono">{{ $equipment->system_sku }}</span></div>--}}
{{--                            <div class="info-item"><strong>مدل:</strong> <span>{{ $equipment->model ?? '-' }}</span></div>--}}
{{--                            <div class="info-item"><strong>تیم تحقیقاتی:</strong> <span>{{ $equipment->researchTeam->name }}</span></div>--}}
{{--                            <div class="info-item"><strong>مکان:</strong> <span>{{ $equipment->location->parent->name ?? '' }} / {{ $equipment->location->name ?? '' }}</span></div>--}}
{{--                            <div class="info-item"><strong>محدوده دمای مجاز:</strong> <span class="font-bold">{{ $equipment->min_temp }}°C</span> تا <span class="font-bold">{{ $equipment->max_temp }}°C</span></div>--}}
{{--                        </div>--}}
{{--                    </section>--}}

{{--                    --}}{{-- [NEW] Filter Section --}}
{{--                    <section class="report-section no-print">--}}
{{--                        <h2 class="section-title"><i class="fa fa-filter ml-3"></i>۲. فیلتر گزارش</h2>--}}
{{--                        <form method="GET" action="{{ route('reports.equipment.temp-log', $equipment) }}" class="mt-4 p-4 border rounded-lg bg-gray-50">--}}
{{--                            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">--}}
{{--                                <div>--}}
{{--                                    <label for="auditor" class="block text-sm font-medium text-gray-700">بازرس</label>--}}
{{--                                    <select name="auditor" id="auditor" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">--}}
{{--                                        <option value="">همه</option>--}}
{{--                                        @foreach($auditors as $auditor)--}}
{{--                                            <option value="{{ $auditor->id }}" @selected(request('auditor') == $auditor->id)>{{ $auditor->name }}</option>--}}
{{--                                        @endforeach--}}
{{--                                    </select>--}}
{{--                                </div>--}}
{{--                                <div>--}}
{{--                                    <label for="start_date_picker" class="block text-sm font-medium text-gray-700">از تاریخ</label>--}}
{{--                                    <input type="text" name="start_date" id="start_date_picker" value="{{ request('start_date') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" autocomplete="off">--}}
{{--                                </div>--}}
{{--                                <div>--}}
{{--                                    <label for="end_date_picker" class="block text-sm font-medium text-gray-700">تا تاریخ</label>--}}
{{--                                    <input type="text" name="end_date" id="end_date_picker" value="{{ request('end_date') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" autocomplete="off">--}}
{{--                                </div>--}}
{{--                                <div class="self-end">--}}
{{--                                    <button type="submit" class="w-full bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded-lg">اعمال فیلتر</button>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </form>--}}
{{--                    </section>--}}

{{--                    <!-- Section 2: Temperature Chart -->--}}
{{--                    <section class="report-section page-break-before">--}}
{{--                        <h2 class="section-title"><i class="fa fa-chart-line ml-3"></i>۳. نمودار نوسانات دما</h2>--}}
{{--                        <div class="mt-6 h-80">--}}
{{--                            <canvas id="tempHistoryChart"></canvas>--}}
{{--                        </div>--}}
{{--                    </section>--}}

{{--                    <!-- Section 3: Detailed Log Table -->--}}
{{--                    <section class="report-section page-break-before">--}}
{{--                        <h2 class="section-title"><i class="fa fa-list-ul ml-3"></i>۴. لیست کامل سوابق</h2>--}}
{{--                        <div class="overflow-x-auto mt-4">--}}
{{--                            <table class="custom-table">--}}
{{--                                <thead>--}}
{{--                                <tr>--}}
{{--                                    <th>تاریخ و ساعت</th>--}}
{{--                                    <th>دمای ثبت شده (°C)</th>--}}
{{--                                    <th>بازرس</th>--}}
{{--                                    <th>یادداشت‌ها</th>--}}
{{--                                </tr>--}}
{{--                                </thead>--}}
{{--                                <tbody>--}}
{{--                                @forelse($logs as $log)--}}
{{--                                    <tr class="page-break-inside-avoid">--}}
{{--                                        <td class="font-mono">{{ verta($log->created_at)->format('Y/m/d H:i') }}</td>--}}
{{--                                        <td class="font-bold">{{ $log->temperature }}</td>--}}
{{--                                        <td>{{ $log->auditor->name }}</td>--}}
{{--                                        <td>{{ $log->notes }}</td>--}}
{{--                                    </tr>--}}
{{--                                @empty--}}
{{--                                    <tr>--}}
{{--                                        <td colspan="4" class="text-center p-6">هیچ سابقه‌ای با فیلترهای اعمال شده یافت نشد.</td>--}}
{{--                                    </tr>--}}
{{--                                @endforelse--}}
{{--                                </tbody>--}}
{{--                            </table>--}}
{{--                        </div>--}}
{{--                    </section>--}}
{{--                </main>--}}
{{--            </div>--}}
{{--        </td>--}}
{{--    </tr>--}}
{{--    </tbody>--}}
{{--</table>--}}

{{--<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>--}}
{{--<script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>--}}
{{--<script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>--}}
{{--<script>--}}
{{--    document.addEventListener('DOMContentLoaded', function () {--}}
{{--        new persianDatepicker({ element: '#start_date_picker', format: 'YYYY/MM/DD' });--}}
{{--        new persianDatepicker({ element: '#end_date_picker', format: 'YYYY/MM/DD' });--}}
{{--        const chartData = @json($chartData);--}}
{{--        const ctx = document.getElementById('tempHistoryChart');--}}

{{--        if (ctx && chartData && chartData.labels.length > 0) {--}}
{{--            new Chart(ctx, {--}}
{{--                type: 'line',--}}
{{--                data: {--}}
{{--                    labels: chartData.labels,--}}
{{--                    datasets: [{--}}
{{--                        label: 'دمای ثبت شده',--}}
{{--                        data: chartData.data,--}}
{{--                        borderColor: 'rgb(59, 130, 246)',--}}
{{--                        backgroundColor: 'rgba(59, 130, 246, 0.1)',--}}
{{--                        fill: true,--}}
{{--                        tension: 0.2--}}
{{--                    }]--}}
{{--                },--}}
{{--                options: {--}}
{{--                    responsive: true,--}}
{{--                    maintainAspectRatio: false,--}}
{{--                    scales: {--}}
{{--                        y: {--}}
{{--                            ticks: { callback: function(value) { return value + '°C' } }--}}
{{--                        }--}}
{{--                    }--}}
{{--                }--}}
{{--            });--}}
{{--        }--}}
{{--    });--}}
{{--</script>--}}
{{--</body>--}}
{{--</html>--}}
    <!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش دمای تجهیز: {{ $equipment->name }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="{{ asset('css/print.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    {{-- Jalali Date Picker Assets --}}
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css"/>
</head>
<body class="bg-gray-200">

{{-- Control Panel --}}
<div class="control-panel no-print sticky top-0 bg-gray-800 p-3 shadow-lg z-50 flex justify-between items-center">
    <div class="text-white font-bold">
        <i class="fa fa-thermometer-half ml-2"></i>
        <span>گزارش دما: {{ $equipment->name }}</span>
    </div>
    <button onclick="window.print()" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg">
        <i class="fa fa-print ml-2"></i>
        چاپ / ذخیره PDF
    </button>
</div>

<table class="print-wrapper">
    <thead class="print-header">
    <tr>
        <td>
            <div class="header-content">
                <span class="font-bold">گزارش جامع دمای تجهیزات</span>
                <span>{{ $equipment->name }}</span>
            </div>
        </td>
    </tr>
    </thead>
    <tfoot class="print-footer">
    <tr>
        <td>
            <div class="footer-content">
                <span>تهیه شده در تاریخ: {{ verta()->format('Y/m/d') }}</span>
                <span class="page-number"></span>
            </div>
        </td>
    </tr>
    </tfoot>
    <tbody>
    <tr>
        <td>
            <div class="report-main-content">
                <header class="report-header">
                    <h1 class="text-4xl font-bold">{{ $equipment->name }}</h1>
                    <p class="text-lg text-gray-700 mt-2">گزارش تاریخچه دما</p>
                </header>

                <main class="p-8">
                    <!-- Section 1: Equipment Details -->
                    <section class="report-section">
                        <h2 class="section-title"><i class="fa fa-info-circle ml-3"></i>۱. اطلاعات کلی تجهیز</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-6 mt-4">
                            <div class="info-item"><strong>کد شناسایی:</strong> <span class="font-mono">{{ $equipment->system_sku }}</span></div>
                            <div class="info-item"><strong>مدل:</strong> <span>{{ $equipment->model ?? '-' }}</span></div>
                            <div class="info-item"><strong>تیم تحقیقاتی:</strong> <span>{{ $equipment->researchTeam->name }}</span></div>
                            <div class="info-item"><strong>مکان:</strong> <span>{{ $equipment->location->parent->name ?? '' }} / {{ $equipment->location->name ?? '' }}</span></div>
                            <div class="info-item"><strong>محدوده دمای مجاز:</strong> <span class="font-bold">{{ $equipment->min_temp }}°C</span> تا <span class="font-bold">{{ $equipment->max_temp }}°C</span></div>
                        </div>
                    </section>

                    {{-- Filter Section --}}
{{--                    <section class="report-section no-print">--}}
{{--                        <h2 class="section-title"><i class="fa fa-filter ml-3"></i>۲. فیلتر گزارش</h2>--}}
{{--                        <form method="GET" action="{{ route('reports.equipment.temp-log', $equipment) }}" class="mt-4 p-4 border rounded-lg bg-gray-50">--}}
{{--                            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">--}}
{{--                                <div>--}}
{{--                                    <label for="auditor" class="block text-sm font-medium text-gray-700">بازرس</label>--}}
{{--                                    <select name="auditor" id="auditor" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">--}}
{{--                                        <option value="">همه</option>--}}
{{--                                        @foreach($auditors as $auditor)--}}
{{--                                            <option value="{{ $auditor->id }}" @selected(request('auditor') == $auditor->id)>{{ $auditor->name }}</option>--}}
{{--                                        @endforeach--}}
{{--                                    </select>--}}
{{--                                </div>--}}
{{--                                <div>--}}
{{--                                    <label for="start_date_picker" class="block text-sm font-medium text-gray-700">از تاریخ</label>--}}
{{--                                    <input type="text" name="start_date" id="start_date_picker" value="{{ request('start_date') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" autocomplete="off">--}}
{{--                                </div>--}}
{{--                                <div>--}}
{{--                                    <label for="end_date_picker" class="block text-sm font-medium text-gray-700">تا تاریخ</label>--}}
{{--                                    <input type="text" name="end_date" id="end_date_picker" value="{{ request('end_date') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" autocomplete="off">--}}
{{--                                </div>--}}
{{--                                <div class="self-end">--}}
{{--                                    <button type="submit" class="w-full bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded-lg">اعمال فیلتر</button>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </form>--}}
{{--                    </section>--}}

                    <section class="report-section no-print">
                        <h2 class="section-title"><i class="fa fa-filter ml-3"></i>۲. فیلتر گزارش</h2>
                        <form method="GET" action="{{ route('reports.equipment.temp-log', $equipment) }}" class="mt-4 p-4 border rounded-lg bg-gray-50">
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                                <div>
                                    <label for="auditor" class="block text-sm font-medium text-gray-700">بازرس</label>
                                    <select name="auditor" id="auditor" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                        <option value="">همه</option>
                                        @foreach($auditors as $auditor)
                                            <option value="{{ $auditor->id }}" @selected(request('auditor') == $auditor->id)>{{ $auditor->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <label for="start_date_picker" class="block text-sm font-medium text-gray-700">از تاریخ</label>
                                    <input type="text" name="start_date" id="start_date_picker" value="{{ request('start_date') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" autocomplete="off">
                                </div>
                                <div>
                                    <label for="end_date_picker" class="block text-sm font-medium text-gray-700">تا تاریخ</label>
                                    <input type="text" name="end_date" id="end_date_picker" value="{{ request('end_date') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" autocomplete="off">
                                </div>
                                <div class="self-end">
                                    <button type="submit" class="w-full bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded-lg">اعمال فیلتر</button>
                                </div>
                            </div>
                        </form>
                    </section>
                    <!-- Section 2: Temperature Chart -->
                    <section class="report-section page-break-before">
                        <h2 class="section-title"><i class="fa fa-chart-line ml-3"></i>۳. نمودار نوسانات دما</h2>
                        <div class="mt-6 h-80">
                            <canvas id="tempHistoryChart"></canvas>
                        </div>
                    </section>

                    <!-- Section 3: Detailed Log Table -->
                    <section class="report-section page-break-before">
                        <h2 class="section-title"><i class="fa fa-list-ul ml-3"></i>۴. لیست کامل سوابق</h2>
                        <div class="overflow-x-auto mt-4">
                            <table class="custom-table">
                                <thead>
                                <tr>
                                    <th>تاریخ و ساعت</th>
                                    <th>دمای ثبت شده (°C)</th>
                                    <th>بازرس</th>
                                    <th>یادداشت‌ها</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($logs as $log)
                                    <tr class="page-break-inside-avoid">
                                        <td class="font-mono">{{ verta($log->created_at)->format('Y/m/d H:i') }}</td>
                                        <td class="font-bold">{{ $log->temperature }}</td>
                                        <td>{{ $log->auditor->name }}</td>
                                        <td>{{ $log->notes }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center p-6">هیچ سابقه‌ای با فیلترهای اعمال شده یافت نشد.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                        {{-- [NEW] Pagination Links --}}
                        <div class="mt-4 no-print">
                            {{ $logs->withQueryString()->links() }}
                        </div>
                    </section>
                </main>
            </div>
        </td>
    </tr>
    </tbody>
</table>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
<script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // [FIXED] Use jQuery plugin syntax for datepicker initialization
        $('#start_date_picker').persianDatepicker({
            format: 'YYYY/MM/DD',
            toolbox: {
                calendarSwitch: {
                    enabled: true
                }
            }
        });
        $('#end_date_picker').persianDatepicker({
            format: 'YYYY/MM/DD',
            toolbox: {
                calendarSwitch: {
                    enabled: true
                }
            }
        });

        // Initialize Chart
        const chartData = @json($chartData);
        const ctx = document.getElementById('tempHistoryChart');
        if (ctx && chartData && chartData.labels.length > 0) {
            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: chartData.labels,
                    datasets: [{
                        label: 'دمای ثبت شده',
                        data: chartData.data,
                        borderColor: 'rgb(59, 130, 246)',
                        backgroundColor: 'rgba(59, 130, 246, 0.1)',
                        fill: true,
                        tension: 0.2
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: { ticks: { callback: function(value) { return value + '°C' } } }
                    }
                }
            });
        }
    });
</script>
</body>
</html>
