    <!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>صفحه اصلی - Benchsync</title>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Link to your external CSS file -->
    <link rel="stylesheet" href="{{ asset('css/welcome.css') }}">

</head>
<body class="bg-slate-100 dark:bg-slate-900">

<div class="relative flex flex-col items-center justify-center min-h-screen p-4 sm:p-6">

    {{-- دکمه‌های ورود و ثبت نام در بالا سمت چپ --}}
    <header class="absolute top-0 left-0 w-full p-6">
        <nav class="flex items-center justify-start gap-4">
            @if (Route::has('login'))
                            <nav class="flex items-center justify-end gap-4">
                                @auth
                                    <a href="{{ url('/dashboard') }}" class="inline-block px-5 py-2 text-sm font-medium text-white bg-blue-600 border border-transparent rounded-lg shadow-sm hover:bg-blue-700 transition">
                                        داشبورد
                                    </a>
                                @else
                                    <a href="{{ route('login') }}" class="inline-block px-5 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-200 rounded-lg shadow-sm hover:bg-gray-50 dark:bg-gray-800 dark:text-gray-200 dark:border-gray-700 dark:hover:bg-gray-700 transition">
                                        ورود
                                    </a>

                                    @if (Route::has('register'))
                                        <a href="{{ route('register') }}" class="inline-block px-5 py-2 text-sm font-medium text-white bg-blue-600 border border-transparent rounded-lg shadow-sm hover:bg-blue-700 transition">
                                            ثبت نام
                                        </a>
                                    @endif
                                @endauth
                            </nav>
                        @endif


        </nav>
    </header>

    {{-- کارت اصلی --}}
    <main class="w-full" style="max-width: 900px;">
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-2xl overflow-hidden flex flex-col md:flex-row">

            {{-- بخش سمت راست: متن توضیحات --}}
            <div class="w-full md:w-1/2 p-8 sm:p-12 order-2 md:order-1">
                <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white mb-4">
                    پلتفرم یکپارچه مدیریت آزمایشگاه
                </h1>
                <p class="text-gray-600 dark:text-gray-300 leading-relaxed">
                    هدف ما بر این باور استوار است که ابزارهای مورد استفاده
                    محققین علوم زیستی باید منعکس کننده روش های واقعی
                    دانشمندان باشد از این رو از روز اول طرح ریزی این پروژه
                    با هماهنگی کامل و نزدیک محققین این حوزه و بخش
                    های تحقیق و توسعه سازمان های زیستی آن را توسعه
                    داده ایم؛ این بدان معنی خواهد بود که بدون توجه به
                    حوزه تخصصی دانش شما، نرم افزار ما به همان روشی کار
                    خواهد کرد که شما می خواهید                </p>
                <div class="mt-8">
                    <a href="{{ url('/login') }}" class="inline-flex items-center px-6 py-3 text-white bg-blue-600 rounded-lg shadow-lg hover:bg-blue-700 transition-transform hover:scale-105">
                        <span>شروع کنید</span>
                        <x-lucide-arrow-left class="w-5 h-5 mr-2" />
                    </a>
                </div>
            </div>

            {{-- بخش سمت چپ: لوگو --}}
            <div class="w-full md:w-1/2 bg-gradient-to-br from-blue-600 to-indigo-700 flex items-center justify-center p-8 order-1 md:order-2" style="min-height: 400px;">
                <div class="text-center">
                    <img src="{{ asset('benchsynclogo.png') }}" alt="BenchSync Logo" class="w-40 h-auto mx-auto">
                    <p class="text-blue-200 mt-1">برای موفقیت همگام سازی کنید</p>
                </div>
            </div>

        </div>
    </main>
</div>

</body>
</html>
