<?php

use Illuminate\Support\Facades\Route;
use App\Livewire\InstitutionManager;
use App\Livewire\ProjectManager;
use App\Livewire\InventoryManager;
use App\Livewire\ProjectDetail;
use App\Livewire\PurchaseRequestManager;
use App\Livewire\CreateLabNotebookEntry;
use App\Livewire\EditLabNotebookEntry;
use App\Livewire\ApprovalQueueManager;
use App\Http\Controllers\Auth\SupplierLoginController;
use App\Livewire\SupplierDashboard; // کامپوننت جدید ما
use App\Http\Controllers\PdfController; // کنترلر جدید ما
use App\Livewire\SupplierOrders; // کامپوننت جدید ما
use App\Livewire\InstitutionOnboarding; // کامپوننت جدید ما
use App\Livewire\TeamManager; // کامپوننت جدید ما
use App\Livewire\StorageLocationManager; // کامپوننت جدید ما
use App\Http\Middleware\EnsureUserHasInstitution;
use App\Http\Middleware\EnsureCanViewFinancials;
//use ReflectionMethod;
use App\Models\ResearchTeam;
use App\Livewire\BoxViewer; // کامپوننت جدید ما
use App\Livewire\InventoryTransferManager; // کامپوننت جدید ما
use App\Livewire\TransferApprovalManager; // کامپوننت جدید ما
use App\Livewire\Admin\InstitutionRequestManager as AdminInstitutionRequestManager; // کامپوننت جدید ما
use App\Livewire\Admin\Dashboard;
use App\Http\Controllers\Auth\AdminLoginController;
use App\Livewire\Admin\Dashboard as AdminDashboard;
use App\Livewire\Admin\UserManager as AdminUserManager;
use App\Livewire\Admin\FinancialSettlement;
use App\Livewire\WarehouseRequestManager;
use App\Http\Middleware\CheckWarehouseAccess;
use App\Livewire\TestComponent;
use App\Http\Controllers\ProjectReportController;
use App\Http\Controllers\CollaboratorReportController;
use App\Livewire\ChatManager;
use App\Livewire\EquipmentManager;
use App\Livewire\ResearchTeamDashboard;
use App\Http\Controllers\PublicEquipmentController;
use App\Http\Controllers\InvitationController;
use App\Http\Controllers\TeamWorkloadReportController;
use App\Livewire\PublicTempLogger;
use App\Livewire\TemperatureLogHistory;
use App\Http\Controllers\PaymentController;
use App\Livewire\FinancialManager;
use App\Livewire\InventoryReport;
use App\Livewire\BioInventoryManager;
use App\Livewire\TankViewer;
use App\Livewire\CaneViewer;
use App\Livewire\SampleRequestManager;
use App\Livewire\PersonalNotebook;
use App\Livewire\CreatePersonalNote;












/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::get('/', function () {
    return view('welcome');
});
// [NEW] مسیر عمومی برای نمایش اطلاعات تجهیز از طریق QR Code
Route::get('/equipment/public/{equipment:system_sku}', [PublicEquipmentController::class, 'show'])
    ->name('equipment.public.show');
// مسیر جدید برای کاربرانی که هنوز سازمانی ندارند
Route::middleware(['auth:sanctum', 'verified'])->group(function () {
    Route::get('/onboarding', InstitutionOnboarding::class)->name('onboarding');
});
// مسیرهای اختصاصی تأمین‌کنندگان که نیاز به احراز هویت ندارند
Route::prefix('supplier')->name('supplier.')->group(function () {
    Route::get('login', [SupplierLoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [SupplierLoginController::class, 'login']);
});
// [NEW] Public route for temperature logging via QR Code
Route::get('/log/temp/room/{uuid}', PublicTempLogger::class)
    ->name('public.temp-log');



Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
    EnsureUserHasInstitution::class, //هرچقد با نام مستعار خواستم این کلاس فراخوانی بشه نشد. برای همین مستقیم فراخوانیش کردم
    ])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    Route::get('/test', TestComponent::class)
        ->middleware('auth');

// [NEW] Route for the personal notebook
    Route::get('/personal-notebook/create', CreatePersonalNote::class)
        ->name('personal-notebook.create');
    Route::get('/personal-notebook/{note}/edit', CreatePersonalNote::class)
        ->name('personal-notebook.edit');
    Route::get('/personal-notebook', PersonalNotebook::class)
        ->name('personal-notebook.index');

    // مسیر مدیریت نهادها
    Route::get('/institutions', InstitutionManager::class)
        ->name('institutions.index');

    // مسیر مدیریت طرح‌ها (لیست)
    Route::get('/projects', ProjectManager::class)
        ->name('projects.index');

    // مسیر جدید برای جزئیات یک طرح خاص
    Route::get('/projects/{project:sku}', ProjectDetail::class)
        ->name('projects.show');
    // مسیر جدید برای ایجاد یادداشت در یک طرح خاص
    Route::get('/projects/{project:sku}/entries/create', CreateLabNotebookEntry::class)
        ->name('projects.entries.create');
// biological inventory management
    Route::get('/bio-inventory', BioInventoryManager::class)
        ->name('bio-inventory.index')
        ->middleware('auth');
    //TankViewer;
    Route::get('/tanks/{location}', TankViewer::class)
        ->name('tanks.show')
        ->middleware('auth');
    Route::get('/inventory/locations/cane/{locationId}', CaneViewer::class)
        ->name('inventory.locations.cane.view');

    // مسیر جدید برای ویرایش یک یادداشت خاص
    Route::get('/entries/{entry:sku}/edit', EditLabNotebookEntry::class)
        ->name('entries.edit');
    // مسیر مدیریت انبار
    Route::get('/inventory', InventoryManager::class)
        ->name('inventory.index');
    Route::get('/inventory/locations', StorageLocationManager::class)
        ->name('inventory.locations.index'); // مسیر جدید
    Route::get('/inventory/locations/{location}/view', BoxViewer::class)
        ->name('inventory.locations.view');
    Route::get('/inventory/transfers', InventoryTransferManager::class)
        ->name('inventory.transfers.index'); // مسیر جدید
    // مسیر جدید برای تایید حواله‌ها
    Route::get('/inventory/transfer-approvals', TransferApprovalManager::class)
        ->name('inventory.transfers.approvals')
        ->middleware('can:view-transfer-approvals');
    Route::get('/inventory/reports', InventoryReport::class)
        ->name('inventory.reports')
        ->middleware('auth');
    // مسیر جدید برای تایید گردش انبار
    Route::get('/warehouse/requests', WarehouseRequestManager::class)
        ->middleware(\App\Http\Middleware\CheckWarehouseAccess::class)
        ->name('warehouse.requests');

    // مسیر جدید برای مدیریت درخواست‌های خرید
    Route::get('/purchase-requests', PurchaseRequestManager::class)
        ->name('purchase-requests.index');
    // مسیر جدید برای صف تاییدها
    Route::get('/approvals', ApprovalQueueManager::class)
        ->name('approvals.index');
    // مسیر جدید برای دانلود PDF پیش‌فاکتور
    Route::get('/responses/{response}/download-proforma', [PdfController::class, 'downloadProformaInvoice'])
        ->name('responses.proforma.download');

    // مسیر جدید برای مدیریت تیم‌ها توسط مدیر سازمان
    Route::get('/institution/teams', TeamManager::class)
        ->name('institution.teams.index')
        ->middleware('can:manage-institution');

    // مسیر جدید برای دانلود برچسب بارکد
    Route::get('/inventory/items/{item:sku}/barcode', [PdfController::class, 'downloadBarcodeLabel'])
        ->name('inventory.items.barcode');
    // مسیر جدید برای چاپ گروهی
    Route::get('/inventory/items/bulk-barcode', [PdfController::class, 'downloadBulkBarcodeLabels'])
        ->name('inventory.items.bulk-barcode');
    // مسیرهای جدید برای چاپ برچسب مکان‌ها
    Route::get('/inventory/locations/{location}/barcode', [PdfController::class, 'downloadLocationBarcodeLabel'])
        ->name('inventory.locations.barcode');
    Route::get('/inventory/locations/bulk-barcode', [PdfController::class, 'downloadBulkLocationBarcodeLabels'])
        ->name('inventory.locations.bulk-barcode');

    Route::get('/projects/{project:sku}/report', [ProjectReportController::class, 'show'])
        ->middleware(['auth:sanctum', 'verified'])
        ->name('projects.report');
    Route::get('/projects/{project:sku}/reports/{user}', [CollaboratorReportController::class, 'show'])
        ->middleware(['auth:sanctum', 'verified'])
        ->name('projects.collaborator.report');
    Route::get('/my-research-teams', ResearchTeamDashboard::class)
        ->name('research-teams.dashboard');

    // [NEW] مسیرهای مربوط به ماژول چت
    Route::get('/chat/{chatRoomId?}', ChatManager::class)
        ->name('chat.index');
    Route::get('/equipment', EquipmentManager::class)
        ->name('equipment.index');
// [NEW] مسیر عمومی برای پذیرش دعوت‌نامه عضویت در تیم
    Route::get('/invitations/accept/{token}', [InvitationController::class, 'accept'])
        ->middleware(['signed']) // استفاده از middleware برای امنیت لینک
        ->name('invitations.accept');

    Route::get('/research-teams/{team}/workload-report', [TeamWorkloadReportController::class, 'show'])
        ->middleware(['auth'])
        ->name('teams.workload-report');
    // [NEW] Dedicated route for viewing temperature log history for a specific equipment
    Route::get('/reports/equipment/{equipment}/temperature-log', [PdfController::class, 'showTemperatureLogReport'])
        ->name('reports.equipment.temp-log')
        ->middleware('auth');
    Route::get('/payment/callback', [PaymentController::class, 'callback'])
        ->name('payment.callback');
// [NEW] Route for the Financial Management module
    Route::get('/financials', FinancialManager::class)
        ->name('financials.index')
        ->middleware(\App\Http\Middleware\EnsureCanViewFinancials::class);
    Route::get('/reports/financial-history/download', [App\Http\Controllers\PdfController::class, 'downloadFinancialHistory'])
        ->name('reports.financial.download');



});

// در آینده، مسیرهای داشبورد تأمین‌کنندگان که نیاز به احراز هویت اختصاصی دارند، در اینجا اضافه خواهد شد
Route::middleware(['auth:supplier'])->prefix('supplier')->name('supplier.')->group(function() {


    Route::get('dashboard', SupplierDashboard::class)
        ->name('dashboard');

    Route::get('orders', SupplierOrders::class)
        ->name('orders.index'); // مسیر جدید برای سفارش‌ها

    Route::get('requests/{request}/invoice', [PdfController::class, 'downloadOrderInvoice'])
        ->name('orders.invoice');

    // مسیرهای جدید برای چاپ برچسب‌ها
    Route::get('labels/sender', [PdfController::class, 'downloadSenderLabel'])->name('labels.sender');
    Route::get('requests/{request}/receiver-label', [PdfController::class, 'downloadReceiverLabel'])->name('labels.receiver');




    Route::post('logout', [SupplierLoginController::class, 'logout'])
        ->name('logout');
    // Route::get('dashboard', ...)->name('dashboard');
});

// گروه مسیرهای پنل مدیریت کل (فقط برای Super Admin)
Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
    'can:view-admin-panel' // مسیر با Gate جدید امن شده است
])->prefix('admin')->name('admin.')->group(function () {

    // این روت، کامپوننت داشبورد را به عنوان یک صفحه کامل رندر می‌کند
    Route::get('/admin/dashboard', Dashboard::class)
        ->name('admin.dashboard');
    // مسیر مدیریت درخواست‌های ایجاد سازمان
    Route::get('/institution-requests', AdminInstitutionRequestManager::class)
        ->name('institution-requests.index');

    // در آینده، سایر مسیرهای پنل ادمین در اینجا اضافه خواهند شد


});

Route::prefix('administrator')->name('admin.')->group(function () {

    // مسیرهای ورود و خروج ادمین که نیاز به احراز هویت ندارند
    Route::get('login', [AdminLoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [AdminLoginController::class, 'login']);

    // گروه مسیرهایی که نیاز به احراز هویت با گارد 'admin' دارند
    Route::middleware(['auth:admin'])->group(function () {
        // در آینده، مسیر داشبورد ادمین در اینجا قرار خواهد گرفت
        Route::get('dashboard', AdminDashboard::class)
            ->name('dashboard');
        // مسیر جدید برای مدیریت کاربران
        Route::get('/users', AdminUserManager::class)
            ->name('users.index');
        // مسیر مدیریت درخواست‌های ایجاد سازمان
        Route::get('/institution-requests', \App\Livewire\Admin\InstitutionRequestManager::class)
            ->name('institution-requests.index');
        // [NEW] Route for the financial settlement module
        Route::get('/financial-settlement', FinancialSettlement::class)
            ->name('financial-settlement.index');

        Route::post('logout', [AdminLoginController::class, 'logout'])
            ->name('logout');


    });
});
