<aside
    x-show="sidebarOpen"
    @click.away="if (window.innerWidth < 1024) sidebarOpen = false"
    x-transition:enter="transition ease-in-out duration-300"
    x-transition:enter-start="-translate-x-full"
    x-transition:enter-end="translate-x-0"
    x-transition:leave="transition ease-in-out duration-300"
    x-transition:leave-start="translate-x-0"
    x-transition:leave-end="-translate-x-full"
    class="fixed inset-y-0 right-0 z-30 w-64 overflow-y-auto bg-gray-900 text-white lg:static lg:inset-auto lg:translate-x-0"
    x-cloak
>
    <!-- Sidebar Header -->
    <div class="flex items-center justify-center p-4 border-b border-gray-700">
        <i class="bi bi-shield-lock-fill text-2xl text-indigo-400"></i>
        <h2 class="text-xl font-semibold ml-3">پنل مدیریت</h2>
    </div>

    <!-- Sidebar Menu -->
    <nav class="p-4" x-data="{ openMenu: '' }">
        <a href="#" class="flex items-center px-4 py-2.5 rounded-lg sidebar-link active">
            <i class="bi bi-speedometer2 text-lg"></i>
            <span class="mr-3 font-medium">داشبورد</span>
        </a>
        <!-- Multi-level Menu: Posts -->
        <div class="mt-2">
            <button @click="openMenu = (openMenu === 'posts' ? '' : 'posts')" class="w-full flex items-center justify-between px-4 py-2.5 rounded-lg sidebar-link">
                <span class="flex items-center">
                    <i class="bi bi-file-post text-lg"></i>
                    <span class="mr-3 font-medium">مدیریت سازمانها</span>
                </span>
                <i class="bi bi-chevron-down transition-transform duration-300" :class="{'rotate-180': openMenu === 'posts'}"></i>
            </button>
            <div x-show="openMenu === 'posts'" x-collapse x-cloak>
                <ul class="pt-2 pr-4">
                    <li>
                        <a href="<?php echo e(route('admin.institution-requests.index')); ?>" class="flex items-center px-4 py-2 rounded-lg text-gray-300 sidebar-submenu-link">
                            <i class="bi bi-plus-circle"></i>
                            <span class="mr-3">درخواست عضویت</span>
                        </a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center px-4 py-2 rounded-lg text-gray-300 sidebar-submenu-link">
                            <i class="bi bi-card-list"></i>
                            <span class="mr-3">لیست مقالات</span>
                        </a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center px-4 py-2 rounded-lg text-gray-300 sidebar-submenu-link">
                            <i class="bi bi-tags-fill"></i>
                            <span class="mr-3">دسته‌بندی‌ها</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Multi-level Menu: Users -->
        <div class="mt-4">
            <button @click="openMenu = (openMenu === 'users' ? '' : 'users')" class="w-full flex items-center justify-between px-4 py-2.5 rounded-lg sidebar-link">
                <span class="flex items-center">
                    <i class="bi bi-people-fill text-lg"></i>
                    <span class="mr-3 font-medium">مدیریت کاربران</span>
                </span>
                <i class="bi bi-chevron-down transition-transform duration-300" :class="{'rotate-180': openMenu === 'users'}"></i>
            </button>
            <div x-show="openMenu === 'users'" x-collapse x-cloak>
                <ul class="pt-2 pr-4">
                    <li>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="flex items-center px-4 py-2 rounded-lg text-gray-300 sidebar-submenu-link">
                            <i class="bi bi-person-plus-fill"></i>
                            <span class="mr-3">کاربران</span>
                        </a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center px-4 py-2 rounded-lg text-gray-300 sidebar-submenu-link">
                            <i class="bi bi-list-ul"></i>
                            <span class="mr-3">لیست کاربران</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>



        <a href="#" class="flex items-center mt-2 px-4 py-2.5 rounded-lg sidebar-link">
            <i class="bi bi-gear-fill text-lg"></i>
            <span class="mr-3 font-medium">تنظیمات</span>
        </a>
    </nav>
</aside>
<?php /**PATH D:\wamp64\www\benchsync\resources\views/partials/_sidebar.blade.php ENDPATH**/ ?>