<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($title ?? 'مدیریت آزمایشگاه'); ?></title>

    <!-- [UPDATED] JalaliDatePicker CSS -->
    <link rel="stylesheet" href="https://unpkg.com/@majidh1/jalalidatepicker/dist/jalalidatepicker.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />


    <!-- Custom USER CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/user-ui.css')); ?>">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>
<body class="bg-gray-100">

<div x-data="{ sidebarOpen: false, sidebarExpanded: false }" @keydown.escape.window="sidebarOpen = false">

    <div x-show="sidebarOpen" @click="sidebarOpen = false" class="fixed inset-0 bg-black/60 z-30 md:hidden" x-cloak></div>

    <!-- Sidebar -->
    <?php echo $__env->make('partials._sidebar-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content & Header -->
    <div class="flex flex-col flex-1 h-screen overflow-y-auto transition-all duration-300 ease-in-out"
         :class="{ 'md:mr-64': sidebarExpanded, 'md:mr-20': !sidebarExpanded }">

        <!-- Header -->
        <?php echo $__env->make('partials._header-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Livewire Component Content -->
        <main class="p-6 sm:p-8">
            <?php echo e($slot); ?>

        </main>
    </div>
</div>
<?php echo $__env->yieldPushContent('modals'); ?>

<?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>


<?php echo $__env->yieldPushContent('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<!-- [UPDATED] JalaliDatePicker JS -->
<script type="text/javascript" src="https://unpkg.com/@majidh1/jalalidatepicker/dist/jalalidatepicker.min.js"></script>
<!-- [UPDATED] Initialize the datepicker -->
<script type="text/javascript">
    jalaliDatepicker.startWatch();
</script>

</body>
</html>
<?php /**PATH D:\wamp64\www\benchsync\resources\views/layouts/app.blade.php ENDPATH**/ ?>