<div
    x-data="progressWidgetComponent()"
    x-init="initChart()"
    @update-progress-chart.window="updateChart($event.detail.data)"
    class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8"
>
    <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">نمای کلی پیشرفت پروژه‌ها</h3>
        <div class="w-full sm:w-64">
            <select wire:model.live="selectedProjectId" class="block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                <!--[if BLOCK]><![endif]--><?php if($projects->isEmpty()): ?>
                    <option value="">هیچ پروژه‌ای یافت نشد</option>
                <?php else: ?>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($project->id); ?>"><?php echo e($project->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </select>
        </div>
    </div>

    <div wire:loading wire:target="selectedProjectId" class="text-center py-8">
        <p class="text-gray-500">در حال بارگذاری اطلاعات...</p>
    </div>

    <div wire:loading.remove wire:target="selectedProjectId">
        <!--[if BLOCK]><![endif]--><?php if($selectedProject): ?>
            <div class="mt-6 grid grid-cols-1 lg:grid-cols-5 gap-8">
                <!-- Chart and Stats -->
                <div class="lg:col-span-2">
                    <div class="h-64">
                        <canvas x-ref="chart"></canvas>
                    </div>
                </div>
                <!-- Task List -->
                <div class="lg:col-span-3">
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">لیست وظایف</h4>
                    <div class="space-y-2 max-h-64 overflow-y-auto pr-2">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                <p class="font-medium text-gray-900 dark:text-white"><?php echo e($task->title); ?></p>
                                <div class="flex items-center justify-between mt-1 text-xs">
                                    <span class="badge badge-primary"><?php echo e($task->status); ?></span>
                                    <div class="flex -space-x-1">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $task->assignees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <img class="inline-block h-5 w-5 rounded-full ring-1 ring-white dark:ring-gray-800" src="<?php echo e($assignee->profile_photo_url); ?>" alt="<?php echo e($assignee->name); ?>" title="<?php echo e($assignee->name); ?>">
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-center text-sm text-gray-500 py-4">هیچ وظیفه‌ای برای این طرح تعریف نشده است.</p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="text-center py-8">
                <p class="text-gray-500">برای مشاهده آمار، یک پروژه را انتخاب کنید.</p>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        function progressWidgetComponent() {
            return {
                chart: null,
                initChart() {
                    const ctx = this.$refs.chart.getContext('2d');
                    this.chart = new Chart(ctx, {
                        type: 'doughnut',
                        data: {
                            labels: [], // شروع با یک لیست خالی
                            datasets: [{
                                data: [],
                                backgroundColor: ['#22c55e', '#f59e0b', '#3b82f6'],
                                borderColor: document.body.classList.contains('dark') ? '#1f2937' : '#fff',
                                borderWidth: 2,
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                legend: {
                                    position: 'bottom',
                                    labels: {
                                        color: document.body.classList.contains('dark') ? '#d1d5db' : '#4b5563',
                                        font: { family: 'Vazirmatn' }
                                    }
                                }
                            }
                        }
                    });
                },
                updateChart(data) {
                    if (this.chart && data && data.labels) {
                        this.chart.data.labels = data.labels;
                        this.chart.data.datasets[0].data = data.data;
                        this.chart.update();
                    }
                }
            }
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\wamp64\www\benchsync\resources\views/livewire/project-progress-widget.blade.php ENDPATH**/ ?>