<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Chart and Stats -->
    <div class="lg:col-span-2 bg-white dark:bg-gray-100 rounded-xl shadow-lg border-t-4 border-indigo-600 p-6 sm:p-8">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-black mb-4">نمای کلی پیشرفت پروژه</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 items-center">
            <!-- Pie Chart -->
            <div class="h-64">
                
                <canvas id="progressPieChart"></canvas>
            </div>
            <!-- Stats -->
            <div class="space-y-4">
                <div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">درصد پیشرفت</p>
                    <div class="w-full bg-gray-200 rounded-full h-2.5 dark:bg-gray-700 mt-1">
                        <div class="bg-indigo-600 h-2.5 rounded-full" style="width: <?php echo e($completionPercentage); ?>%"></div>
                    </div>
                    <p class="text-xl font-bold text-gray-900 dark:text-black mt-1"><?php echo e($completionPercentage); ?>%</p>
                </div>
                <div class="grid grid-cols-3 gap-4 text-center">
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">کل وظایف</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-blue-950"><?php echo e($totalTasks); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-green-500">انجام شده</p>
                        <p class="text-2xl font-bold text-green-500"><?php echo e($completedTasks); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-yellow-500">در جریان</p>
                        <p class="text-2xl font-bold text-yellow-500"><?php echo e($inProgressTasks); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Overdue Tasks -->
    <div class="lg:col-span-1 bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-red-600 p-6 sm:p-8">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">وظایف نیازمند توجه (عقب افتاده)</h3>
        <div class="space-y-3 max-h-80 overflow-y-auto">
            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $overdueTasks ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="p-3 bg-red-50 dark:bg-red-900/20 rounded-lg">
                    <p class="font-semibold text-red-800 dark:text-red-300"><?php echo e($task->title); ?></p>
                    <p class="text-xs text-red-600 dark:text-red-400">تاریخ پایان: <?php echo e(verta($task->due_date)->format('Y/m/d')); ?></p>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-8">
                    <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lucide-check-check'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\BladeUI\Icons\Components\Svg::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mx-auto h-12 w-12 text-green-500']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
                    <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">هیچ وظیفه عقب افتاده‌ای وجود ندارد.</p>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</div>


<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('livewire:navigated', () => {
            const chartData = <?php echo json_encode($chartData, 15, 512) ?>;
            const ctx = document.getElementById('progressPieChart');

            if (window.progressChartInstance) {
                window.progressChartInstance.destroy();
            }

            if (ctx && chartData.labels && chartData.labels.length > 0) {
                window.progressChartInstance = new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: chartData.labels,
                        datasets: [{
                            data: chartData.data,
                            backgroundColor: [
                                '#22c55e', // green-500
                                '#f59e0b', // amber-500
                                '#3b82f6', // blue-500
                            ],
                            borderColor: document.body.classList.contains('dark') ? '#1f2937' : '#fff',
                            borderWidth: 2,
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: {
                                    color: document.body.classList.contains('dark') ? '#d1d5db' : '#4b5563',
                                    font: { family: 'Vazirmatn' } // نام فونت فارسی شما
                                }
                            }
                        }
                    }
                });
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\wamp64\www\benchsync\resources\views/livewire/project-progress-dashboard.blade.php ENDPATH**/ ?>