<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['location', 'level' => 0, 'selectedLocations' => []]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['location', 'level' => 0, 'selectedLocations' => []]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<div class="ml-<?php echo e($level * 4); ?>">
    <div class="flex items-center justify-between p-2 my-1 rounded-md <?php echo e($level > 0 ? 'bg-gray-50 dark:bg-gray-700/50' : ''); ?>">
        <div class="flex items-center">
            
            <input type="checkbox" wire:model.live="selectedLocations" value="<?php echo e($location->id); ?>" class="ml-2 rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500">
            
            <!--[if BLOCK]><![endif]--><?php if($location->location_type === 'building'): ?>
                🏢
            <?php elseif($location->location_type === 'room'): ?>
                🚪
            <?php elseif(in_array($location->location_type, ['freezer', 'refrigerator', 'tank'])): ?>
                ❄️
            <?php else: ?>
                📦
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            <span class="mr-2 font-semibold text-gray-800 dark:text-gray-200"><?php echo e($location->name); ?></span>
            <span class="mr-2 text-xs text-gray-500 dark:text-gray-400 font-mono">(<?php echo e($location->location_code); ?>)</span>
            <span class="mr-2 text-xs text-gray-500 dark:text-gray-400">(<?php echo e($location->location_type); ?>)</span>
            <!--[if BLOCK]><![endif]--><?php if($location->rows && $location->columns): ?>
                <span class="mr-2 text-xs text-gray-400">[<?php echo e($location->rows); ?>x<?php echo e($location->columns); ?>]</span>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="flex items-center space-x-2 space-x-reverse">
            <a href="<?php echo e(route('inventory.locations.barcode', $location)); ?>" target="_blank" title="چاپ برچسب" class="text-gray-400 hover:text-gray-600">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
            </a>
            
            <!--[if BLOCK]><![endif]--><?php if(count(\App\Livewire\StorageLocationManager::HIERARCHY_RULES[$location->location_type]) > 0): ?>
                <button wire:click="confirmLocationCreation(<?php echo e($location->id); ?>)" class="text-sm text-blue-500 hover:underline">افزودن زیرمجموعه</button>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            <!--[if BLOCK]><![endif]--><?php if(in_array($location->location_type, ['box', 'rack', 'tank'])): ?>
                <a href="<?php echo e(route('inventory.locations.view', $location)); ?>" class="text-sm text-green-500 hover:underline">مشاهده</a>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            <button wire:click="confirmLocationMove(<?php echo e($location->id); ?>)" class="text-sm text-green-500 hover:underline">جابجایی</button>
            <button wire:click="confirmLocationEdit(<?php echo e($location->id); ?>)" class="text-sm text-indigo-500 hover:underline">ویرایش</button>
            <button wire:click="confirmLocationDeletion(<?php echo e($location->id); ?>)" class="text-sm text-red-500 hover:underline">حذف</button>
        </div>
    </div>

    
    <!--[if BLOCK]><![endif]--><?php if($location->children->isNotEmpty()): ?>
        <div class="pl-4 border-r-2 dark:border-gray-700">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $location->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if (isset($component)) { $__componentOriginal614b002ef5d245179d627589e662515c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal614b002ef5d245179d627589e662515c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.location-item','data' => ['location' => $child,'level' => $level + 1,'selectedLocations' => $selectedLocations]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('location-item'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['location' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($child),'level' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($level + 1),'selectedLocations' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($selectedLocations)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal614b002ef5d245179d627589e662515c)): ?>
<?php $attributes = $__attributesOriginal614b002ef5d245179d627589e662515c; ?>
<?php unset($__attributesOriginal614b002ef5d245179d627589e662515c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal614b002ef5d245179d627589e662515c)): ?>
<?php $component = $__componentOriginal614b002ef5d245179d627589e662515c; ?>
<?php unset($__componentOriginal614b002ef5d245179d627589e662515c); ?>
<?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH D:\wamp64\www\benchsync\resources\views/components/location-item.blade.php ENDPATH**/ ?>