<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقویم</title>
    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="stylesheet" href="<?php echo e(asset('css/print.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>
<body class="bg-gray-200">
<div>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            تقویم تیمی
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white rounded-xl shadow-lg p-6 sm:p-8"
                 wire:ignore
                 
                 x-data="calendar"
                 x-init="initCalendar(<?php echo \Illuminate\Support\Js::from($events)->toHtml() ?>)">

                <div id="calendar" x-ref="calendar"></div>

            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        
        <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
        
        <script src="https://cdn.jsdelivr.net/npm/moment@2.30.1/moment.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/moment-jalaali@0.10.0/build/moment-jalaali.min.js"></script>
        
        <script src="https://cdn.jsdelivr.net/npm/@fullcalendar/moment@6.1.11/index.global.min.js"></script>

        <script>
            // [FIXED] Register the logic as a reusable Alpine.js component
            document.addEventListener('alpine:init', () => {
                Alpine.data('calendar', () => ({
                    calendarInstance: null,
                    initCalendar(events) {
                        if (typeof moment === 'undefined' || typeof FullCalendar === 'undefined') {
                            console.error('FullCalendar or Moment.js is not loaded.');
                            return;
                        }

                        moment.loadPersian({usePersianDigits: true, dialect: 'fa'});

                        const calendarEl = this.$refs.calendar;
                        this.calendarInstance = new FullCalendar.Calendar(calendarEl, {
                            headerToolbar: {
                                left: 'prev,next today',
                                center: 'title',
                                right: 'dayGridMonth,timeGridWeek,timeGridDay'
                            },
                            locale: 'fa',
                            initialView: 'dayGridMonth',
                            events: events,
                            eventClick: function(info) {
                                info.jsEvent.preventDefault();
                                if (info.event.url) {
                                    // Use Livewire's navigation for a smoother experience
                                    window.Livewire.navigate(info.event.url);
                                }
                            },
                        });

                        this.calendarInstance.render();
                    }
                }));
            });
        </script>
    <?php $__env->stopPush(); ?>
</div>
</body>
</html>
<?php /**PATH D:\wamp64\www\benchsync\resources\views/livewire/project-calendar.blade.php ENDPATH**/ ?>