<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش بار کاری تیم: <?php echo e($team->name); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo e(asset('css/print.css')); ?>" media="print">
</head>
<body class="bg-gray-100">
<div class="max-w-4xl mx-auto p-8 bg-white shadow-lg my-8">
    <header class="border-b-2 border-gray-800 pb-4 mb-8 text-center">
        <h1 class="text-3xl font-bold text-gray-900">گزارش توزیع بار کاری</h1>
        <p class="text-lg text-gray-700 mt-2">تیم: <span class="font-semibold"><?php echo e($team->name); ?></span></p>
    </header>

    <section>
        <div class="h-96">
            <canvas id="workloadChart"></canvas>
        </div>
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const chartData = <?php echo json_encode($chartData, 15, 512) ?>;
    const ctx = document.getElementById('workloadChart');
    if (ctx && chartData && chartData.labels) {
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: chartData.labels,
                datasets: chartData.datasets,
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                scales: {
                    y: { beginAtZero: true, ticks: { stepSize: 1 } }
                }
            }
        });
    }
</script>
</body>
</html>
<?php /**PATH D:\wamp64\www\benchsync\resources\views/reports/team-workload.blade.php ENDPATH**/ ?>