<div
    x-data="ganttChartComponent(ganttEvents)"
    x-init="init()"
    class="bg-slate-50 dark:bg-gray-900/50 rounded-xl shadow-lg border border-slate-200 dark:border-slate-800 p-6 sm:p-8"
>
    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">نمودار گانت پروژه (شمسی)</h3>

    <div wire:ignore x-ref="calendar" style="min-height: 500px;"></div>

    <!--[if BLOCK]><![endif]--><?php if(empty($calendarEvents)): ?>
        <div class="text-center py-8 border-2 border-dashed border-gray-300 dark:border-gray-700 rounded-lg mt-4">
            <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lucide-bar-chart-horizontal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\BladeUI\Icons\Components\Svg::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mx-auto h-12 w-12 text-gray-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
            <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">داده‌ای برای نمایش وجود ندارد</h3>
            <p class="mt-1 text-sm text-gray-500">برای نمایش نمودار گانت، وظایف باید دارای تاریخ شروع و پایان مشخص باشند.</p>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        // داده‌ها را در یک متغیر جاوا اسکریپت استاندارد قرار می‌دهیم
        const ganttEvents = <?php echo json_encode($calendarEvents, 15, 512) ?>;

        // منطق Alpine را به عنوان یک تابع تعریف می‌کنیم تا خواناتر و قابل اعتمادتر باشد
        function ganttChartComponent(events) {
            return {
                events: events,
                calendar: null,
                init() {
                    this.$nextTick(() => {
                        const calendarEl = this.$refs.calendar;
                        if (!calendarEl || typeof Calendar === 'undefined') {
                            console.error('FullCalendar or calendar element not found.');
                            return;
                        }

                        this.calendar = new Calendar(calendarEl, {
                            plugins: [window.resourceTimelinePlugin], // [UPDATED]
                            initialView: 'timelineMonth', // [UPDATED]
                            locale: window.faLocale,
                            direction: 'rtl',
                            headerToolbar: {
                                left: 'prev,next today',
                                center: 'title',
                                right: 'timelineDay,timelineWeek,timelineMonth' // [UPDATED]
                            },
                            resourceAreaHeaderContent: 'وظایف', // [NEW]
                            resources: [{ id: 'tasks', title: 'لیست وظایف' }], // [NEW]
                            events: this.events,
                            schedulerLicenseKey: 'GPL-My-Project-Is-Open-Source',
                            eventClick: function(info) {
                                Livewire.dispatch('showTaskModal', { task: info.event.id });
                                }
                        });
                        this.calendar.render();
                    });
                }
            }
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\wamp64\www\benchsync\resources\views/livewire/project-gantt-chart.blade.php ENDPATH**/ ?>